/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dmt.dataminer.controls.RowColumnValue;

public class Matrix {
    private Map<Integer, Object> rowMap = new Hashtable<Integer, Object>();
    private Map<Integer, Object> colMap = new Hashtable<Integer, Object>();
    private Map<Object, TreeMap<Object, BigDecimal>> matrixMap = new TreeMap<Object, TreeMap<Object, BigDecimal>>();

    protected Matrix() {
    }

    public boolean isEmpty() {
        return this.matrixMap.isEmpty();
    }

    protected RowColumnValue getRowColumnValue(int n, int n2) {
        Object object = this.rowMap.get(n);
        if (object == null) {
            return null;
        }
        TreeMap<Object, BigDecimal> treeMap = this.matrixMap.get(object);
        if (treeMap == null) {
            return null;
        }
        Object object2 = this.colMap.get(n2);
        if (object2 == null) {
            return null;
        }
        BigDecimal bigDecimal = treeMap.get(object2);
        return new RowColumnValue(object, object2, bigDecimal);
    }

    protected BigDecimal getValue(int n, int n2) {
        Object object = this.rowMap.get(n);
        if (object == null) {
            return null;
        }
        TreeMap<Object, BigDecimal> treeMap = this.matrixMap.get(object);
        if (treeMap == null) {
            return null;
        }
        Object object2 = this.colMap.get(n2);
        if (object2 == null) {
            return null;
        }
        BigDecimal bigDecimal = treeMap.get(object2);
        return bigDecimal;
    }

    protected void setValue(int n, int n2, BigDecimal bigDecimal) {
        Object object = this.rowMap.get(n);
        if (object == null) {
            return;
        }
        TreeMap<Object, BigDecimal> treeMap = this.matrixMap.get(object);
        if (treeMap == null) {
            return;
        }
        Object object2 = this.colMap.get(n2);
        if (object2 == null) {
            return;
        }
        this.addCol(object2, treeMap, bigDecimal);
    }

    protected void addValue(Object object, Object object2, BigDecimal bigDecimal) {
        TreeMap<Object, BigDecimal> treeMap = this.matrixMap.get(object);
        if (treeMap == null) {
            treeMap = new TreeMap();
            this.addRow(object, treeMap);
        }
        this.addCol(object2, treeMap, bigDecimal);
    }

    protected Matrix(Matrix matrix) {
        for (Map.Entry<Object, TreeMap<Object, BigDecimal>> entry : matrix.matrixMap.entrySet()) {
            Object object = entry.getKey();
            TreeMap<Object, BigDecimal> treeMap = entry.getValue();
            TreeMap<Object, BigDecimal> treeMap2 = new TreeMap<Object, BigDecimal>();
            this.addRow(object, treeMap2);
            for (Map.Entry<Object, BigDecimal> entry2 : treeMap.entrySet()) {
                Object object2 = entry2.getKey();
                BigDecimal bigDecimal = entry2.getValue();
                this.addCol(object2, treeMap2, new BigDecimal(bigDecimal.toString()));
            }
        }
    }

    protected boolean equals(Matrix matrix) {
        if (matrix == null) {
            return false;
        }
        if (this.matrixMap.size() != matrix.matrixMap.size()) {
            return false;
        }
        boolean bl = true;
        block0: for (Map.Entry<Object, TreeMap<Object, BigDecimal>> entry : matrix.matrixMap.entrySet()) {
            if (!bl) break;
            Object object = entry.getKey();
            TreeMap<Object, BigDecimal> treeMap = entry.getValue();
            TreeMap<Object, BigDecimal> treeMap2 = this.matrixMap.get(object);
            if (treeMap2 == null) {
                bl = false;
                break;
            }
            for (Map.Entry<Object, BigDecimal> entry2 : treeMap.entrySet()) {
                Object object2 = entry2.getKey();
                BigDecimal bigDecimal = entry2.getValue();
                BigDecimal bigDecimal2 = treeMap2.get(object2);
                if (bigDecimal2 == null) {
                    bl = false;
                    continue block0;
                }
                if (bigDecimal.equals(bigDecimal2)) continue;
                bl = false;
                continue block0;
            }
        }
        return bl;
    }

    protected void addRow(Object object, TreeMap<Object, BigDecimal> treeMap) {
        this.matrixMap.put(object, treeMap);
        this.rebuildRowIndexes();
    }

    protected void rebuildRowIndexes() {
        this.rowMap.clear();
        Set<Object> set = this.matrixMap.keySet();
        Iterator<Object> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.rowMap.put(n++, object);
        }
    }

    protected void addCol(Object object, TreeMap<Object, BigDecimal> treeMap, BigDecimal bigDecimal) {
        treeMap.put(object, bigDecimal);
        this.rebuildColumnIndexes(treeMap);
    }

    protected void rebuildColumnIndexes(TreeMap<Object, BigDecimal> treeMap) {
        this.colMap.clear();
        Set<Object> set = treeMap.keySet();
        Iterator<Object> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.colMap.put(n++, object);
        }
    }

    protected Object[] getRowKeys() {
        if (this.matrixMap != null && !this.matrixMap.isEmpty()) {
            return this.matrixMap.keySet().toArray(new String[this.matrixMap.size()]);
        }
        return null;
    }

    protected int getRowCount() {
        return this.rowMap.size();
    }

    protected int geColumnCount() {
        return this.colMap.size();
    }

    protected void clear() {
        this.matrixMap.clear();
        this.rowMap.clear();
        this.colMap.clear();
    }

    protected Vector<Vector<BigDecimal>> toVector() {
        if (this.matrixMap == null) {
            return null;
        }
        Collection<TreeMap<Object, BigDecimal>> collection = this.matrixMap.values();
        if (collection == null) {
            return null;
        }
        Vector<Vector<BigDecimal>> vector = new Vector<Vector<BigDecimal>>();
        for (TreeMap<Object, BigDecimal> treeMap : collection) {
            Collection<BigDecimal> collection2 = treeMap.values();
            Vector<BigDecimal> vector2 = new Vector<BigDecimal>(collection2);
            vector.add(vector.size(), vector2);
        }
        return vector;
    }

    protected void updateColumn(Object object, BigDecimal bigDecimal) {
        if (this.matrixMap == null) {
            return;
        }
        Set<Object> set = this.matrixMap.keySet();
        for (Object object2 : set) {
            if (object2.equals(object)) continue;
            TreeMap<Object, BigDecimal> treeMap = this.matrixMap.get(object2);
            treeMap.put(object, bigDecimal);
        }
    }

    protected void updateRow(Object object, BigDecimal bigDecimal) {
        if (this.matrixMap == null) {
            return;
        }
        TreeMap<Object, BigDecimal> treeMap = this.matrixMap.get(object);
        if (treeMap == null) {
            return;
        }
        Set<Object> set = treeMap.keySet();
        for (Object object2 : set) {
            if (object.equals(object2)) continue;
            this.addCol(object2, treeMap, bigDecimal);
        }
    }
}

