/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.util.List;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.model.DataGuideProvider;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.CreateTableNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideGenEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideInfoType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.DataGuideType;
import oracle.dmt.dataminer.workflow.xmlschema.DataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONColumnsType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;

public class JSONHelper {
    public static String JSON_DATA_GUIDE_NOT_GENERATED = ControlsLrb.get("JSON_DATA_GUIDE_NOT_GENERATED");
    private static String JSON_USER_DEIFNED_DATA_GUIDE_AVAILABLE = ControlsLrb.get("JSON_USER_DEIFNED_DATA_GUIDE_AVAILABLE");
    private static String JSON_SYSTEM_DEIFNED_DATA_GUIDE_AVAILABLE = ControlsLrb.get("JSON_SYSTEM_DEIFNED_DATA_GUIDE_AVAILABLE");
    public static String WARNING_NOT_EQUAL_SUB_GROUP_BY_LISTS = ControlsLrb.get("JSON_WARNING_NOT_EQUAL_SUB_GROUP_BY_LISTS");

    public static DataGuideSettingsType initDataGuideSettings() {
        DataGuideSettingsType dataGuideSettingsType = new DataGuideSettingsType();
        dataGuideSettingsType.setGenerate(true);
        dataGuideSettingsType.setUseFullData(false);
        dataGuideSettingsType.setNumberOfRows(Long.valueOf(2000L));
        dataGuideSettingsType.setUseFullDoc(false);
        dataGuideSettingsType.setNumberOfValues(Long.valueOf(10000L));
        dataGuideSettingsType.setPercentOfTotal(Double.valueOf(100.0));
        DataGuideType dataGuideType = new DataGuideType();
        dataGuideSettingsType.setStopPaths(dataGuideType);
        return dataGuideSettingsType;
    }

    public static boolean equalDataGuideSettings(DataGuideSettingsType dataGuideSettingsType, DataGuideSettingsType dataGuideSettingsType2) {
        if (dataGuideSettingsType == null && dataGuideSettingsType2 == null) {
            return true;
        }
        if (dataGuideSettingsType == null && dataGuideSettingsType2 != null || dataGuideSettingsType != null && dataGuideSettingsType2 == null) {
            return false;
        }
        return dataGuideSettingsType.isGenerate() == dataGuideSettingsType2.isGenerate() && dataGuideSettingsType.isUseFullData() == dataGuideSettingsType2.isUseFullData() && dataGuideSettingsType.isUseFullDoc() == dataGuideSettingsType2.isUseFullDoc() && (dataGuideSettingsType.getNumberOfRows() != null && dataGuideSettingsType2.getNumberOfRows() != null && dataGuideSettingsType.getNumberOfRows().longValue() == dataGuideSettingsType2.getNumberOfRows().longValue() || dataGuideSettingsType.getNumberOfRows() == null && dataGuideSettingsType2.getNumberOfRows() == null) && (dataGuideSettingsType.getNumberOfValues() != null && dataGuideSettingsType2.getNumberOfValues() != null && dataGuideSettingsType.getNumberOfValues().longValue() == dataGuideSettingsType2.getNumberOfValues().longValue() || dataGuideSettingsType.getNumberOfValues() == null && dataGuideSettingsType2.getNumberOfValues() == null);
    }

    public static DataGuideSettingsType copyDataGuideSettings(DataGuideSettingsType dataGuideSettingsType) {
        DataGuideSettingsType dataGuideSettingsType2 = new DataGuideSettingsType();
        dataGuideSettingsType2.setGenerate(dataGuideSettingsType.isGenerate());
        dataGuideSettingsType2.setUseFullData(dataGuideSettingsType.isUseFullData());
        dataGuideSettingsType2.setNumberOfRows(dataGuideSettingsType.getNumberOfRows());
        dataGuideSettingsType2.setUseFullDoc(dataGuideSettingsType.isUseFullDoc());
        dataGuideSettingsType2.setNumberOfValues(dataGuideSettingsType.getNumberOfValues());
        dataGuideSettingsType2.setPercentOfTotal(dataGuideSettingsType.getPercentOfTotal());
        DataGuideType dataGuideType = JSONHelper.copyDataGuideType(dataGuideSettingsType.getStopPaths());
        dataGuideSettingsType2.setStopPaths(dataGuideType);
        return dataGuideSettingsType2;
    }

    public static DataGuideType copyDataGuideType(DataGuideType dataGuideType) {
        DataGuideType dataGuideType2 = new DataGuideType();
        if (dataGuideType != null) {
            dataGuideType2.getItem().addAll(dataGuideType.getItem());
        }
        return dataGuideType2;
    }

    public static String isDataGuideAvailable(DataGuideProvider dataGuideProvider, AttributeType attributeType) {
        String string = JSON_DATA_GUIDE_NOT_GENERATED;
        DataGuideInfoType dataGuideInfoType = dataGuideProvider.getJSONAttrDataGuideInfoType(attributeType);
        if (dataGuideInfoType != null) {
            DataGuideInfoType.System system = dataGuideInfoType.getSystem();
            if (system != null) {
                String string2 = system.getDataGuideTable();
                if (string2 != null) {
                    string = JSON_SYSTEM_DEIFNED_DATA_GUIDE_AVAILABLE;
                }
            } else {
                DataGuideInfoType.Custom custom = dataGuideInfoType.getCustom();
                if (custom != null && null != custom.getDataGuide() && !custom.getDataGuide().getItem().isEmpty()) {
                    string = JSON_USER_DEIFNED_DATA_GUIDE_AVAILABLE;
                }
            }
        }
        return string;
    }

    public static JSONColumnsType.Attribute findJSONColumn(JSONColumnsType jSONColumnsType, AttributeType attributeType) {
        JSONColumnsType.Attribute attribute = null;
        if (jSONColumnsType == null) {
            return null;
        }
        for (JSONColumnsType.Attribute attribute2 : jSONColumnsType.getAttribute()) {
            if (!attribute2.getName().equals(attributeType.getName()) && !attribute2.getName().equals(attributeType.getAlias())) continue;
            attribute = attribute2;
            break;
        }
        return attribute;
    }

    public static JSONColumnsType.Attribute copyJSONColumnsTypeAttribute(JSONColumnsType.Attribute attribute) {
        JSONColumnsType.Attribute attribute2 = new JSONColumnsType.Attribute();
        attribute2.setName(attribute.getName());
        DataGuideInfoType dataGuideInfoType = (DataGuideInfoType)MetaDataHelper.copyMetadataObject(attribute.getDataGuideInfo());
        attribute2.setDataGuideInfo(dataGuideInfoType);
        return attribute2;
    }

    public static DataGuideInfoType getDefaultDataGuideInfo() {
        DataGuideInfoType dataGuideInfoType = new DataGuideInfoType();
        dataGuideInfoType.setSystem(new DataGuideInfoType.System());
        dataGuideInfoType.setGenerate(DataGuideGenEnumType.DEFAULT);
        dataGuideInfoType.setStatus(ModelStatusType.READY);
        return dataGuideInfoType;
    }

    public static JSONColumnsType getJSONColumnsType(DataNodeType dataNodeType) {
        if (dataNodeType instanceof DataSourceNodeType) {
            return ((DataSourceNodeType)dataNodeType).getJSONColumns();
        }
        if (dataNodeType instanceof CreateTableNodeType) {
            return ((CreateTableNodeType)dataNodeType).getJSONColumns();
        }
        return null;
    }

    public static boolean equalDataGuideInfoType(DataGuideInfoType dataGuideInfoType, DataGuideInfoType dataGuideInfoType2) {
        if (null != dataGuideInfoType.getCustom() && null != dataGuideInfoType2.getCustom() && !JSONHelper.equalDataGuideType(dataGuideInfoType.getCustom().getDataGuide(), dataGuideInfoType2.getCustom().getDataGuide())) {
            return false;
        }
        if (null != dataGuideInfoType.getSystem() && null != dataGuideInfoType2.getSystem()) {
            if (dataGuideInfoType.getSystem().getDataGuideTable() != null && dataGuideInfoType2.getSystem().getDataGuideTable() != null) {
                if (!dataGuideInfoType.getSystem().getDataGuideTable().equals(dataGuideInfoType2.getSystem().getDataGuideTable())) {
                    return false;
                }
                if (null == dataGuideInfoType.getSystem().getDataGuide() || null == dataGuideInfoType.getSystem().getDataGuide()) {
                    return false;
                }
                if (!JSONHelper.equalDataGuideType(dataGuideInfoType.getSystem().getDataGuide(), dataGuideInfoType2.getSystem().getDataGuide())) {
                    return false;
                }
            } else if (!(dataGuideInfoType.getSystem().getDataGuideTable() == null && dataGuideInfoType2.getSystem().getDataGuideTable() == null)) {
                return false;
            }
        }
        if (!dataGuideInfoType.getGenerate().equals((Object)dataGuideInfoType2.getGenerate())) {
            return false;
        }
        return (null == dataGuideInfoType || null != dataGuideInfoType2) && (null != dataGuideInfoType || null == dataGuideInfoType2);
    }

    public static boolean equalDataGuideType(DataGuideType dataGuideType, DataGuideType dataGuideType2) {
        if (null == dataGuideType.getItem() && null == dataGuideType2.getItem()) {
            return true;
        }
        if (null != dataGuideType.getItem() && null != dataGuideType2.getItem()) {
            List list = dataGuideType.getItem();
            List list2 = dataGuideType2.getItem();
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                DataGuideType.Item item = (DataGuideType.Item)list.get(i);
                DataGuideType.Item item2 = (DataGuideType.Item)list2.get(i);
                if (!item.getPath().equals(item2.getPath())) {
                    return false;
                }
                if (item.getType().equals(item2.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static JSONColumnsType copyJSONColumnsType(JSONColumnsType jSONColumnsType) {
        if (jSONColumnsType == null) {
            return new JSONColumnsType();
        }
        JSONColumnsType jSONColumnsType2 = new JSONColumnsType();
        if (jSONColumnsType != null) {
            for (JSONColumnsType.Attribute attribute : jSONColumnsType.getAttribute()) {
                JSONColumnsType.Attribute attribute2 = JSONHelper.copyJSONColumnsTypeAttribute(attribute);
                jSONColumnsType2.getAttribute().add(attribute2);
            }
        }
        return jSONColumnsType2;
    }

    public static boolean areEqual(JSONAttributeType jSONAttributeType, JSONAttributeType jSONAttributeType2) {
        String string = jSONAttributeType.getDBDataType();
        String string2 = jSONAttributeType.getDataType();
        String string3 = jSONAttributeType.getPath();
        AttributeStatus attributeStatus = jSONAttributeType.getStatus();
        String string4 = jSONAttributeType2.getDBDataType();
        String string5 = jSONAttributeType2.getDataType();
        String string6 = jSONAttributeType2.getPath();
        AttributeStatus attributeStatus2 = jSONAttributeType2.getStatus();
        return string.equals(string4) && string2.equals(string5) && string3.equals(string6) && attributeStatus.value().equals(attributeStatus2.value());
    }

    public static boolean areEqual(List<JSONAttributeType> list, List<JSONAttributeType> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (!(list != null && list2 != null)) {
            return false;
        }
        if (list.isEmpty() && list2.isEmpty()) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        boolean bl = true;
        for (JSONAttributeType jSONAttributeType : list) {
            boolean bl2 = false;
            for (JSONAttributeType jSONAttributeType2 : list2) {
                if (!JSONHelper.areEqual(jSONAttributeType, jSONAttributeType2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static String isSameSubGroupBy(AggregationElementsExType aggregationElementsExType) {
        String string = "";
        if (aggregationElementsExType != null && !aggregationElementsExType.getAggregationElement().isEmpty()) {
            List list = null;
            int n = 0;
            for (AggregationElementsExType.AggregationElement aggregationElement : aggregationElementsExType.getAggregationElement()) {
                List list2 = null;
                if (n == 0) {
                    if (null != aggregationElement.getSubGroupBy()) {
                        list = aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute();
                    }
                } else {
                    list2 = aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute();
                }
                if (n > 0 && !JSONHelper.areEqual(list, list2)) {
                    string = WARNING_NOT_EQUAL_SUB_GROUP_BY_LISTS;
                    break;
                }
                ++n;
            }
        }
        return string;
    }
}

