/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dmt.dataminer.workflow.dialog.AbstractPanel;
import oracle.dmt.dataminer.workflow.dialog.WorkflowDialogLrb;
import oracle.dmt.dataminer.workflow.dialog.apply.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class DialogDisplayer<T extends AbstractNode>
extends AbstractPanel<T> {
    private static final Logger LOGGER = Logger.getLogger(DialogDisplayer.class.getName());
    private DialogHandler handler;
    private JEWTDialog dialog;

    public DialogDisplayer() {
    }

    public DialogDisplayer(Context context, T t) {
        super(context, t);
    }

    private JEWTDialog buildDialog(Component component) {
        if (component == null) {
            component = Ide.getMainWindow();
        }
        this.dialog = JEWTDialog.createDialog((Component)component, (String)this.getDialogTitle(), (int)this.getDialogButtonMask());
        this.dialog.setContent((Component)this);
        String string = this.getHelpTopic();
        int n = this.getDialogButtonMask();
        if ((n & 4) > 0) {
            if (string == null || string.isEmpty()) {
                LOGGER.log(Level.WARNING, "Help topic is required for the specified button mask");
            } else {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, string);
            }
        }
        return this.dialog;
    }

    private JEWTDialog customizeDialog(JEWTDialog jEWTDialog) {
        this.customizeDialogProperties(jEWTDialog);
        this.customizeDialogListeners(jEWTDialog);
        return jEWTDialog;
    }

    private boolean invoke(JEWTDialog jEWTDialog) {
        return WizardLauncher.runDialog((JDialog)jEWTDialog);
    }

    protected void onFailure(Exception exception) {
        ExceptionDialog.showExceptionDialog((Component)this.getDialogInstance(), (Throwable)exception, (String)DialogsLrb.get("ERROR_TITLE"), (String)WorkflowDialogLrb.get("UNEXPECTED_ERROR_MESG"), null);
    }

    protected void customizeDialogProperties(JEWTDialog jEWTDialog) {
        jEWTDialog.setResizable(true);
    }

    protected void customizeDialogListeners(JEWTDialog jEWTDialog) {
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                String string = propertyChangeEvent.getPropertyName();
                Object object = propertyChangeEvent.getNewValue();
                if (string.equals("closed") && Boolean.TRUE.equals(object)) {
                    try {
                        if (!DialogDisplayer.this.doWork()) {
                            throw new PropertyVetoException("panel", propertyChangeEvent);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        throw propertyVetoException;
                    }
                    catch (Exception exception) {
                        DialogDisplayer.this.onFailure(exception);
                        throw new PropertyVetoException("panel", propertyChangeEvent);
                    }
                }
            }
        });
    }

    protected boolean doWork() {
        if (this.handler != null) {
            return this.handler.doWork();
        }
        return true;
    }

    protected void doCancel() {
    }

    protected int getDialogButtonMask() {
        return 7;
    }

    protected abstract String getDialogTitle();

    protected abstract String getHelpTopic();

    public boolean showAsDialog(Component component) {
        try {
            boolean bl = this.invoke(this.customizeDialog(this.buildDialog(component)));
            if (!bl) {
                this.doCancel();
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.onFailure(exception);
            return false;
        }
    }

    public boolean showAsDialog() {
        return this.showAsDialog(null);
    }

    protected JEWTDialog getDialogInstance() {
        return this.dialog;
    }

    public Window getParentWindow() {
        return this.dialog == null ? Ide.getMainWindow() : this.dialog;
    }

    public void setHandler(DialogHandler dialogHandler) {
        this.handler = dialogHandler;
    }

    public static interface DialogHandler {
        public boolean doWork();
    }
}

