/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.math.BigDecimal;
import java.util.Vector;
import oracle.dmt.dataminer.controls.Matrix;
import oracle.dmt.dataminer.controls.RowColumnValue;
import oracle.dmt.dataminer.server.ServerConstants;

public final class CostMatrixInfo {
    protected String _optionValue;
    protected String _type;
    public static final CostMatrixInfo _NONE = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_NONE");
    private Matrix _costMatrixMap = new Matrix();

    public CostMatrixInfo(String string) {
        this._optionValue = string;
    }

    public String getOptionValue() {
        return this._optionValue;
    }

    public String getType() {
        return this._type;
    }

    public boolean isCostMatrixTrue() {
        return ServerConstants.BuildSettingCostBenefitOption.isCostMatrixTrue(this._optionValue);
    }

    public Object[] getTargetValues() {
        return this._costMatrixMap.getRowKeys();
    }

    public int getRowCount() {
        return this._costMatrixMap.getRowCount();
    }

    public int geColumnCount() {
        return this._costMatrixMap.geColumnCount();
    }

    public CostMatrixInfo(CostMatrixInfo costMatrixInfo) {
        this._optionValue = costMatrixInfo._optionValue;
        this._type = costMatrixInfo._type;
        if (costMatrixInfo._costMatrixMap == null) {
            return;
        }
        this._costMatrixMap = new Matrix(costMatrixInfo._costMatrixMap);
    }

    public boolean equals(CostMatrixInfo costMatrixInfo) {
        if (0 != costMatrixInfo.getOptionValue().compareTo(this.getOptionValue())) {
            return false;
        }
        if (costMatrixInfo.getType() != null && this.getType() != null && 0 != costMatrixInfo.getType().compareTo(this.getType())) {
            return false;
        }
        return this._costMatrixMap.equals(costMatrixInfo._costMatrixMap);
    }

    public void setType(String string) {
        this._type = string;
    }

    public void clear() {
        if (this._costMatrixMap != null) {
            this._costMatrixMap.clear();
        }
        this._costMatrixMap = null;
    }

    public void put(Object object, Object object2, BigDecimal bigDecimal) {
        this._costMatrixMap.addValue(object, object2, bigDecimal);
    }

    public BigDecimal getValue(int n, int n2) {
        return this._costMatrixMap.getValue(n, n2);
    }

    public RowColumnValue getRowColumnValue(int n, int n2) {
        return this._costMatrixMap.getRowColumnValue(n, n2);
    }

    public void setValue(int n, int n2, BigDecimal bigDecimal) {
        this._costMatrixMap.setValue(n, n2, bigDecimal);
    }

    public void updateRow(Object object, BigDecimal bigDecimal) {
        this._costMatrixMap.updateRow(object, bigDecimal);
    }

    public void updateColumn(Object object, BigDecimal bigDecimal) {
        this._costMatrixMap.updateColumn(object, bigDecimal);
    }

    public Vector<Vector<BigDecimal>> toVector() {
        return this._costMatrixMap.toVector();
    }

    public boolean isEmpty() {
        return this._costMatrixMap.isEmpty();
    }
}

