/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.common.vo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.workflow.model.NodeMessagesLrb;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;

public class TableVO {
    private static final String TABLE_PROMPT = NodeMessagesLrb.get("DATASRC_SELECT_TABLE");
    private TableType tableType = new TableType();
    private String type;
    private String synonymName;
    private String synonymSchema;
    private Map<String, AttributeType> columns;

    public TableVO(String string, String string2) {
        this(string, string2, null, null);
    }

    public TableVO(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public TableVO(String string, String string2, Map<String, AttributeType> map) {
        this(string, string2, null, map);
    }

    public TableVO(String string, String string2, String string3, Map<String, AttributeType> map) {
        this.tableType.setSchema(string);
        this.tableType.setName(string2);
        this.tableType.setSynonym(Boolean.valueOf(CommonLrb.get("COMMON_SYNONYM_UP").equals(string3)));
        this.type = string3;
        this.columns = map;
    }

    public TableVO(TableType tableType) {
        this.tableType.setSchema(tableType.getSchema());
        this.tableType.setName(tableType.getName());
        this.tableType.setSynonym(tableType.isSynonym());
    }

    public String getSchema() {
        return this.tableType.getSchema();
    }

    public void setSchema(String string) {
        this.tableType.setSchema(string);
    }

    public String getName() {
        return this.tableType.getName();
    }

    public void setName(String string) {
        this.tableType.setName(string);
    }

    public Boolean isSynonym() {
        Boolean bl = this.tableType.isSynonym();
        return bl != null ? bl : Boolean.FALSE;
    }

    public void setSynonym(Boolean bl) {
        this.tableType.setSynonym(bl);
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setSynonymName(String string) {
        this.synonymName = string;
    }

    public String getSynonymName() {
        return this.synonymName;
    }

    public void setSynonymSchema(String string) {
        this.synonymSchema = string;
    }

    public String getSynonymSchema() {
        return this.synonymSchema;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public String getFullName() {
        return this.tableType.getSchema() + "." + this.tableType.getName();
    }

    public List<AttributeType> getColumnList() {
        Collection<AttributeType> collection = this.columns.values();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>(collection.size());
        arrayList.addAll(collection);
        return arrayList;
    }

    public Map<String, AttributeType> getColumns() {
        return this.columns;
    }

    public void setColumns(Map<String, AttributeType> map) {
        this.columns = map;
    }

    public boolean equals(Object object) {
        if (object instanceof TableVO) {
            boolean bl = false;
            TableVO tableVO = (TableVO)object;
            if ((tableVO.getSchema() == null && this.tableType.getSchema() == null || tableVO.getSchema() != null && tableVO.getSchema().equals(this.tableType.getSchema())) && (tableVO.getName() == null && this.tableType.getName() == null || tableVO.getName() != null && tableVO.getName().equals(this.tableType.getName())) && (tableVO.type == null && this.type == null || tableVO.type != null && tableVO.type.equals(this.type))) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n += this.tableType.getSchema() != null ? this.tableType.getSchema().hashCode() : 0;
        n += this.tableType.getName() != null ? this.tableType.getName().hashCode() : 0;
        return n += this.type != null ? this.type.hashCode() : 0;
    }

    public String toString() {
        if (this.tableType.getSchema() == null || this.tableType.getName() == null) {
            return TABLE_PROMPT;
        }
        return this.tableType.getSchema() + "." + this.tableType.getName();
    }
}

