/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizCommon;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.DpWizardArb;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizMain;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.exp.DpExpWizSource;
import oracle.dbtools.raptor.dba.navigator.wizzards.datapump.imp.ImportDirectoriesUI;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class DpImpWizType
extends DefaultTraversablePanel {
    private ImportDirectoriesUI iOD = new ImportDirectoriesUI();
    private ExtractListModel _listModel = null;
    private JRadioButton _rbFull = new JRadioButton(DpWizardArb.getString("IMP_FULL"));
    private JRadioButton _rbTablespace = new JRadioButton(DpWizardArb.getString("EXP_TABLESPACE"));
    private JRadioButton _rbSchema = new JRadioButton(DpWizardArb.getString("EXP_SCHEMA"));
    private JRadioButton _rbTable = new JRadioButton(DpWizardArb.getString("EXP_TABLE"));
    private ButtonGroup _bGroup = null;
    private DpExpWizSource.MetadataEnum _storeMeta = DpExpWizSource.MetadataEnum.BOTH;
    private DBConnectionComboBox _connSelector;
    private JComboBox _connCombo;
    private JComboBox _dataMeta;
    private JPanel _jp = null;
    private Boolean _isSYS = null;
    private Boolean _isPrivileged = null;
    private String[] _gotDirectories;
    private TraversableContext _dataContext;
    private JTextField jName = new JTextField(20);

    DpImpWizType() {
        this.buildUI();
    }

    void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setLayout(new GridBagLayout());
        this._rbTable.setSelected(false);
        this._rbTablespace.setSelected(false);
        this._rbSchema.setSelected(false);
        this._rbFull.setSelected(true);
        this._bGroup = new ButtonGroup();
        this._bGroup.add(this._rbFull);
        this._bGroup.add(this._rbSchema);
        this._bGroup.add(this._rbTable);
        this._bGroup.add(this._rbTablespace);
        this._dataMeta = new JComboBox<String>(new String[]{DpWizardArb.getString("EXP_DDL_COMBO_BOTH"), DpWizardArb.getString("EXP_DDL_COMBO_DATA"), DpWizardArb.getString("EXP_DDL_COMBO_DLL")});
        this._connSelector = new OracleConnectionComboBox();
        this._connCombo = this._connSelector.getJComboBox();
        this._connCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DpImpWizType.this.connectionChanged(actionEvent);
            }
        });
        this._jp = new JPanel();
        this._jp.setLayout(new GridBagLayout());
        this._jp.add(Box.createVerticalGlue(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.3, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._jp.add((Component)this._rbFull, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_START_FULL_SUB));
        this._jp.add((Component)this._rbSchema, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_FULL_SUB));
        this._jp.add((Component)this._rbTable, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_FULL_SUB));
        this._jp.add((Component)this._rbTablespace, LayoutControl.GBC.gbc((int)0, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.PAGE_END_FULL_SUB));
        this._jp.setBorder(BorderFactory.createTitledBorder(DpWizardArb.getString("IMP_TYPE_LABEL")));
        this.add(new JLabel(DpWizardArb.getString("EXP_CONNECTION")), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START));
        this.add(this._connCombo, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_END_LABEL2CONTROL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        JLabel jLabel = new JLabel(DpWizardArb.getString("EXP_JOB_NAME_NO_COLON"));
        this.add(jLabel, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START));
        this.add(this.jName, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_END_LABEL2CONTROL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.Y));
        jLabel.setLabelFor(this.jName);
        this.add(new JLabel(DpWizardArb.getString("EXP_DDL_LABEL")), LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START));
        this.add(this._dataMeta, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_END_LABEL2CONTROL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this.add(this._jp, LayoutControl.GBC.gbc((int)0, (int)3, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_FULL, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.Y, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(this.iOD, LayoutControl.GBC.gbc((int)0, (int)6, (int)3, (int)3, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.Y, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.FIRST_LINE_START));
        this.add(Box.createVerticalGlue(), LayoutControl.GBC.gbc((int)0, (int)10, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
    }

    public void connectionChanged(ActionEvent actionEvent) {
        String string = this._connSelector.getCurrentConnectionName();
        if (string == null || string.equals("")) {
            return;
        }
        String string2 = (String)this._listModel.getPropertyValue("KEY_CNAME");
        if (string2 != null && !string2.equals(string)) {
            this._listModel = new ExtractListModel();
            this._dataContext.put("KEY_EXPORT_OBJECTS", (Object)this._listModel);
        }
        boolean bl = false;
        if (string2 == null || !string2.equals(string)) {
            bl = true;
        }
        this._listModel.setProperty("KEY_CNAME", (Object)string);
        if (!bl) {
            return;
        }
        DatabaseQueryTask<TraversalException> databaseQueryTask = new DatabaseQueryTask<TraversalException>(DpWizardArb.getString("EXP_GET_DATABASE_SETTINGS"), IRaptorTaskRunMode.MODAL, false, false){

            public void canProceedTask() throws ExecutionException {
                this.checkCanProceed();
            }

            protected TraversalException doWork() throws TaskException {
                TraversalException traversalException = null;
                try {
                    DpWizCommon.setupConnection(DpImpWizType.this._listModel, false);
                }
                catch (TraversalException traversalException2) {
                    traversalException = traversalException2;
                }
                return traversalException;
            }

            public String getQuery() {
                return DpWizardArb.getString("EXP_GET_DATABASE_SETTINGS");
            }

            public String getConnectionName() {
                return (String)DpImpWizType.this._listModel.getPropertyValue("KEY_CNAME");
            }
        };
        RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter((DatabaseQueryTask)databaseQueryTask){
            final /* synthetic */ DatabaseQueryTask val$task;
            {
                this.val$task = databaseQueryTask;
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TraversalException traversalException = null;
                        String string = null;
                        try {
                            traversalException = (TraversalException)((Object)val$task.getResult());
                        }
                        catch (InterruptedException interruptedException) {
                            string = DpWizardArb.getString("IMP_EXCEPTION_OCCURRED");
                            traversalException = new TraversalException(DpWizardArb.format("IMP_EXCEPTION", interruptedException.getLocalizedMessage()), string);
                        }
                        catch (ExecutionException executionException) {
                            string = DpWizardArb.getString("IMP_EXCEPTION_OCCURRED");
                            traversalException = new TraversalException(DpWizardArb.format("IMP_EXCEPTION", executionException.getLocalizedMessage()), string);
                        }
                        if (traversalException != null) {
                            traversalException.showMessageDialog((Component)((Object)DpImpWizType.this));
                            return;
                        }
                        try {
                            DpImpWizType.this.connectionChangedUI();
                            DpImpWizType.this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TraversalException traversalException = new TraversalException(DpWizardArb.getString("IMP_TASK_FAILED"), DpWizardArb.getString("IMP_TASK_FAILED"));
                        traversalException.showMessageDialog((Component)((Object)DpImpWizType.this));
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TraversalException traversalException = new TraversalException(DpWizardArb.getString("IMP_TASK_CANCELLED_CANCEL_WIZARD"), DpWizardArb.getString("IMP_TASK_CANCELLED"));
                        traversalException.showMessageDialog((Component)((Object)DpImpWizType.this));
                    }
                });
            }
        };
        databaseQueryTask.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        RaptorTaskManager.getInstance().addTask((RaptorTask)databaseQueryTask);
    }

    public void connectionChangedUI() {
        this.jName.setText((String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_GEN_NAME", ""));
        this._isSYS = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_IS_SYS", Boolean.FALSE);
        if (this._isSYS.equals(Boolean.TRUE)) {
            this._rbTablespace.setEnabled(false);
            this._rbFull.setEnabled(false);
            this._rbTable.setEnabled(false);
            this._rbSchema.setEnabled(false);
        } else {
            this._isPrivileged = (Boolean)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_IS_PRIV", Boolean.FALSE);
            if (this._isPrivileged.equals(Boolean.TRUE)) {
                this._rbTablespace.setEnabled(true);
                this._rbFull.setEnabled(true);
                this._rbTable.setEnabled(true);
                this._rbSchema.setEnabled(true);
            } else {
                this._rbTablespace.setEnabled(false);
                this._rbFull.setEnabled(true);
                if (this._rbTablespace.isSelected()) {
                    this._rbTable.setSelected(true);
                }
                this._rbTable.setEnabled(true);
                this._rbSchema.setEnabled(true);
            }
        }
        this.iOD.setDirectories(DpWizCommon.getDirectories(this._dataContext));
        this.iOD.onEntry(this._dataContext);
    }

    public void onEntry(final TraversableContext traversableContext) {
        this._dataContext = traversableContext;
        this._listModel = (ExtractListModel)DpExpWizMain.getOrInitializeContext(traversableContext, "KEY_EXPORT_OBJECTS", new ExtractListModel());
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD);
        extractDataFormat.setFormat(BaseDataFormat.DATAPUMP);
        extractDataFormat.isExportEnabled(true);
        this._listModel.setDataFormat(extractDataFormat);
        super.onEntry(traversableContext);
        this._rbTable.setSelected(false);
        this._rbTablespace.setSelected(false);
        this._rbSchema.setSelected(false);
        this._rbFull.setSelected(false);
        String string = (String)DpWizCommon.getOrInitializeList(this._listModel, "DP_KEY_BRANCH", "DP_TABLE");
        if (string.equals("IMP_FULL")) {
            this._rbFull.setSelected(true);
        } else if (string.equals("DP_TABLESPACE")) {
            this._rbTablespace.setSelected(true);
        } else if (string.equals("DP_SCHEMA")) {
            this._rbSchema.setSelected(true);
        } else if (string.equals("DP_TABLE")) {
            this._rbTable.setSelected(true);
        }
        this._storeMeta = (DpExpWizSource.MetadataEnum)((Object)DpWizCommon.getOrInitializeList(this._listModel, "DP_KEY_STOREMETA", (Object)DpExpWizSource.MetadataEnum.BOTH));
        int n = 0;
        switch (this._storeMeta) {
            case BOTH: {
                n = 0;
                break;
            }
            case DATA: {
                n = 1;
                break;
            }
            case DDL: {
                n = 2;
            }
        }
        this._dataMeta.setSelectedItem(n);
        this._connCombo = this._connSelector.getJComboBox();
        String string2 = (String)this._listModel.getPropertyValue("KEY_CNAME");
        String string3 = (String)DpWizCommon.getOrInitializeList(this._listModel, "DP_EXP_JNAME", "");
        this.jName.setText(string3);
        if (string2 != null) {
            this._connCombo.setSelectedItem(string2);
        } else {
            WaitCursor waitCursor = new WaitCursor((Component)((Object)this));
            RaptorTask<String> raptorTask = new RaptorTask<String>(DpWizardArb.getString("EXP_GET_DATABASE_SETTINGS"), true, IRaptorTaskRunMode.TASKVIEWER){

                protected String doWork() throws TaskException {
                    String string;
                    block5: {
                        string = null;
                        try {
                            Connection connection = ((DBObject)traversableContext.get("DBOBJECT")).getConnection();
                            if (!Connections.getInstance().lock(connection)) break block5;
                            try {
                                string = Connections.getInstance().getConnectionName(connection);
                            }
                            finally {
                                Connections.getInstance().unlock(connection);
                            }
                        }
                        catch (Exception exception) {
                            throw new TaskException((Throwable)exception);
                        }
                    }
                    return string;
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask, waitCursor){
                final /* synthetic */ RaptorTask val$task;
                final /* synthetic */ WaitCursor val$wc;
                {
                    this.val$task = raptorTask;
                    this.val$wc = waitCursor;
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    this.cleanup(true, null);
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    Throwable throwable;
                    Throwable throwable2 = raptorTaskEvent.getThrowable();
                    while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                        throwable2 = throwable;
                    }
                    ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                    this.cleanup(true, null);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    try {
                        this.cleanup(false, (String)this.val$task.getResult());
                    }
                    catch (InterruptedException interruptedException) {
                        ExceptionHandler.handleException((Throwable)interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        ExceptionHandler.handleException((Throwable)executionException);
                    }
                }

                private void cleanup(final boolean bl, final String string) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            val$wc.hide();
                            try {
                                if (bl) {
                                    DpImpWizType.this._connCombo.setSelectedIndex(-1);
                                } else {
                                    DpImpWizType.this._connCombo.setSelectedItem(string);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            });
            waitCursor.show();
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.iOD.onExit(traversableContext);
        if (traversableContext.getDirection() == 1 && this._isSYS.equals(Boolean.TRUE)) {
            throw new TraversalException(DpWizardArb.getString("EXP_SYS_WARNING"), DpWizardArb.getString("EXP_PRIV_ERROR"));
        }
        super.onExit(traversableContext);
        String string = this._connSelector.getCurrentConnectionName();
        if (string == null || string.trim().equals("")) {
            throw new TraversalException(DpWizardArb.getString("EXP_NO_CONNECTION"));
        }
        Connection connection = (Connection)this._listModel.getPropertyValue("KEY_CONN");
        if (connection == null) {
            throw new TraversalException(DpWizardArb.getString("EXP_NO_CONNECTION"));
        }
        traversableContext.put("KEY_CONN", (Object)connection);
        this._listModel.setProperty("KEY_CONN", (Object)connection);
        traversableContext.put("KEY_CNAME", (Object)string);
        this._listModel.setProperty("KEY_CNAME", (Object)string);
        this._storeMeta = DpExpWizSource.MetadataEnum.BOTH;
        switch (this._dataMeta.getSelectedIndex()) {
            case 0: {
                this._storeMeta = DpExpWizSource.MetadataEnum.BOTH;
                break;
            }
            case 1: {
                this._storeMeta = DpExpWizSource.MetadataEnum.DATA;
                break;
            }
            case 2: {
                this._storeMeta = DpExpWizSource.MetadataEnum.DDL;
            }
        }
        this._listModel.setProperty("DP_KEY_STOREMETA", (Object)this._storeMeta);
        if (this._rbFull.isSelected()) {
            this._listModel.setProperty("DP_KEY_BRANCH", (Object)"IMP_FULL");
        } else if (this._rbTablespace.isSelected()) {
            this._listModel.setProperty("DP_KEY_BRANCH", (Object)"DP_TABLESPACE");
        } else if (this._rbSchema.isSelected()) {
            this._listModel.setProperty("DP_KEY_BRANCH", (Object)"DP_SCHEMA");
        } else if (this._rbTable.isSelected()) {
            this._listModel.setProperty("DP_KEY_BRANCH", (Object)"DP_TABLE");
        }
        this._listModel.setProperty("DP_KEY_IS_PRIVILIGED", (Object)this._isPrivileged);
        traversableContext.put("KEY_EXPORT_OBJECTS", (Object)this._listModel);
        if (!this.jName.getText().equals("") && traversableContext.getDirection() == 1 && ("SCH_" + this.jName.getText()).length() > 30) {
            throw new TraversalException(DpWizardArb.getString("EXP_JNAME_TOO_LONG_SCHEDULED"), DpWizardArb.getString("EXP_JNAME_TOO_LONG"));
        }
        String string2 = this.jName.getText();
        if (string2.equals("") && (string2 = (String)this._listModel.getPropertyValue("DP_EXP_JNAME")).equals("")) {
            string2 = (String)this._listModel.getPropertyValue("DP_EXP_GEN_NAME");
        }
        this._listModel.setProperty("DP_EXP_JNAME", (Object)string2);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this._listModel.setProperty("IMP_OBJ_LIST", arrayList);
        this._listModel.setProperty("IMP_DATA_LIST", arrayList2);
    }
}

