/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.Screen;
import javax.swing.JPanel;
import oracle.dbtools.javafx.scene.SceneFactory;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.ide.MetricsIdeArb;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelContext;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelObject;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXService;

public class MetricsPanel
extends JPanel {
    private volatile JFXPanel fxPanel;
    private Scene scene;
    private DXChannel channel;
    private boolean panning;
    private double panInitialX;
    private double panInitialY;
    private double translateX;
    private double translateY;
    private boolean zooming;
    private double currentZoom;
    private double dragZoomInitial;
    private int dragInitial;
    private int deltaDrag;
    private int deltaDragThreshold;
    private double scale = 1.0;
    private boolean built = false;
    private final String connectionName;
    private final Connection connection;
    private final Class<? extends Region> panelClass;
    private boolean usePanAndZoom;
    private Map<String, String> attributes;

    public MetricsPanel(Class<? extends Region> clazz, String string, Connection connection) {
        super(new BorderLayout());
        this.panelClass = clazz;
        this.connectionName = string;
        this.connection = connection;
    }

    public void enablePanAndZoom() {
        this.usePanAndZoom = true;
    }

    public void panLeft() {
        this.translateX -= this.getPanIncrement();
        this.applyTransforms();
    }

    public void panRight() {
        this.translateX += this.getPanIncrement();
        this.applyTransforms();
    }

    public void panUp() {
        this.translateY -= this.getPanIncrement();
        this.applyTransforms();
    }

    public void panDown() {
        this.translateY += this.getPanIncrement();
        this.applyTransforms();
    }

    public void zoomIn() {
        this.currentZoom += this.getZoomIncrement();
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void zoomOut() {
        this.currentZoom -= this.getZoomIncrement();
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void zoomActual() {
        this.translateX = 0.0;
        this.translateY = 0.0;
        this.currentZoom = 0.0;
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void zoomToFit() {
        this.translateX = 0.0;
        this.translateY = 0.0;
        this.currentZoom = this.getZoomToFit();
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void setPanelAttributes(Map<String, String> map) {
        this.attributes = map;
    }

    public void open() {
        if (!this.built) {
            this.built = true;
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(MetricsIdeArb.getString("LOAD_UI_TASK_NAME"), true, IRaptorTaskRunMode.MODAL){

                protected Void doWork() throws TaskException {
                    MetricsPanel.this.fxPanel = new JFXPanel();
                    MetricsPanel.this.add((Component)MetricsPanel.this.fxPanel, "Center");
                    Platform.runLater(() -> {
                        try {
                            MetricsPanel.this.createFXUI();
                        }
                        catch (RuntimeException runtimeException) {
                            Logger.getLogger(MetricsPanel.class.getName()).log(Level.SEVERE, "error creating FX viewer UI", runtimeException);
                        }
                    });
                    return null;
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    public void close() {
        Platform.runLater(() -> this.closeFXUI());
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    private void createFXUI() {
        try {
            final Region region = this.panelClass.newInstance();
            region.backgroundProperty().addListener((ChangeListener)new ChangeListener<Background>(){

                public void changed(ObservableValue<? extends Background> observableValue, Background background, Background background2) {
                    block0: {
                        Iterator iterator = background2.getFills().iterator();
                        if (!iterator.hasNext()) break block0;
                        BackgroundFill backgroundFill = (BackgroundFill)iterator.next();
                        MetricsPanel.this.scene.setFill(backgroundFill.getFill());
                        region.backgroundProperty().removeListener((ChangeListener)this);
                    }
                }
            });
            this.scene = SceneFactory.createScene((Parent)region);
            PanelContext panelContext = new PanelContext(){
                private String userName;

                @Override
                public DXChannel getChannel() {
                    if (MetricsPanel.this.channel == null) {
                        MetricsPanel.this.channel = DXService.createChannel();
                    }
                    return MetricsPanel.this.channel;
                }

                @Override
                public String getConnectionName() {
                    return MetricsPanel.this.connectionName;
                }

                @Override
                public Connection getConnection() {
                    return MetricsPanel.this.connection;
                }

                @Override
                public String getUserName() {
                    if (this.userName == null) {
                        this.userName = DbaUtil.getUserName(this.getConnection());
                    }
                    return this.userName;
                }

                @Override
                public String getAttribute(String string) {
                    return MetricsPanel.this.attributes != null ? (String)MetricsPanel.this.attributes.get(string) : null;
                }
            };
            this.bindNode((Node)this.scene.getRoot(), panelContext);
            if (this.channel != null) {
                DXService.registerChannel((DXChannel)this.channel);
            }
            if (this.scene != null) {
                if (this.usePanAndZoom) {
                    this.setupPanAndZoomHandlers();
                }
                this.fxPanel.setScene(this.scene);
            }
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error creating panel class ", reflectiveOperationException);
        }
        if (this.scene == null) {
            this.scene = SceneFactory.createScene((Parent)new Pane());
        }
    }

    private void bindNode(Node node, PanelContext panelContext) {
        PanelObject panelObject;
        if (node instanceof PanelObject) {
            panelObject = (PanelObject)node;
            panelObject.bind(panelContext);
        }
        if (node instanceof Parent) {
            panelObject = (Parent)node;
            for (Node node2 : panelObject.getChildrenUnmodifiable()) {
                this.bindNode(node2, panelContext);
            }
        }
    }

    private void closeFXUI() {
        this.closeNode((Node)this.scene.getRoot());
        if (this.channel != null) {
            DXService.closeChannel((DXChannel)this.channel);
        }
    }

    private void closeNode(Node node) {
        Object object;
        if (node instanceof Parent) {
            object = (Parent)node;
            for (Node node2 : object.getChildrenUnmodifiable()) {
                this.closeNode(node2);
            }
        }
        if (node instanceof PanelObject) {
            object = (PanelObject)node;
            object.close();
        }
    }

    private void setupPanAndZoomHandlers() {
        this.scene.addEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isControlDown()) {
                    MetricsPanel.this.zooming = true;
                    MetricsPanel.this.beginZoom((int)mouseEvent.getScreenX());
                } else {
                    MetricsPanel.this.panning = true;
                    MetricsPanel.this.beginPan((int)mouseEvent.getScreenX(), (int)mouseEvent.getScreenY());
                }
                mouseEvent.consume();
            }
        });
        this.scene.addEventHandler(MouseEvent.MOUSE_DRAGGED, mouseEvent -> {
            if (this.zooming) {
                this.zoom((int)mouseEvent.getScreenX());
            } else if (this.panning) {
                this.pan((int)mouseEvent.getScreenX(), (int)mouseEvent.getScreenY());
            }
            mouseEvent.consume();
        });
        this.scene.addEventHandler(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            if (this.zooming) {
                this.zooming = false;
            } else if (this.panning) {
                this.panning = false;
            }
            mouseEvent.consume();
        });
    }

    private void applyTransforms() {
        Translate translate = Transform.translate((double)this.translateX, (double)this.translateY);
        Scale scale = Transform.scale((double)this.scale, (double)this.scale, (double)0.0, (double)0.0);
        this.scene.getRoot().getTransforms().setAll((Object[])new Transform[]{translate, scale});
    }

    private void beginPan(int n, int n2) {
        this.panInitialX = n;
        this.panInitialY = n2;
    }

    private void pan(int n, int n2) {
        this.translateX = this.translateX + (double)n - this.panInitialX;
        this.translateY = this.translateY + (double)n2 - this.panInitialY;
        this.panInitialX = n;
        this.panInitialY = n2;
        this.applyTransforms();
    }

    private void beginZoom(int n) {
        if (this.deltaDragThreshold == 0) {
            this.deltaDragThreshold = (int)Screen.getPrimary().getVisualBounds().getWidth() / 2;
        }
        this.dragInitial = n;
        this.dragZoomInitial = this.currentZoom;
    }

    private void zoom(int n) {
        int n2 = n - this.dragInitial;
        if (n2 != this.deltaDrag) {
            this.deltaDrag = n2;
            this.currentZoom = this.dragZoomInitial + (double)this.deltaDrag / (double)this.deltaDragThreshold;
            this.scale = Math.pow(10.0, this.currentZoom);
            this.applyTransforms();
        }
    }

    private double getZoomToFit() {
        double d;
        Parent parent = this.scene.getRoot();
        double d2 = parent.prefWidth(-1.0);
        double d3 = parent.prefHeight(-1.0);
        double d4 = this.getWidth();
        double d5 = this.getHeight();
        double d6 = d5 / d4;
        return Math.log10(d6 > (d = d3 / d2) ? d4 / d2 : d5 / d3);
    }

    private double getZoomIncrement() {
        return 0.05;
    }

    private double getPanIncrement() {
        Parent parent = this.scene.getRoot();
        return parent.prefWidth(-1.0) / 10.0;
    }
}

