/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance;

import java.net.URI;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.StackPane;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.NumericBindings;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.BarbersPole;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.PanelStyle;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.InitializingBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.TransitionBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelContext;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelObject;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.CSSHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.FXMLHelper;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.value.DXDouble;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class MemoryDatabaseFlowPanel
extends StackPane
implements PanelObject {
    @FXML
    private Label physicalReadsPerSecond;
    @FXML
    private BarbersPole physicalReadsIndicator;
    @FXML
    private Label physicalWritesPerSecond;
    @FXML
    private BarbersPole physicalWritesIndicator;
    @FXML
    private Label redoWritesPerSecond;
    @FXML
    private BarbersPole redoWritesIndicator;

    public MemoryDatabaseFlowPanel() {
        FXMLHelper.load((Parent)this);
        CSSHelper.addStyleClass((Node)this, new Object[]{PanelStyle.DISPLAY});
    }

    @Override
    public void bind(PanelContext panelContext) {
        String string = panelContext.getConnectionName();
        DXChannel dXChannel = panelContext.getChannel();
        DXDouble dXDouble = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Disk/PhysicalReadsPerSecond"));
        this.physicalReadsPerSecond.textProperty().bind((ObservableValue)NumericBindings.toPrefixForm((ObservableNumberValue)dXDouble, "Block/s"));
        this.physicalReadsIndicator.animatedProperty().bind((ObservableValue)DoubleExpression.doubleExpression((ObservableDoubleValue)dXDouble).greaterThanOrEqualTo(1.0E-4));
        InitializingBlurMixin.install((Node)this.physicalReadsPerSecond, (ObservableValue<Boolean>)dXDouble.isAvailable());
        TransitionBlurMixin.install((Node)this.physicalReadsPerSecond, this.physicalReadsPerSecond.textProperty());
        InitializingBlurMixin.install((Node)this.physicalReadsIndicator, (ObservableValue<Boolean>)dXDouble.isAvailable());
        TransitionBlurMixin.install((Node)this.physicalReadsIndicator, this.physicalReadsPerSecond.textProperty());
        dXDouble = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Disk/PhysicalWritesPerSecond"));
        this.physicalWritesPerSecond.textProperty().bind((ObservableValue)NumericBindings.toPrefixForm((ObservableNumberValue)dXDouble, "Block/s"));
        this.physicalWritesIndicator.animatedProperty().bind((ObservableValue)DoubleExpression.doubleExpression((ObservableDoubleValue)dXDouble).greaterThanOrEqualTo(1.0E-4));
        InitializingBlurMixin.install((Node)this.physicalWritesPerSecond, (ObservableValue<Boolean>)dXDouble.isAvailable());
        TransitionBlurMixin.install((Node)this.physicalWritesPerSecond, this.physicalWritesPerSecond.textProperty());
        InitializingBlurMixin.install((Node)this.physicalWritesIndicator, (ObservableValue<Boolean>)dXDouble.isAvailable());
        TransitionBlurMixin.install((Node)this.physicalWritesIndicator, this.physicalWritesPerSecond.textProperty());
        dXDouble = DXValues.listenDerivative((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Redo/BlocksWritten"));
        this.redoWritesPerSecond.textProperty().bind((ObservableValue)NumericBindings.toPrefixForm((ObservableNumberValue)dXDouble, "Block/s"));
        this.redoWritesIndicator.animatedProperty().bind((ObservableValue)DoubleExpression.doubleExpression((ObservableDoubleValue)dXDouble).greaterThanOrEqualTo(1.0E-4));
        InitializingBlurMixin.install((Node)this.redoWritesPerSecond, (ObservableValue<Boolean>)dXDouble.isAvailable());
        TransitionBlurMixin.install((Node)this.redoWritesPerSecond, this.redoWritesPerSecond.textProperty());
        InitializingBlurMixin.install((Node)this.redoWritesIndicator, (ObservableValue<Boolean>)dXDouble.isAvailable());
        TransitionBlurMixin.install((Node)this.redoWritesIndicator, this.redoWritesPerSecond.textProperty());
    }
}

