/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance;

import java.net.URI;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.TimeSeriesBindings;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.LabelledPanel;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesItem;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesLineChart;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesStackedAreaChart;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.DbInstanceArb;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.dbinstance.PanelStyle;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.BorderMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.InitializingBlurMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.mixin.ReportDrilldownMixin;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelContext;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.panel.PanelObject;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.CSSHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.FXMLHelper;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.util.GraphHelper;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.value.DXLong;
import oracle.dbtools.raptor.metrics.value.DXRow;
import oracle.dbtools.raptor.metrics.value.DXString;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class DisplayPanel
extends GridPane
implements PanelObject {
    @FXML
    private LabelledPanel databasePanel;
    @FXML
    private LabelledPanel sessionsPanel;
    @FXML
    private LabelledPanel waitsPanel;
    @FXML
    private LabelledPanel dbCPUPanel;
    @FXML
    private Label dbName;
    @FXML
    private Label dbVersion;
    @FXML
    private Label dbUptime;
    @FXML
    private Label os;
    @FXML
    private Label cpuCount;
    @FXML
    private TimeSeriesStackedAreaChart sessionsChart;
    @FXML
    private TimeSeriesStackedAreaChart waitsChart;
    @FXML
    private TimeSeriesLineChart dbCPUChart;

    public DisplayPanel() {
        FXMLHelper.load((Parent)this);
        CSSHelper.addStyleClass((Node)this, new Object[]{PanelStyle.DISPLAY_CONTAINER});
        CSSHelper.addStyleClass((Node)this.databasePanel, new Object[]{PanelStyle.DISPLAY});
        CSSHelper.addStyleClass((Node)this.sessionsPanel, new Object[]{PanelStyle.DISPLAY});
        CSSHelper.addStyleClass((Node)this.waitsPanel, new Object[]{PanelStyle.DISPLAY});
        CSSHelper.addStyleClass((Node)this.dbCPUPanel, new Object[]{PanelStyle.DISPLAY});
    }

    @Override
    public void bind(PanelContext panelContext) {
        String string = panelContext.getConnectionName();
        DXChannel dXChannel = panelContext.getChannel();
        DXString dXString = DXValues.listenString((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Name"));
        DXString dXString2 = DXValues.listenString((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Version"));
        DXLong dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/HoursUp"));
        NumberBinding numberBinding = Bindings.divide((ObservableNumberValue)dXLong, (int)24);
        NumberBinding numberBinding2 = Bindings.subtract((ObservableNumberValue)dXLong, (ObservableNumberValue)Bindings.multiply((int)24, (ObservableNumberValue)numberBinding));
        DXString dXString3 = DXValues.listenString((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/OSInfo"));
        DXLong dXLong2 = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/CPUCount"));
        this.dbName.textProperty().bind((ObservableValue)dXString);
        this.dbVersion.textProperty().bind((ObservableValue)Bindings.format((String)DbInstanceArb.format("DISPLAY_PANEL_DATABASE_VERSION_LABEL", "%s"), (Object[])new Object[]{dXString2}));
        this.dbUptime.textProperty().bind((ObservableValue)Bindings.format((String)DbInstanceArb.format("DISPLAY_PANEL_DATABASE_UPTIME_LABEL", "%,d", "%d"), (Object[])new Object[]{numberBinding, numberBinding2}));
        this.os.textProperty().bind((ObservableValue)Bindings.format((String)DbInstanceArb.format("DISPLAY_PANEL_OS_LABEL", "%s"), (Object[])new Object[]{dXString3}));
        this.cpuCount.textProperty().bind((ObservableValue)Bindings.format((String)DbInstanceArb.format("DISPLAY_PANEL_CPU_COUNT_LABEL", "%d"), (Object[])new Object[]{dXLong2}));
        InitializingBlurMixin.install((Node)this.dbName, (ObservableValue<Boolean>)dXString.isAvailable());
        InitializingBlurMixin.install((Node)this.dbVersion, (ObservableValue<Boolean>)dXString2.isAvailable());
        InitializingBlurMixin.install((Node)this.dbUptime, (ObservableValue<Boolean>)dXLong.isAvailable());
        InitializingBlurMixin.install((Node)this.os, (ObservableValue<Boolean>)dXString3.isAvailable());
        InitializingBlurMixin.install((Node)this.cpuCount, (ObservableValue<Boolean>)dXLong2.isAvailable());
        BorderMixin.install((Node)this.databasePanel, true, BorderMixin.DRILLDOWN_COLOR);
        ReportDrilldownMixin.install((Node)this.databasePanel, string, "All Reports/Data Dictionary Reports/About Your Database/Version Banner");
        dXString = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/WaitClassCount"));
        dXString2 = DXValues.listenMap((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/WaitClasses"));
        dXLong = TimeSeriesBindings.transform((ObservableMapValue<String, DXRow<String>>)dXString2, "WaitClass", "TimeWaited");
        numberBinding = dXString.isAvailable().and((ObservableBooleanValue)Bindings.size(dXLong).greaterThanOrEqualTo((ObservableNumberValue)dXString));
        GraphHelper.setTimeAxis(this.waitsChart.getMonitor());
        this.waitsChart.getMonitor().enabledProperty().bind((ObservableValue)numberBinding);
        this.waitsChart.getMonitor().timeSeriesItemsProperty().bind(dXLong);
        InitializingBlurMixin.install((Node)this.waitsChart, (ObservableValue<Boolean>)numberBinding);
        InitializingBlurMixin.install((Node)this.waitsChart, (ObservableValue<Boolean>)dXString.isAvailable());
        BorderMixin.install((Node)this.waitsPanel, true, BorderMixin.DRILLDOWN_COLOR);
        ReportDrilldownMixin.install((Node)this.waitsPanel, string, "All Reports/Data Dictionary Reports/Database Administration/Waits and Events/Wait Class Activity for Last Hour");
        dXString = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SessionCount/ActiveBlocked"));
        dXString2 = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SessionCount/Inactive"));
        dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/SessionCount/ActiveNotBlocked"));
        numberBinding = dXString.isAvailable().and((ObservableBooleanValue)dXString2.isAvailable()).and((ObservableBooleanValue)dXLong.isAvailable());
        numberBinding2 = new SimpleListProperty(FXCollections.observableArrayList());
        numberBinding2.add((Object)new TimeSeriesItem("Blocked", (ObservableValue<Number>)dXString));
        numberBinding2.add((Object)new TimeSeriesItem("Inactive", (ObservableValue<Number>)dXString2));
        numberBinding2.add((Object)new TimeSeriesItem("Active", (ObservableValue<Number>)dXLong));
        GraphHelper.setTimeAxis(this.sessionsChart.getMonitor());
        this.sessionsChart.getMonitor().enabledProperty().bind((ObservableValue)numberBinding);
        this.sessionsChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)numberBinding2);
        InitializingBlurMixin.install((Node)this.sessionsChart, (ObservableValue<Boolean>)numberBinding);
        BorderMixin.install((Node)this.sessionsPanel, true, BorderMixin.DRILLDOWN_COLOR);
        ReportDrilldownMixin.install((Node)this.sessionsPanel, string, "All Reports/Data Dictionary Reports/Database Administration/Sessions/Sessions");
        dXString = DXValues.listenDouble((DXChannel)dXChannel, (URI)DXIds.newId((String)"sql", (String)string, (String)"Db/Indicator/DatabaseCPUTimeRatio"));
        dXString2 = dXString.isAvailable();
        dXLong = new SimpleListProperty(FXCollections.observableArrayList());
        dXLong.add((Object)new TimeSeriesItem("DB CPU", (ObservableValue<Number>)dXString));
        GraphHelper.setTimeAxis(this.dbCPUChart.getMonitor());
        this.dbCPUChart.getMonitor().enabledProperty().bind((ObservableValue)dXString2);
        this.dbCPUChart.getMonitor().timeSeriesItemsProperty().bind((ObservableValue)dXLong);
        InitializingBlurMixin.install((Node)this.dbCPUChart, (ObservableValue<Boolean>)dXString2);
        BorderMixin.install((Node)this.dbCPUPanel, true, BorderMixin.DRILLDOWN_COLOR);
        ReportDrilldownMixin.install((Node)this.dbCPUPanel, string, "All Reports/Data Dictionary Reports/Database Administration/Sessions/Session CPU and Time Statistics");
    }

    @Override
    public void close() {
        this.waitsChart.getMonitor().enabledProperty().unbind();
        this.waitsChart.getMonitor().setEnabled(false);
        this.sessionsChart.getMonitor().enabledProperty().unbind();
        this.sessionsChart.getMonitor().setEnabled(false);
        this.dbCPUChart.getMonitor().enabledProperty().unbind();
        this.dbCPUChart.getMonitor().setEnabled(false);
    }
}

