/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;

public class CylinderGauge
extends Region {
    private final SimpleDoubleProperty valueProperty = new SimpleDoubleProperty((Object)this, "value", 0.5){

        protected void invalidated() {
            CylinderGauge.this.requestLayout();
        }
    };
    private final StyleableDoubleProperty ellipseYRadiusProperty = new SimpleStyleableDoubleProperty(cssEllipseYRadius, (Object)this, "ellipseYRadius", 0.2){

        protected void invalidated() {
            CylinderGauge.this.requestLayout();
        }
    };
    private final StyleableDoubleProperty frameFillGapProperty = new SimpleStyleableDoubleProperty(cssFrameFillGap, (Object)this, "frameFillGap", 4.0){

        protected void invalidated() {
            CylinderGauge.this.requestLayout();
        }
    };
    private static final CssMetaData cssEllipseYRadius = new CssMetaData<CylinderGauge, Number>("-sd-ellipse-y-radius", StyleConverter.getSizeConverter()){

        public boolean isSettable(CylinderGauge cylinderGauge) {
            return true;
        }

        public StyleableProperty<Number> getStyleableProperty(CylinderGauge cylinderGauge) {
            return cylinderGauge.ellipseYRadiusProperty;
        }
    };
    private static final CssMetaData cssFrameFillGap = new CssMetaData<CylinderGauge, Number>("-sd-frame-fill-gap", StyleConverter.getSizeConverter()){

        public boolean isSettable(CylinderGauge cylinderGauge) {
            return true;
        }

        public StyleableProperty<Number> getStyleableProperty(CylinderGauge cylinderGauge) {
            return cylinderGauge.frameFillGapProperty;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
    private final Ellipse frameCap = new Ellipse();
    private final Path frameTube = new Path();
    private final Ellipse fillCap = new Ellipse();
    private final Path fillTube = new Path();

    public CylinderGauge() {
        this.getStyleClass().add((Object)"cylinder-gauge");
        this.frameCap.getStyleClass().add((Object)"frame-cap");
        this.frameTube.getStyleClass().add((Object)"frame-tube");
        this.fillCap.getStyleClass().add((Object)"fill-cap");
        this.fillTube.getStyleClass().add((Object)"fill-tube");
        this.getChildren().addAll((Object[])new Node[]{this.fillTube, this.fillCap, this.frameTube, this.frameCap});
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CylinderGauge.getClassCssMetaData();
    }

    public void setValue(double d) {
        this.valueProperty.set(d);
    }

    public double getValue() {
        return this.valueProperty.get();
    }

    public DoubleProperty valueProperty() {
        return this.valueProperty;
    }

    protected void layoutChildren() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = d / 2.0;
        double d4 = this.ellipseYRadiusProperty.get() * d2;
        this.frameCap.setCenterX(d3);
        this.frameCap.setCenterY(d4);
        this.frameCap.setRadiusX(d3);
        this.frameCap.setRadiusY(d4);
        this.frameTube.getElements().setAll((Object[])new PathElement[]{new MoveTo(0.0, d4), new ArcTo(d3, d4, 180.0, d, d4, false, false), new LineTo(d, d2 - d4), new ArcTo(d3, d4, 180.0, 0.0, d2 - d4, false, true), new ClosePath()});
        double d5 = this.frameFillGapProperty.get();
        double d6 = d3 - d5;
        double d7 = d4 - d5;
        double d8 = (1.0 - this.valueProperty.get()) * (d2 - 2.0 * d4) + d4;
        this.fillCap.setCenterX(d3);
        this.fillCap.setCenterY(d8);
        this.fillCap.setRadiusX(d6);
        this.fillCap.setRadiusY(d7);
        this.fillTube.getElements().setAll((Object[])new PathElement[]{new MoveTo(d5, d8), new ArcTo(d6, d7, 180.0, d - d5, d8, false, false), new LineTo(d - d5, d2 - d4), new ArcTo(d6, d7, 180.0, d5, d2 - d4, false, true), new ClosePath()});
    }

    static {
        ArrayList<CssMetaData> arrayList = new ArrayList<CssMetaData>(Region.getClassCssMetaData());
        arrayList.add(cssEllipseYRadius);
        arrayList.add(cssFrameFillGap);
        cssMetaDataList = Collections.unmodifiableList(arrayList);
    }
}

