/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.control;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.util.Duration;

public class Arrow
extends Region {
    private final Line line = new Line();
    private final Polygon triangle = new Polygon();
    private final Polygon tailTriangle = new Polygon();
    private Timeline timeline;
    private final ObjectProperty<Side> startSideProperty = new SimpleObjectProperty<Side>((Object)this, "startSide", Side.TOP){

        protected void invalidated() {
            Arrow.this.requestLayout();
        }
    };
    private final BooleanProperty doubleHeadedProperty = new SimpleBooleanProperty((Object)this, "doubleHeaded", false){

        protected void invalidated() {
            Arrow.this.requestLayout();
        }
    };
    private final BooleanProperty animatedProperty = new SimpleBooleanProperty((Object)this, "animated", false){

        protected void invalidated() {
            Arrow.this.enableAnimation(this.get());
        }
    };

    public Arrow() {
        this.triangle.setStrokeWidth(0.0);
        this.tailTriangle.setStrokeWidth(0.0);
        this.getStyleClass().add((Object)"arrow");
        this.line.getStyleClass().add((Object)"arrow-line");
        this.triangle.getStyleClass().add((Object)"arrow-head");
        this.tailTriangle.getStyleClass().add((Object)"arrow-head");
        this.getChildren().setAll((Object[])new Node[]{this.line, this.triangle, this.tailTriangle});
    }

    public final void setStartSide(Side side) {
        this.startSideProperty.set((Object)side);
    }

    public final Side getStartSide() {
        return (Side)this.startSideProperty.get();
    }

    public final ObjectProperty<Side> startSideProperty() {
        return this.startSideProperty;
    }

    public final void setDoubleHeaded(boolean bl) {
        this.doubleHeadedProperty.setValue(Boolean.valueOf(bl));
    }

    public final boolean isDoubleHeaded() {
        return this.doubleHeadedProperty.getValue();
    }

    public final BooleanProperty doubleHeadedProperty() {
        return this.doubleHeadedProperty;
    }

    public final void setAnimated(boolean bl) {
        this.animatedProperty.setValue(Boolean.valueOf(bl));
    }

    public final boolean isAnimated() {
        return this.animatedProperty.getValue();
    }

    public final BooleanProperty animatedProperty() {
        return this.animatedProperty;
    }

    protected double computeMinWidth(double d) {
        return this.computePrefWidth(d);
    }

    protected double computePrefWidth(double d) {
        double d2;
        double d3 = this.line.getStrokeWidth();
        double d4 = 2.0 * d3 + 6.0;
        double d5 = 3.0 * d4 / 2.0;
        switch (this.getStartSide()) {
            case TOP: 
            case BOTTOM: {
                d2 = d4;
                break;
            }
            default: {
                d2 = d5;
            }
        }
        return d2;
    }

    protected double computeMinHeight(double d) {
        return this.computePrefHeight(d);
    }

    protected double computePrefHeight(double d) {
        double d2;
        double d3 = this.line.getStrokeWidth();
        double d4 = 2.0 * d3 + 6.0;
        double d5 = 3.0 * d4 / 2.0;
        switch (this.getStartSide()) {
            case TOP: 
            case BOTTOM: {
                d2 = d5;
                break;
            }
            default: {
                d2 = d4;
            }
        }
        return d2;
    }

    protected void layoutChildren() {
        Side side = this.getStartSide();
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.line.getStrokeWidth();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 2.0 * d3 + 6.0;
        double d9 = 3.0 * d8 / 2.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        boolean bl = this.isDoubleHeaded();
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        switch (side) {
            case TOP: {
                d4 = 0.5 + d / 2.0;
                d5 = d3 / 2.0;
                d6 = d4;
                d7 = d2 - d9 - d3 / 2.0;
                d10 = 0.5 + d / 2.0;
                d11 = d2;
                d12 = 0.5 + d;
                d13 = d2 - d9;
                d14 = 0.5;
                d15 = d13;
                if (!bl) break;
                d5 += d9;
                d16 = 0.5 + d / 2.0;
                d17 = 0.0;
                d18 = 0.5 + d;
                d19 = d9;
                d20 = 0.5;
                d21 = d19;
                break;
            }
            case BOTTOM: {
                d4 = 0.5 + d / 2.0;
                d5 = d2 - d3 / 2.0;
                d6 = d4;
                d7 = d9 + d3 / 2.0;
                d10 = 0.5 + d / 2.0;
                d11 = 0.0;
                d12 = 0.5 + d;
                d13 = d9;
                d14 = 0.5;
                d15 = d13;
                if (!bl) break;
                d5 -= d9;
                d16 = 0.5 + d / 2.0;
                d17 = d2;
                d18 = 0.5 + d;
                d19 = d2 - d9;
                d20 = 0.5;
                d21 = d19;
                break;
            }
            case LEFT: {
                d4 = d3 / 2.0;
                d5 = -0.5 + d2 / 2.0;
                d6 = d - d9 - d3 / 2.0;
                d7 = d5;
                d10 = d;
                d11 = -0.5 + d2 / 2.0;
                d12 = d - d9;
                d13 = -0.5;
                d14 = d12;
                d15 = -0.5 + d2;
                if (!bl) break;
                d4 += d9;
                d16 = 0.0;
                d17 = -0.5 + d2 / 2.0;
                d18 = d9;
                d19 = -0.5;
                d20 = d18;
                d21 = -0.5 + d2;
                break;
            }
            case RIGHT: {
                d4 = d - d3 / 2.0;
                d5 = -0.5 + d2 / 2.0;
                d6 = d9 + d3 / 2.0;
                d7 = d5;
                d10 = 0.0;
                d11 = -0.5 + d2 / 2.0;
                d12 = d9;
                d13 = -0.5;
                d14 = d12;
                d15 = -0.5 + d2;
                if (!bl) break;
                d4 -= d9;
                d16 = d;
                d17 = -0.5 + d2 / 2.0;
                d18 = d - d9;
                d19 = -0.5;
                d20 = d18;
                d21 = -0.5 + d2;
            }
        }
        this.line.setStartX(d4);
        this.line.setStartY(d5);
        this.line.setEndX(d6);
        this.line.setEndY(d7);
        this.triangle.getPoints().setAll((Object[])new Double[]{d10, d11, d12, d13, d14, d15});
        if (bl) {
            this.tailTriangle.getPoints().setAll((Object[])new Double[]{d16, d17, d18, d19, d20, d21});
        }
    }

    private void enableAnimation(boolean bl) {
        if (bl) {
            if (this.timeline == null) {
                this.line.getStrokeDashArray().addAll((Object[])new Double[]{5.0, 10.0});
                this.line.setEffect((Effect)new DropShadow(5.0, 1.0, 1.0, Color.BLACK));
                this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.line.strokeDashOffsetProperty(), (Object)150)}), new KeyFrame(Duration.seconds((double)10.0), new KeyValue[]{new KeyValue((WritableValue)this.line.strokeDashOffsetProperty(), (Object)0)})});
                this.timeline.setCycleCount(-1);
                if (this.isDoubleHeaded()) {
                    this.timeline.setAutoReverse(true);
                }
                this.timeline.playFromStart();
            }
        } else if (this.timeline != null) {
            this.line.getStrokeDashArray().clear();
            this.line.setEffect(null);
            this.timeline.stop();
            this.timeline = null;
        }
    }
}

