/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.binding;

import javafx.beans.binding.ListBinding;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.MapEntryTransform;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.control.TimeSeriesItem;
import oracle.dbtools.raptor.metrics.value.DXRow;

class TimeSeriesMapBinding
extends ListBinding<TimeSeriesItem> {
    private final ObservableList<TimeSeriesItem> items = FXCollections.observableArrayList();

    TimeSeriesMapBinding(ObservableMapValue<String, DXRow<String>> observableMapValue, MapEntryTransform<String> mapEntryTransform) {
        observableMapValue.addListener(change -> {
            DXRow dXRow;
            if (change.wasAdded()) {
                dXRow = (DXRow)change.getValueAdded();
                this.onAddEntry((String)mapEntryTransform.getKey(dXRow), mapEntryTransform.getValue(dXRow));
            }
            if (change.wasRemoved()) {
                dXRow = (DXRow)change.getValueRemoved();
                this.onRemoveEntry((String)mapEntryTransform.getKey(dXRow));
            }
        });
    }

    protected ObservableList<TimeSeriesItem> computeValue() {
        return this.items;
    }

    private void onAddEntry(String string, ObservableValue<Number> observableValue) {
        this.items.add((Object)new TimeSeriesItem(string, observableValue));
    }

    private void onRemoveEntry(String string) {
        int n = 0;
        for (TimeSeriesItem timeSeriesItem : this.items) {
            if (timeSeriesItem.getSeriesName().equals(string)) {
                this.items.remove(n);
                break;
            }
            ++n;
        }
    }
}

