/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.metrics.displays.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.scene.chart.XYChart;
import oracle.dbtools.raptor.dba.navigator.metrics.displays.binding.MapEntryTransform;
import oracle.dbtools.raptor.metrics.value.DXRow;

class PointSeriesMapBinding
extends ObjectBinding<ObservableList<XYChart.Series<Long, Number>>> {
    private final ObjectProperty<ObservableList<XYChart.Series<Long, Number>>> dataProperty;
    private final ObservableList<XYChart.Data<Long, Number>> dataPoints;
    private final Map<Long, XListener> listenerMap = new HashMap<Long, XListener>();

    PointSeriesMapBinding(ObservableMapValue<Long, DXRow<Long>> observableMapValue, MapEntryTransform<Long> mapEntryTransform) {
        this.dataProperty = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
        XYChart.Series series = new XYChart.Series();
        this.dataPoints = series.getData();
        ((ObservableList)this.dataProperty.get()).add((Object)series);
        ((ObservableMap)observableMapValue.get()).addListener(change -> {
            if (change.wasAdded()) {
                DXRow dXRow = (DXRow)change.getValueAdded();
                this.onPointAdded((Long)mapEntryTransform.getKey(dXRow), mapEntryTransform.getValue(dXRow));
            } else if (change.wasRemoved()) {
                DXRow dXRow = (DXRow)change.getValueRemoved();
                this.onPointRemoved((Long)mapEntryTransform.getKey(dXRow));
            }
        });
    }

    protected ObservableList<XYChart.Series<Long, Number>> computeValue() {
        return (ObservableList)this.dataProperty.get();
    }

    private void onPointAdded(Long l, ObservableValue<? extends Number> observableValue) {
        XYChart.Data data = new XYChart.Data((Object)l, observableValue.getValue());
        this.listenForSequence(l, observableValue);
        int n = this.findInsertionIndex(l);
        if (n < this.dataPoints.size() && ((Long)((XYChart.Data)this.dataPoints.get(n)).getXValue()).longValue() == l.longValue()) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "duplicate map entry detected for {0}", l);
        } else {
            this.dataPoints.add(n, (Object)data);
        }
    }

    private void onPointRemoved(Long l) {
        int n = this.findIndex(l);
        if (n >= 0) {
            this.unlistenForSequence(l);
            this.dataPoints.remove(n);
        }
    }

    private void onValueChanged(Long l, ObservableValue<? extends Number> observableValue) {
        int n = this.findIndex(l);
        boolean bl = false;
        if (n > 0) {
            XYChart.Data data = (XYChart.Data)this.dataPoints.get(n);
            data.setYValue(observableValue.getValue());
            bl = true;
        }
        if (!bl) {
            this.onPointRemoved(l);
            this.onPointAdded(l, observableValue);
        }
    }

    private int findInsertionIndex(Long l) {
        XYChart.Data data;
        int n = 0;
        Iterator iterator = this.dataPoints.iterator();
        while (iterator.hasNext() && (Long)(data = (XYChart.Data)iterator.next()).getXValue() < l) {
            ++n;
        }
        return n;
    }

    private int findIndex(Long l) {
        int n = -1;
        int n2 = 0;
        for (XYChart.Data data : this.dataPoints) {
            if (((Long)data.getXValue()).longValue() == l.longValue()) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private void listenForSequence(Long l, ObservableValue<? extends Number> observableValue) {
        XListener xListener = new XListener(l, observableValue);
        this.listenerMap.put(l, xListener);
        xListener.listen();
    }

    private void unlistenForSequence(Number number) {
        XListener xListener = this.listenerMap.remove(number);
        if (xListener != null) {
            xListener.unlisten();
        }
    }

    private class XListener
    implements ChangeListener<Number> {
        private final Long x;
        private final ObservableValue<? extends Number> valueObject;

        XListener(Long l, ObservableValue<? extends Number> observableValue) {
            this.x = l;
            this.valueObject = observableValue;
        }

        void listen() {
            this.valueObject.addListener((ChangeListener)this);
        }

        void unlisten() {
            this.valueObject.removeListener((ChangeListener)this);
        }

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            PointSeriesMapBinding.this.onValueChanged(this.x, (ObservableValue<? extends Number>)this.valueObject);
        }
    }
}

