/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.displays.metrics;

import java.net.URI;
import javafx.animation.FadeTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.engine.DXChannel;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.value.DXLong;
import oracle.dbtools.raptor.metrics.value.DXString;
import oracle.dbtools.raptor.metrics.value.DXValues;

public class InstanceViewerController {
    @FXML
    private Label TotalSessions;
    @FXML
    private Label ActiveSessions;
    @FXML
    private Label HighwaterMark;
    @FXML
    private Label DataPercentageUsed;
    @FXML
    private Label DataUsedMemory;
    @FXML
    private Label DataTotalMemory;
    @FXML
    private ProgressBar DataProgressBar;
    @FXML
    private Label TempPercentageUsed;
    @FXML
    private Label TempUsedMemory;
    @FXML
    private Label TempTotalMemory;
    @FXML
    private ProgressBar TempProgressBar;
    @FXML
    private Label UndoPercentageUsed;
    @FXML
    private Label UndoUsedMemory;
    @FXML
    private Label UndoTotalMemory;
    @FXML
    private ProgressBar UndoProgressBar;
    @FXML
    private Label PgaUsedMemory;
    @FXML
    private Label PgaTotalMemory;
    @FXML
    private Label PgaSessionUsedMemory;
    @FXML
    private Label PgaSessionTotalMemory;
    @FXML
    private Label PgaSqlWorkAreaUsedMemory;
    @FXML
    private Label PgaSqlWorkAreaTotalMemory;
    @FXML
    private Label SgaUsedMemory;
    @FXML
    private Label SgaTotalMemory;
    @FXML
    private Label SharedPoolSize;
    @FXML
    private Label RedoBufferSize;
    @FXML
    private Label FixedSgaSize;
    @FXML
    private Label JavaPoolSize;
    @FXML
    private Label StreamsPoolSize;
    @FXML
    private Label BufferCacheSize;
    @FXML
    private Label LargePoolSize;
    @FXML
    private Label DataDictionarySize;

    public void initialize(DXChannel dXChannel, String string) {
        this.bindLabelToInteger(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"Db/SessionCount/Current"), this.TotalSessions);
        this.bindLabelToInteger(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"Db/SessionCount/Active"), this.ActiveSessions);
        this.bindLabelToInteger(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"Db/HighwaterSessions"), this.HighwaterMark);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"DataTotalMemory"), this.DataTotalMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"DataUsedMemory"), this.DataUsedMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"DataPercentageUsed"), this.DataPercentageUsed);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"TempTotalMemory"), this.TempTotalMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"TempUsedMemory"), this.TempUsedMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"TempPercentageUsed"), this.TempPercentageUsed);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"UndoTotalMemory"), this.UndoTotalMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"UndoUsedMemory"), this.UndoUsedMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"UndoPercentageUsed"), this.UndoPercentageUsed);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"PgaUsedMemory"), this.PgaUsedMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"PgaTotalMemory"), this.PgaTotalMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"PgaSessionUsedMemory"), this.PgaSessionUsedMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"PgaSessionTotalMemory"), this.PgaSessionTotalMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"PgaSqlWorkAreaTotalMemory"), this.PgaSqlWorkAreaTotalMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"PgaSqlWorkAreaUsedMemory"), this.PgaSqlWorkAreaUsedMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"SgaTotalMemory"), this.SgaTotalMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"SgaUsedMemory"), this.SgaUsedMemory);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"SharedPoolSize"), this.SharedPoolSize);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"RedoBufferSize"), this.RedoBufferSize);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"FixedSgaSize"), this.FixedSgaSize);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"JavaPoolSize"), this.JavaPoolSize);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"StreamsPoolSize"), this.StreamsPoolSize);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"BufferCacheSize"), this.BufferCacheSize);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"LargePoolSize"), this.LargePoolSize);
        this.bindLabelToString(dXChannel, DXIds.newId((String)"sql", (String)string, (String)"DataDictionarySize"), this.DataDictionarySize);
    }

    private void bindLabelToInteger(DXChannel dXChannel, URI uRI, Label label) {
        DXLong dXLong = DXValues.listenLong((DXChannel)dXChannel, (URI)uRI);
        label.textProperty().bind((ObservableValue)Bindings.format((String)"%,d", (Object[])new Object[]{dXLong}));
    }

    private void bindLabelToString(DXChannel dXChannel, URI uRI, Label label) {
        DXString dXString = DXValues.listenString((DXChannel)dXChannel, (URI)uRI);
        label.textProperty().bind((ObservableValue)dXString);
    }

    private void blinkOnChange(Property<?> property, final Label label) {
        final FadeTransition fadeTransition = new FadeTransition(Duration.seconds((double)0.25), (Node)label);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue(0.9);
        fadeTransition.setCycleCount(2);
        fadeTransition.setAutoReverse(true);
        fadeTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                label.setTextFill((Paint)Color.BLACK);
            }
        });
        property.addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observableValue, Object object, Object object2) {
                label.setTextFill((Paint)Color.RED);
                fadeTransition.play();
            }
        });
    }
}

