/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.recovery;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.objects.OraDATE;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessor;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ScriptProcessor;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SeperatorActionControl;
import oracle.dbtools.raptor.ui.controls.TemporalActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class RestoreArchivedLogsAction
extends ActionDialog {
    public static final String RESTORE_LOGS_BY = "RESTORE_LOGS_BY";
    public static final String FROM_TIME = "FROM_TIME";
    public static final String UNTIL_CURRENT_TIME = "UNTIL_CURRENT_TIME";
    public static final String UNTIL_TIME = "UNTIL_TIME";
    public static final String FROM_SCN = "FROM_SCN";
    public static final String UNTIL_CURRENT_SCN = "UNTIL_CURRENT_SCN";
    public static final String UNTIL_SCN = "UNTIL_SCN";
    public static final String FROM_SEQUENCE = "FROM_SEQUENCE";
    public static final String UNTIL_CURRENT_SEQUENCE = "UNTIL_CURRENT_SEQUENCE";
    public static final String UNTIL_SEQUENCE = "UNTIL_SEQUENCE";
    public static final String RESTORE_BY_TIME = DbaNavigatorResources.getString("RESTORE_BY_TIME");
    public static final String RESTORE_BY_SCN = DbaNavigatorResources.getString("RESTORE_BY_SCN");
    public static final String RESTORE_BY_SEQUENCE = DbaNavigatorResources.getString("RESTORE_BY_SEQUENCE");

    protected ScriptProcessor createScriptProcessor() {
        return new RMANScriptProcessor();
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("RESTORE_ARCHIVE_LOGS_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(RESTORE_LOGS_BY, DbaNavigatorResources.getString("RESTORE_LOGS_BY_LABEL"), new String[]{RESTORE_BY_TIME, RESTORE_BY_SCN, RESTORE_BY_SEQUENCE}, RESTORE_BY_TIME);
        OraDATE oraDATE = OraDATE.getInstance();
        oraDATE.add(5, -7);
        TemporalActionControl temporalActionControl = new TemporalActionControl(FROM_TIME, DbaNavigatorResources.getString("FROM_TIME_LABEL"), (OraTemporalDatum)oraDATE, (Format)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl(UNTIL_CURRENT_TIME, DbaNavigatorResources.getString("UNTIL_CURRENT_TIME_LABEL"), true);
        TemporalActionControl temporalActionControl2 = new TemporalActionControl(UNTIL_TIME, DbaNavigatorResources.getString("UNTIL_TIME_LABEL"), (OraTemporalDatum)oraDATE, (Format)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(FROM_SCN, DbaNavigatorResources.getString("FROM_SCN_LABEL"), "0", TextBoxActionControl.getIntegerFormat());
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = new BooleanCheckBoxActionControl(UNTIL_CURRENT_SCN, DbaNavigatorResources.getString("UNTIL_CURRENT_SCN_LABEL"), true);
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(UNTIL_SCN, DbaNavigatorResources.getString("UNTIL_SCN_LABEL"), "0", TextBoxActionControl.getIntegerFormat());
        TextBoxActionControl textBoxActionControl3 = new TextBoxActionControl(FROM_SEQUENCE, DbaNavigatorResources.getString("FROM_SEQUENCE_LABEL"), "0", TextBoxActionControl.getIntegerFormat());
        BooleanCheckBoxActionControl booleanCheckBoxActionControl3 = new BooleanCheckBoxActionControl(UNTIL_CURRENT_SEQUENCE, DbaNavigatorResources.getString("UNTIL_CURRENT_SEQUENCE_LABEL"), true);
        TextBoxActionControl textBoxActionControl4 = new TextBoxActionControl(UNTIL_SEQUENCE, DbaNavigatorResources.getString("UNTIL_SEQUENCE_LABEL"), "0", TextBoxActionControl.getIntegerFormat());
        this.enableControls((ActionControl)comboBoxActionControl, (ActionControl)temporalActionControl, (ActionControl)booleanCheckBoxActionControl, (ActionControl)temporalActionControl2, (ActionControl)textBoxActionControl, (ActionControl)booleanCheckBoxActionControl2, (ActionControl)textBoxActionControl2, (ActionControl)textBoxActionControl3, (ActionControl)booleanCheckBoxActionControl3, (ActionControl)textBoxActionControl4);
        comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)comboBoxActionControl, (ActionControl)temporalActionControl, (ActionControl)booleanCheckBoxActionControl, (ActionControl)temporalActionControl2, (ActionControl)textBoxActionControl, (ActionControl)booleanCheckBoxActionControl2, (ActionControl)textBoxActionControl2, (ActionControl)textBoxActionControl3, (ActionControl)booleanCheckBoxActionControl3, (ActionControl)textBoxActionControl4){
            final /* synthetic */ ActionControl val$restoreLogsByCtl;
            final /* synthetic */ ActionControl val$fromTimeCtl;
            final /* synthetic */ ActionControl val$untilCurrentTimeCtl;
            final /* synthetic */ ActionControl val$untilTimeCtl;
            final /* synthetic */ ActionControl val$fromScnCtl;
            final /* synthetic */ ActionControl val$untilCurrentScnCtl;
            final /* synthetic */ ActionControl val$untilScnCtl;
            final /* synthetic */ ActionControl val$fromSequenceCtl;
            final /* synthetic */ ActionControl val$untilCurrentSequenceCtl;
            final /* synthetic */ ActionControl val$untilSequenceCtl;
            {
                this.val$restoreLogsByCtl = actionControl;
                this.val$fromTimeCtl = actionControl2;
                this.val$untilCurrentTimeCtl = actionControl3;
                this.val$untilTimeCtl = actionControl4;
                this.val$fromScnCtl = actionControl5;
                this.val$untilCurrentScnCtl = actionControl6;
                this.val$untilScnCtl = actionControl7;
                this.val$fromSequenceCtl = actionControl8;
                this.val$untilCurrentSequenceCtl = actionControl9;
                this.val$untilSequenceCtl = actionControl10;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RestoreArchivedLogsAction.this.enableControls(this.val$restoreLogsByCtl, this.val$fromTimeCtl, this.val$untilCurrentTimeCtl, this.val$untilTimeCtl, this.val$fromScnCtl, this.val$untilCurrentScnCtl, this.val$untilScnCtl, this.val$fromSequenceCtl, this.val$untilCurrentSequenceCtl, this.val$untilSequenceCtl);
            }
        });
        booleanCheckBoxActionControl.addPropertyChangeListener(new PropertyChangeListener((ActionControl)temporalActionControl2, (ActionControl)booleanCheckBoxActionControl){
            final /* synthetic */ ActionControl val$untilTimeCtl;
            final /* synthetic */ ActionControl val$untilCurrentTimeCtl;
            {
                this.val$untilTimeCtl = actionControl;
                this.val$untilCurrentTimeCtl = actionControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.val$untilTimeCtl.enableUI(!Boolean.parseBoolean(this.val$untilCurrentTimeCtl.getValue().get()));
            }
        });
        booleanCheckBoxActionControl2.addPropertyChangeListener(new PropertyChangeListener((ActionControl)textBoxActionControl2, (ActionControl)booleanCheckBoxActionControl2){
            final /* synthetic */ ActionControl val$untilScnCtl;
            final /* synthetic */ ActionControl val$untilCurrentScnCtl;
            {
                this.val$untilScnCtl = actionControl;
                this.val$untilCurrentScnCtl = actionControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.val$untilScnCtl.enableUI(!Boolean.parseBoolean(this.val$untilCurrentScnCtl.getValue().get()));
            }
        });
        booleanCheckBoxActionControl3.addPropertyChangeListener(new PropertyChangeListener((ActionControl)textBoxActionControl4, (ActionControl)booleanCheckBoxActionControl3){
            final /* synthetic */ ActionControl val$untilSequenceCtl;
            final /* synthetic */ ActionControl val$untilCurrentSequenceCtl;
            {
                this.val$untilSequenceCtl = actionControl;
                this.val$untilCurrentSequenceCtl = actionControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.val$untilSequenceCtl.enableUI(!Boolean.parseBoolean(this.val$untilCurrentSequenceCtl.getValue().get()));
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)temporalActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl);
        arrayList.add((ActionControl)temporalActionControl2);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl3);
        arrayList.add((ActionControl)booleanCheckBoxActionControl3);
        arrayList.add((ActionControl)textBoxActionControl4);
        arrayList.add((ActionControl)new SeperatorActionControl());
        arrayList.add(new RMANScriptProcessorActionControl(connection, "sqldev.rman", DbaUtil.isArchiveLogMode(connection)));
        return arrayList;
    }

    private void enableControls(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, ActionControl actionControl5, ActionControl actionControl6, ActionControl actionControl7, ActionControl actionControl8, ActionControl actionControl9, ActionControl actionControl10) {
        String string = actionControl.getValue().get();
        boolean bl = string.equals(RESTORE_BY_TIME);
        boolean bl2 = string.equals(RESTORE_BY_SCN);
        boolean bl3 = string.equals(RESTORE_BY_SEQUENCE);
        actionControl2.enableUI(bl);
        actionControl3.enableUI(bl);
        actionControl4.enableUI(bl && !Boolean.parseBoolean(actionControl3.getValue().get()));
        actionControl5.enableUI(bl2);
        actionControl6.enableUI(bl2);
        actionControl7.enableUI(bl2 && !Boolean.parseBoolean(actionControl6.getValue().get()));
        actionControl8.enableUI(bl3);
        actionControl9.enableUI(bl3);
        actionControl10.enableUI(bl3 && !Boolean.parseBoolean(actionControl9.getValue().get()));
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RUN {\n");
        stringBuffer.append("RESTORE ARCHIVELOG ");
        String string = values.get(RESTORE_LOGS_BY);
        if (string.equals(RESTORE_BY_TIME)) {
            stringBuffer.append("FROM TIME \"TO_DATE('");
            stringBuffer.append(values.get(FROM_TIME));
            stringBuffer.append("', 'YYYY-MM-DD HH24:MI:SS')\"");
            if (!Boolean.parseBoolean(values.get(UNTIL_CURRENT_TIME))) {
                stringBuffer.append(" UNTIL TIME \"TO_DATE('");
                stringBuffer.append(values.get(UNTIL_TIME));
                stringBuffer.append("', 'YYYY-MM-DD HH24:MI:SS')\"");
            }
            stringBuffer.append(";\n");
        } else if (string.equals(RESTORE_BY_SCN)) {
            stringBuffer.append("FROM SCN ");
            stringBuffer.append(values.get(FROM_SCN));
            if (!Boolean.parseBoolean(values.get(UNTIL_CURRENT_SCN))) {
                stringBuffer.append(" UNTIL SCN ");
                stringBuffer.append(values.get(UNTIL_SCN));
            }
            stringBuffer.append(";\n");
        } else {
            stringBuffer.append("FROM SEQUENCE ");
            stringBuffer.append(values.get(FROM_SEQUENCE));
            if (!Boolean.parseBoolean(values.get(UNTIL_CURRENT_SEQUENCE))) {
                stringBuffer.append(" UNTIL SEQUENCE ");
                stringBuffer.append(values.get(UNTIL_SEQUENCE));
            }
            stringBuffer.append(" THREAD 1;\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

