/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.IOException;
import java.io.InterruptedIOException;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.TransferProgress;

public class CloneUtils {
    public static void mkdir(Session session, String string) throws IOException {
        ChannelSftp channelSftp = CloneUtils.getChannelToSftpServer(session);
        if (channelSftp != null) {
            try {
                channelSftp.mkdir(string);
            }
            catch (SftpException sftpException) {
                throw new IOException(sftpException.getStackTrace() + "");
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(channelSftp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pathExists(Session session, String string) throws IOException {
        ChannelSftp channelSftp = CloneUtils.getChannelToSftpServer(session);
        if (channelSftp != null) {
            try {
                channelSftp.lstat(string);
            }
            catch (SftpException sftpException) {
                boolean bl = false;
                return bl;
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(channelSftp);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rmFile(Session session, String string) throws IOException {
        ChannelSftp channelSftp = CloneUtils.getChannelToSftpServer(session);
        if (channelSftp != null) {
            try {
                channelSftp.rm(string);
            }
            catch (SftpException sftpException) {
                boolean bl = false;
                return bl;
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(channelSftp);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rmDir(Session session, String string) throws IOException {
        ChannelSftp channelSftp = CloneUtils.getChannelToSftpServer(session);
        if (channelSftp != null) {
            try {
                channelSftp.rmdir(string);
            }
            catch (SftpException sftpException) {
                boolean bl = false;
                return bl;
            }
            finally {
                CloneUtils.disconnectChanneltoSftpServer(channelSftp);
            }
        }
        return true;
    }

    public static void disconnectChanneltoSftpServer(ChannelSftp channelSftp) {
        if (channelSftp != null) {
            channelSftp.disconnect();
        }
    }

    public static boolean isSessionConnected(Session session) {
        return session != null && session.isConnected();
    }

    public static ChannelSftp getChannelToSftpServer(Session session) throws IOException {
        ChannelSftp channelSftp = null;
        if (CloneUtils.isSessionConnected(session)) {
            try {
                Channel channel = session.openChannel("sftp");
                channel.connect();
                channelSftp = (ChannelSftp)channel;
            }
            catch (JSchException jSchException) {
                throw new IOException("Falied to create channel " + jSchException.getMessage());
            }
        }
        return channelSftp;
    }

    public static ChannelSftp upload(Session session, String string, String string2, TransferProgress transferProgress) throws IOException {
        ChannelSftp channelSftp = CloneUtils.getChannelToSftpServer(session);
        if (channelSftp != null) {
            int n = 0;
            boolean bl = false;
            while (n < 3 && !bl) {
                try {
                    if (n == 0) {
                        if (transferProgress != null) {
                            channelSftp.put(string, string2, (SftpProgressMonitor)transferProgress);
                        } else {
                            channelSftp.put(string, string2);
                        }
                    } else if (transferProgress != null) {
                        channelSftp.put(string, string2, (SftpProgressMonitor)transferProgress, 1);
                    } else {
                        channelSftp.put(string, string2, 1);
                    }
                    bl = true;
                }
                catch (SftpException sftpException) {
                    if (sftpException.getCause() instanceof InterruptedIOException) {
                        n = 99;
                    }
                    if (n >= 3) continue;
                    ++n;
                }
            }
            CloneUtils.disconnectChanneltoSftpServer(channelSftp);
        }
        return channelSftp;
    }
}

