/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.pdbs;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.FileNameConvertControl;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbStorageControl;
import oracle.dbtools.raptor.dba.navigator.actions.pdbs.PdbsAction;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionValuesLookup;
import oracle.dbtools.raptor.ui.controls.SqlComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class ClonePdbsAction
extends PdbsAction {
    private static final String PDB_NAME = "PdbName";
    private static final String SRC_NAME = "SrcName";
    private static final String DB_LINK = "DbLink";
    private static final String PDB_STORAGE = "PdbStorage";
    private static final String FILE_CONVERT = "FileConvert";
    private static final String HELP_ID = "f1_dba_clone_pdb_html";
    private Connection connection;

    protected String getHelpId() {
        return HELP_ID;
    }

    protected String getTitle() {
        return DbaNavigatorResources.getString("CLONE_PDB_TITLE");
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    protected List<ActionControl> createControls(final Connection connection) {
        Object object;
        TextBoxActionControl textBoxActionControl;
        Operation operation = this.getOperation();
        TextBoxActionControl textBoxActionControl2 = new TextBoxActionControl(PDB_NAME, DbaNavigatorResources.getString("PDB_NAME"), "NEW_PDB");
        SqlComboBoxActionControl sqlComboBoxActionControl = new SqlComboBoxActionControl(DB_LINK, DbaNavigatorResources.getString("LINK_LABEL"), connection, "select 'NONE' from dual union select db_link from all_db_links");
        ((JComboBox)sqlComboBoxActionControl.getUI()).setSelectedItem("NONE");
        String string = null;
        if (operation == Operation.PDBS) {
            string = this.getDBObjectName();
        }
        final FileNameConvertControl fileNameConvertControl = new FileNameConvertControl(FILE_CONVERT, DbaNavigatorResources.getString("FILE_NAME_CONVERT_LABEL"), connection, string, true, textBoxActionControl2.getValue().get());
        if (operation == Operation.PDBS) {
            textBoxActionControl = new TextBoxActionControl(SRC_NAME, DbaNavigatorResources.getString("SOURCE_PDB"), string);
            textBoxActionControl.setEditable(false);
            sqlComboBoxActionControl.setEditable(false);
            textBoxActionControl2.addPropertyChangeListener(new PropertyChangeListener((ActionControl)textBoxActionControl, (ActionControl)textBoxActionControl2){
                final /* synthetic */ ActionControl val$srcDb;
                final /* synthetic */ ActionControl val$pdbName;
                {
                    this.val$srcDb = actionControl;
                    this.val$pdbName = actionControl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    fileNameConvertControl.resetSourcePdbName(connection, this.val$srcDb.getValue().get(), this.val$pdbName.getValue().get());
                }
            });
            fileNameConvertControl.resetSourcePdbName(connection, textBoxActionControl.getValue().get(), textBoxActionControl2.getValue().get());
        } else {
            object = new SqlComboBoxActionControl(SRC_NAME, DbaNavigatorResources.getString("SOURCE_PDB"), connection, "select name from v$pdbs where name != 'PDB$SEED'");
            object.getUI().addActionListener(arg_0 -> ClonePdbsAction.lambda$createControls$0(fileNameConvertControl, connection, (SqlComboBoxActionControl)object, (ActionControl)textBoxActionControl2, arg_0));
            textBoxActionControl = object;
            textBoxActionControl2.addPropertyChangeListener(new PropertyChangeListener((SqlComboBoxActionControl)object, (ActionControl)textBoxActionControl2){
                final /* synthetic */ SqlComboBoxActionControl val$sqlCombo;
                final /* synthetic */ ActionControl val$pdbName;
                {
                    this.val$sqlCombo = sqlComboBoxActionControl;
                    this.val$pdbName = actionControl;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    fileNameConvertControl.resetSourcePdbName(connection, this.val$sqlCombo.getUI().getSelectedItem().toString(), this.val$pdbName.getValue().get());
                }
            });
            fileNameConvertControl.resetSourcePdbName(connection, object.getUI().getSelectedItem().toString(), textBoxActionControl2.getValue().get());
        }
        object = new PdbStorageControl(PDB_STORAGE, DbaNavigatorResources.getString("STORAGE_LABEL"));
        this.connection = connection;
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl2);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)sqlComboBoxActionControl);
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)fileNameConvertControl);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "    ";
        stringBuilder.append("BEGIN");
        PdbsAction.State state = this.getState(this.connection, values.get(SRC_NAME));
        this.toggleState(stringBuilder, values.get(SRC_NAME), state, PdbsAction.State.READ_ONLY, string);
        stringBuilder.append('\n' + string);
        stringBuilder.append("EXECUTE IMMEDIATE 'CREATE PLUGGABLE DATABASE ");
        stringBuilder.append('\"' + values.get(PDB_NAME) + '\"');
        stringBuilder.append(" FROM ");
        stringBuilder.append('\"' + values.get(SRC_NAME) + '\"');
        if (!values.get(DB_LINK).equals("NONE")) {
            stringBuilder.append("@\"" + values.get(DB_LINK) + '\"');
        }
        stringBuilder.append(PdbStorageControl.getStorageClause(PDB_STORAGE, (ActionValuesLookup)values, string));
        stringBuilder.append(FileNameConvertControl.getFileNameConvertClause(FILE_CONVERT, (ActionValuesLookup)values, false, true, string));
        stringBuilder.append("';");
        this.toggleState(stringBuilder, values.get(SRC_NAME), PdbsAction.State.READ_ONLY, state, string);
        stringBuilder.append("\nEND;");
        return stringBuilder.toString();
    }

    private static /* synthetic */ void lambda$createControls$0(FileNameConvertControl fileNameConvertControl, Connection connection, SqlComboBoxActionControl sqlComboBoxActionControl, ActionControl actionControl, ActionEvent actionEvent) {
        fileNameConvertControl.resetSourcePdbName(connection, sqlComboBoxActionControl.getUI().getSelectedItem().toString(), actionControl.getValue().get());
    }

    private static enum Operation {
        CONTAINER,
        PDBS;

    }
}

