/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.task;

import java.util.ArrayList;
import oracle.ideimpl.webupdate.task.AtomicTask;
import oracle.ideimpl.webupdate.task.InconsistentStateException;
import oracle.ideimpl.webupdate.task.TaskContext;
import oracle.ideimpl.webupdate.task.TaskFailedException;

final class TaskStack {
    private final ArrayList _tasks = new ArrayList();

    TaskStack() {
    }

    public void performTask(AtomicTask task, TaskContext tc) throws TaskFailedException {
        try {
            this._tasks.add(task);
            task.perform(tc);
        }
        catch (RuntimeException re) {
            throw new TaskFailedException("A runtime exception occurred while executing a task.", re);
        }
    }

    public void rollbackTasks(TaskContext tc) throws InconsistentStateException {
        for (int i = this._tasks.size() - 1; i >= 0; --i) {
            AtomicTask task = null;
            try {
                task = (AtomicTask)this._tasks.get(i);
                task.rollback(tc);
                continue;
            }
            catch (Exception e) {
                throw new InconsistentStateException("Failed to rollback task: " + String.valueOf(task), e);
            }
        }
    }

    public void commitTasks(TaskContext tc) throws TaskFailedException {
        for (AtomicTask task : this._tasks) {
            task.commit(tc);
        }
    }
}

