/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.parser.UpdateHandler;
import oracle.javatools.xml.esax.ElementContext;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.Key;

abstract class BundleHandler
extends ElementHandler {
    private static final Key KEY_BUNDLE = new Key("bundle");
    private ElementHandler _updateHandler = this.createUpdateHandler();
    private ElementHandler _nameHandler = new NameHandler();
    private ElementHandler _bundleUrlHandler = new BundleUrlHandler();
    private ElementHandler _destinationHandler = new DestinationHandler();

    BundleHandler() {
    }

    protected abstract ElementHandler createUpdateHandler();

    protected abstract void handleBundle(ElementContext var1, UpdateBundle var2);

    public void handleStart(ElementStartContext context) {
        UpdateBundle bundle = new UpdateBundle();
        context.putValue(KEY_BUNDLE, (Object)bundle);
        context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "name", this._nameHandler);
        context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "bundle-url", this._bundleUrlHandler);
        context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "update", this._updateHandler);
        context.registerChildHandler("http://xmlns.oracle.com/jdeveloper/update", "destination", this._destinationHandler);
    }

    public void handleEnd(ElementEndContext context) {
        this.handleBundle((ElementContext)context, BundleHandler.getBundle((ElementContext)context));
    }

    static UpdateBundle getBundle(ElementContext context) {
        return (UpdateBundle)context.getValue(KEY_BUNDLE);
    }

    private static final class DestinationHandler
    extends ElementHandler {
        private DestinationHandler() {
        }

        public void handleEnd(ElementEndContext context) {
            UpdateBundle bundle = BundleHandler.getBundle((ElementContext)context);
            bundle.setInstallLocation(UpdateHandler.getText(context));
        }
    }

    private static final class BundleUrlHandler
    extends ElementHandler {
        private BundleUrlHandler() {
        }

        public void handleEnd(ElementEndContext context) {
            UpdateBundle bundle = BundleHandler.getBundle((ElementContext)context);
            bundle.setDownloadUrl(UpdateHandler.getText(context));
        }
    }

    private static final class NameHandler
    extends ElementHandler {
        private NameHandler() {
        }

        public void handleEnd(ElementEndContext context) {
            UpdateBundle bundle = BundleHandler.getBundle((ElementContext)context);
            bundle.setName(UpdateHandler.getText(context));
        }
    }
}

