/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.commandline;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.webbrowser.HttpPing;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webupdate.Directories;
import oracle.ideimpl.webupdate.InvalidLocalBundleException;
import oracle.ideimpl.webupdate.LocalUpdateBundle;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateInfo;
import oracle.ideimpl.webupdate.commandline.BundleDownloader;
import oracle.ideimpl.webupdate.commandline.CheckForCompatiableUpdates;
import oracle.ideimpl.webupdate.commandline.PreInstaller;
import oracle.ideimpl.webupdate.util.UpdateUtil;

public class CommandLineUpdate {
    private static final String PROXY_FAILED_MESSAGE = "Proxy Failed: Internal Update Center won't be found";
    private Directories directories;
    private String portNumber;
    private String hostName;
    private List<String> localBundles = Collections.emptyList();
    private List<String> remoteBundles = Collections.emptyList();
    private PreInstaller installer;
    private boolean ingoreInvalidBundles;
    private boolean verbose;
    private CheckForCompatiableUpdates checkForUpdates;

    public static CommandLineUpdate createWithoutProperties() {
        return new CommandLineUpdate();
    }

    public static CommandLineUpdate createFromPropertiesFile(CommandLineUpdate clu, String propertiesFilePath) {
        Map<String, List<String>> properties = CommandLineUpdate.parsePropertiesFile(propertiesFilePath);
        List<String> list = properties.get("proxy.hostname");
        if (list != null && !list.isEmpty()) {
            clu.setHostName(list.get(0));
        }
        if ((list = properties.get("proxy.portnumber")) != null && !list.isEmpty()) {
            clu.setPortNumber(list.get(0));
        }
        clu.addLocalBundles(properties.get("bundle"));
        clu.addRemoteExtensions(properties.get("extension"));
        return clu;
    }

    private CommandLineUpdate() {
        this.directories = new StandaloneDirectories();
        this.checkForUpdates = CheckForCompatiableUpdates.getInstance();
        this.installer = PreInstaller.createCommandLineInstaller(this.directories);
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setPortNumber(String portNumber) {
        this.portNumber = portNumber;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.checkForUpdates.setVerbose(verbose);
    }

    public void setIgnoreInvalidBundles(boolean ignore) {
        this.ingoreInvalidBundles = ignore;
    }

    public void addRemoteExtensions(List<String> remoteBundles) {
        if (remoteBundles != null && !remoteBundles.isEmpty()) {
            if (this.remoteBundles.isEmpty()) {
                this.remoteBundles = new ArrayList<String>();
            }
            this.remoteBundles.addAll(remoteBundles);
        }
    }

    public void addLocalBundles(List<String> localBundles) {
        if (localBundles != null && !localBundles.isEmpty()) {
            if (this.localBundles.isEmpty()) {
                this.localBundles = new ArrayList<String>();
            }
            this.localBundles.addAll(localBundles);
        }
    }

    public boolean validateOptions() {
        return this.localBundles != null && !this.localBundles.isEmpty() || this.remoteBundles != null && !this.remoteBundles.isEmpty();
    }

    private void setupProxy() {
        if (this.remoteBundles.isEmpty()) {
            return;
        }
        ProxyOptions options = ProxyOptions.getProxyOptions();
        options.setUseSystemProxy(Boolean.valueOf(true));
        ProxyOptions.setProxyOptions((ProxyOptions)options);
        URL url = URLFactory.newURL((String)"http://download.oracle.com");
        HttpPing ping = new HttpPing(options, url);
        try {
            ping.ping();
        }
        catch (HttpPing.PingFailedException failure) {
            if (this.hostName != null && !this.hostName.isEmpty() && this.portNumber != null && !this.portNumber.isEmpty()) {
                options.setProxyHost(this.hostName);
                options.setProxyPort(this.portNumber);
                options.setUseSystemProxy(Boolean.valueOf(false));
                options.setUseProxy(Boolean.valueOf(true));
                try {
                    ping = new HttpPing(options, url);
                    ping.ping();
                    ProxyOptions.setProxyOptions((ProxyOptions)options);
                }
                catch (HttpPing.PingFailedException finalException) {
                    System.err.println(PROXY_FAILED_MESSAGE);
                }
            }
            System.err.println(PROXY_FAILED_MESSAGE);
        }
    }

    public void doUpdate() throws InvalidLocalBundleException {
        this.setupProxy();
        HashMap<UpdateBundle, File> zipFilesByBundle = new HashMap<UpdateBundle, File>();
        zipFilesByBundle.putAll(this.getLocalUpdates());
        zipFilesByBundle.putAll(this.getRemoteUpdates());
        this.installer.getModel().setDownloadedUpdates(zipFilesByBundle);
        this.installer.commit();
        this.log("Command Line Update finished successfully");
    }

    public void showCommandsOnOuput() {
        this.setupProxy();
        ArrayList<UpdateInfo> updates = new ArrayList<UpdateInfo>(this.checkForUpdates.getUpdates());
        Collections.sort(updates, new Comparator<UpdateInfo>(){

            @Override
            public int compare(UpdateInfo u1, UpdateInfo u2) {
                return u1.getName().compareTo(u2.getName());
            }
        });
        this.log("==== Available Updates =====");
        for (UpdateInfo info : updates) {
            System.out.printf("%-50s %s\n", info.getName(), " ID: " + info.getID());
        }
    }

    private Map<UpdateBundle, File> getLocalUpdates() throws InvalidLocalBundleException {
        this.trace("Checking for local bundles");
        HashMap<UpdateBundle, File> zipFilesByBundle = new HashMap<UpdateBundle, File>();
        for (LocalUpdateBundle b : this.populateLocalBundles()) {
            File bundleFile = b.getBundleFile();
            UpdateBundle bundle = b.getBundle();
            zipFilesByBundle.put(bundle, bundleFile);
        }
        this.trace("" + zipFilesByBundle.size() + " local bundles found");
        return zipFilesByBundle;
    }

    private List<LocalUpdateBundle> populateLocalBundles() throws InvalidLocalBundleException {
        ArrayList<LocalUpdateBundle> bundles = new ArrayList<LocalUpdateBundle>();
        for (String extension : this.localBundles) {
            File f = new File(extension);
            if (f.exists()) {
                LocalUpdateBundle bundle = LocalUpdateBundle.createInstance(f, false);
                bundles.add(bundle);
                continue;
            }
            if (this.ingoreInvalidBundles) continue;
            throw new InvalidLocalBundleException("bundle doesn't exist:" + extension);
        }
        return bundles;
    }

    private Map<UpdateBundle, File> getRemoteUpdates() throws InvalidLocalBundleException {
        this.trace("Checking for remote bundles");
        ArrayList<UpdateInfo> updateInfoes = new ArrayList<UpdateInfo>();
        for (String extensionId : this.remoteBundles) {
            UpdateInfo updateInfo = this.checkForUpdates.getUpdateInfo(extensionId);
            if (updateInfo != null) {
                updateInfoes.add(updateInfo);
                continue;
            }
            ExtensionRegistry reg = ExtensionRegistry.getExtensionRegistry();
            Extension extension = reg.findExtension(extensionId);
            if (extension != null) {
                System.out.printf("Bundle %s is already installed\n", extensionId);
                continue;
            }
            throw new InvalidLocalBundleException("bundle doesn't exist:" + extensionId);
        }
        if (updateInfoes.isEmpty()) {
            this.trace("0 bundles found");
            return new HashMap<UpdateBundle, File>();
        }
        BundleDownloader downloader = new BundleDownloader(updateInfoes);
        Map<UpdateBundle, File> map = downloader.getUpdates();
        this.trace("" + map.size() + " remote bundles found");
        return map;
    }

    private static Map<String, List<String>> parsePropertiesFile(String propertiesFilePath) {
        File f = new File(propertiesFilePath);
        if (!f.exists()) {
            System.err.println("Properties file doesn't exist: " + propertiesFilePath);
            System.exit(1);
        }
        HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
        try {
            properties = UpdateUtil.readProperties(f);
        }
        catch (IOException e) {
            System.err.println("Error reading properties file:" + propertiesFilePath);
            System.exit(1);
        }
        return properties;
    }

    private void log(String s) {
        System.out.println(s);
    }

    private void trace(String s) {
        if (this.verbose) {
            System.out.println(s);
        }
    }

    private static class StandaloneDirectories
    implements Directories {
        private String ide_home;
        private String user_directory;
        private String oracle_home = Ide.getOracleHomeDirectory();
        private String m_temp;

        StandaloneDirectories() {
            this.user_directory = Ide.getUserSettingsDirectory();
            this.ide_home = new File(Ide.getLibDirectory()).getParent();
        }

        @Override
        public void save(List<String> list) {
            list.add("temp=" + this.getTemp());
            list.add("globalExtensionsHome=" + this.getGlobalExtensionsHome());
            list.add("patchesHome=" + this.getPatchesHome());
            list.add("userExtensionsHome=" + this.getUserExtensionsHome());
            list.add("globalSettingsHome=" + this.getGlobalSettingsHome());
            list.add("userSettingsHome=" + this.getUserSettingsHome());
            list.add("oracleHome=" + this.getOracleHome());
            list.add("bundlesInfoHome=" + this.getBundlesInfoHome());
        }

        @Override
        public String getTemp() {
            if (this.m_temp == null) {
                File f = new File(this.getUserSettingsHome() + File.separator + "tmp", "update");
                this.m_temp = f.getPath();
            }
            return this.m_temp;
        }

        @Override
        public String getGlobalExtensionsHome() {
            return this.ide_home + File.separator + "extensions";
        }

        @Override
        public String getPatchesHome() {
            return this.getGlobalSettingsHome() + File.separator + "patches";
        }

        @Override
        public String getUserExtensionsHome() {
            return this.getUserSettingsHome() + File.separator + "lib";
        }

        @Override
        public String getGlobalSettingsHome() {
            return this.ide_home + File.separator + "lib";
        }

        @Override
        public String getUserSettingsHome() {
            return this.user_directory;
        }

        @Override
        public String getOracleHome() {
            return this.oracle_home;
        }

        @Override
        public String getBundlesInfoHome() {
            return this.getOracleHome() + File.separator + "configuration";
        }
    }
}

