/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.net.URL;
import java.util.AbstractCollection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.file.FileChange;
import oracle.ide.file.FileTable;
import oracle.ide.net.URLKey;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.util.NullArgumentException;

public final class FileChanges
extends AbstractCollection<FileChange> {
    private int version;
    private long cookie;
    private final Map<URLKey, FileChange> changes = new LinkedHashMap<URLKey, FileChange>();

    FileChanges(int version, long cookie) {
        this.version = version;
        this.cookie = cookie;
    }

    void addImpl(FileChange change) {
        this.changes.put(URLKey.getInstance((URL)change.getURL()), change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChange getChange(@NotNull URL file) {
        if (file == null) {
            throw new NullArgumentException("null file");
        }
        Map<URLKey, FileChange> map = this.changes;
        synchronized (map) {
            return this.changes.get(URLKey.getInstance((URL)file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Map<URLKey, FileChange> map = this.changes;
        synchronized (map) {
            return this.changes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        Map<URLKey, FileChange> map = this.changes;
        synchronized (map) {
            return this.version;
        }
    }

    public long getCookie() {
        return this.cookie;
    }

    @Override
    public Iterator<FileChange> iterator() {
        return this.changes.values().iterator();
    }

    String getDiffString() {
        if (this.changes.isEmpty()) {
            return "No changes";
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        for (FileChange change : this) {
            if (builder.length() != 0) {
                builder.append(lineSeparator);
            }
            switch (change.getChangeType()) {
                case ADDED: {
                    builder.append("+");
                    break;
                }
                case MODIFIED: {
                    builder.append("!");
                    break;
                }
                case BUFFER_MODIFIED: {
                    builder.append("#");
                    break;
                }
                case REMOVED: {
                    builder.append("-");
                }
            }
            FileTable table = change.getFileTable();
            builder.append(table.getRelativePath(change.getURL()));
            long lastModified = change.getLastModified();
            if (lastModified == -1L) continue;
            builder.append(" [");
            builder.append(new Date(lastModified).toString());
            builder.append("]");
        }
        return builder.toString();
    }
}

