/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.ideimpl.db.validate.DBValidationManager;
import oracle.javatools.db.DBObject;

public class DBValidationTreeCellRenderer
implements TreeCellRenderer {
    private final DBValidationManager m_mgr;
    private final TreeCellRenderer m_delegate;

    public DBValidationTreeCellRenderer(DBValidationManager mgr, TreeCellRenderer delegate) {
        this.m_mgr = mgr;
        this.m_delegate = delegate;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component retval = this.m_delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DBObject obj = this.getDBObject(tree, value, row);
        if (obj != null) {
            retval = this.m_mgr.processRendererComponent(retval, obj, null);
        }
        return retval;
    }

    protected DBObject getDBObject(JTree tree, Object value, int row) {
        if (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        }
        return value instanceof DBObject ? (DBObject)value : null;
    }
}

