/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.validators.MissingValidatorException;
import oracle.javatools.db.validators.ValidationException;

public class IndexColumnExpressionsPanel
extends ChildTableEditorPanel<IndexObject, DBObject> {
    public IndexColumnExpressionsPanel() {
        super("IndexColumnExpressionsPanel");
    }

    @Override
    protected String[] getPropertiesForRow() {
        return new String[]{"expressionSource", "orderType"};
    }

    @Override
    protected Class<IndexObject> getChildClass() {
        return IndexObject.class;
    }

    @Override
    protected IndexObject newChild() {
        IndexObject[] newChildren;
        IndexObject colExpr = (IndexObject)this.getProvider().getObjectFactory().newObject(IndexObject.class);
        TemporaryObjectID.setID((DBObject)colExpr, (boolean)true);
        Object obj = this.getUpdatedObject();
        PropertyHelper propertyHelper = this.getPropertyHelper();
        String childProp = this.getChildProperty();
        IndexObject[] existing = (IndexObject[])propertyHelper.getPropertyValue(obj, childProp);
        if (existing == null) {
            newChildren = new IndexObject[]{colExpr};
        } else {
            newChildren = new IndexObject[existing.length + 1];
            System.arraycopy(existing, 0, newChildren, 0, existing.length);
            newChildren[existing.length] = colExpr;
        }
        propertyHelper.setPropertyValue(obj, childProp, (Object)newChildren);
        Relation tab = (Relation)DBUtil.findParentOfType(obj, Relation.class);
        if (tab != null) {
            boolean ok = false;
            DBObjectProvider pro = this.getProvider();
            for (Column c : tab.getColumns()) {
                colExpr.setExpression((SQLFragment)new ColumnUsage(c.getID()));
                try {
                    pro.validateObjectProperty(obj, this.getChildProperty());
                    ok = true;
                    break;
                }
                catch (MissingValidatorException mve) {
                    ok = true;
                    break;
                }
                catch (ValidationException validationException) {
                }
            }
            if (!ok) {
                colExpr.setExpressionSource(null);
            }
        }
        return colExpr;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.enableButtons();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
    }

    @Override
    public boolean canAddRow() {
        Object obj = this.getUpdatedObject();
        if (obj instanceof Index && obj.getParent() == null) {
            return false;
        }
        return super.canAddRow();
    }

    @Override
    protected boolean shouldValidateOnExit() {
        return !(this.getUpdatedObject() instanceof Index);
    }

    @Override
    protected boolean disableButtonsIfPropertyCannotChange() {
        return true;
    }
}

