/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.util.SchemaObjectBuilder;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;

public class CopyColumnPanel
extends JPanel {
    private DBObjectProvider m_pro;
    private Relation m_table;
    private Relation m_sourceTable;
    private boolean m_edit = false;
    private JLabel m_lblSchema = new JLabel();
    private JLabel m_lblTable = new JLabel();
    private JLabel m_lblColumns = new JLabel();
    private DBObjectChooser m_schemas = new DBObjectChooser("SCHEMA");
    private DBObjectChooser m_tables = new DBObjectChooser(this.m_schemas, "TABLE");
    private JList<String> m_columns = new JList();
    private JScrollPane m_scrCols = new JScrollPane(this.m_columns);
    private DBUIResourceHelper m_helper = new DBUIResourceHelper("ColumnInfoPanel.CopyColumnPanel");

    public CopyColumnPanel(DBObjectProvider pro, Relation table, boolean edit) {
        this.m_pro = pro;
        this.m_table = table;
        this.m_edit = edit;
        this.setLayout(new GridBagLayout());
        this.m_helper.resLabel(this.m_lblSchema, this.m_schemas, UIBundle.get("COPY_COLUMN_LABEL_SCHEMA"), "m_schemas");
        this.m_helper.resLabel(this.m_lblTable, this.m_tables, UIBundle.get("COPY_COLUMN_LABEL_TABLE"), "m_tables");
        this.m_helper.resLabel(this.m_lblColumns, this.m_scrCols, UIBundle.get("COPY_COLUMN_LABEL_COLUMNS"), "m_scrCols");
        this.add((Component)this.m_lblSchema, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_lblTable, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_lblColumns, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_schemas, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tables, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_scrCols, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.m_schemas.setProvider(pro);
        this.m_schemas.setDBObject((DBObject)this.m_table.getSchema());
        this.m_tables.setDBObject((DBObject)this.m_table);
        this.updateColumns();
        this.m_schemas.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                CopyColumnPanel.this.updateColumns();
            }
        });
        this.m_tables.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                CopyColumnPanel.this.updateColumns();
            }
        });
        this.setPreferredSize(new Dimension(400, 200));
        HelpUtils.setHelpID((JComponent)this, (String)"f1_odbtacopycolumns_html");
    }

    private void updateColumns() {
        DefaultListModel<String> model = new DefaultListModel<String>();
        DBObject selected = this.m_tables.getDBObject();
        if (selected instanceof Relation) {
            this.m_sourceTable = (Relation)selected;
            DatabaseDescriptor desc = this.m_pro.getDescriptor();
            if (desc.areNamesEqual((DBObject)this.m_sourceTable.getSchema(), (DBObject)this.m_table.getSchema()) && desc.areNamesEqual((DBObject)this.m_sourceTable, (DBObject)this.m_table)) {
                this.m_sourceTable = this.m_table;
            }
            SchemaObjectBuilder builder = new SchemaObjectBuilder(true);
            builder.setProperties("TABLE", "columns");
            if (builder.ensureObjectBuilt(new DBObject[]{this.m_sourceTable})) {
                for (Column col : this.m_sourceTable.getColumns()) {
                    model.addElement(col.getName() + " " + DataTypeHelper.getDDL((DataTypeUsage)col.getDataTypeUsage(), (DBObjectProvider)this.m_pro));
                }
            }
        }
        this.m_columns.setModel(model);
    }

    public List<Column> getSelectedColumns() {
        int[] sel;
        this.m_schemas.cancel();
        this.m_tables.cancel();
        ArrayList<Column> retval = new ArrayList<Column>();
        if (this.m_sourceTable != null && (sel = this.m_columns.getSelectedIndices()).length > 0) {
            Column[] tabCols = this.m_sourceTable.getColumns();
            Column[] colsToCopy = new Column[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                colsToCopy[i] = tabCols[sel[i]];
            }
            SchemaObjectBuilder builder = new SchemaObjectBuilder(true);
            if (builder.ensureObjectBuilt((DBObject[])colsToCopy)) {
                for (Column toCopy : colsToCopy) {
                    Column copy = (Column)toCopy.copyTo(null);
                    retval.add(copy);
                }
            }
        }
        return retval;
    }
}

