/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.components.ConstraintColumnIDsComponentWrapper;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.table.ConstraintsPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.validators.ValidationException;

public class ConstraintEditorPanel
extends ChildObjectEditorPanel<Constraint, Relation> {
    private Component m_horizGap;
    private JButton m_newPKButton;
    private JCheckBox m_identifyingBox;
    private BaseObjectID m_lastGoodRef;

    public ConstraintEditorPanel() {
        super("ConstraintEditorPanel", "constraints");
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        return new SwingDBObjectListener(){

            @Override
            public void updateUI(DBObjectChange change) {
                DBObject obj = change.getDBObject();
                Map changes = change.getPropertiesChanged();
                if (obj instanceof FKConstraint) {
                    boolean refChanged = changes.containsKey("referenceID");
                    boolean colsChanged = changes.containsKey("columnIDs");
                    if (refChanged || colsChanged) {
                        if (!colsChanged) {
                            ((FKConstraint)obj).setColumnIDs(null);
                        }
                        ConstraintEditorPanel.this.fkRefChanged();
                    }
                }
                if (obj instanceof ColumnConstraint && changes.containsKey("columnIDs")) {
                    ConstraintEditorPanel.this.ensureColumnsNotNull((ColumnConstraint)obj);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialiseChildComponents() {
        Constraint con = (Constraint)this.getChildObject();
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        boolean standalone = this.getEditorConfig().isChildEditOnly();
        if (standalone) {
            JEWTDialog dialog;
            if (this.getOriginalChildObject() == null && (dialog = (JEWTDialog)this.getDataContext().find(JEWTDialog.class)) != null) {
                if (con instanceof FKConstraint) {
                    dialog.setTitle(UIBundle.get("FK_TITLE"));
                } else if (con instanceof PKConstraint) {
                    dialog.setTitle(UIBundle.get("PK_TITLE"));
                }
                dialog.setName("create" + con.getConstraintType());
            }
            layout.add(this.getOrCreateWrapper("name"));
            layout.nextRow();
            layout.add(this.getOrCreateWrapper("enabled"));
            layout.nextRow();
            layout.add(this.getOrCreateWrapper("deferrableState"));
        }
        layout.nextRow();
        layout.add(this.getOrCreateWrapper("indexID"));
        ComponentWrapper conditionWrapper = this.getOrCreateWrapper("checkCondition");
        layout.nextRow();
        layout.add(conditionWrapper.getLabel(), 2, 1);
        layout.nextRow();
        layout.add(conditionWrapper.getComponent(), 2, 1, true, true);
        Component refComp = this.getOrCreateWrapper("referenceID").getComponent();
        Component colsComp = this.getOrCreateWrapper("columnIDs").getComponent();
        colsComp.setPreferredSize(new Dimension(200, 150));
        ComponentWrapper delWrapper = this.getOrCreateWrapper("onDeleteAction");
        if (standalone) {
            DBUIResourceHelper reshelp = this.getComponentFactory().getResourceHelper();
            layout.nextRow();
            layout.addChildren(refComp, new Integer[0]);
            DBEditorFactory fac = DBEditorFactoryRegistry.getEditFactory((SchemaObject)this.getUpdatedObject(), this.getProvider());
            boolean temp = false;
            PKConstraint pk = PKConstraint.getPrimaryKey((Relation)((Relation)this.getUpdatedObject()));
            if (pk == null) {
                pk = new PKConstraint();
                ((Relation)this.getUpdatedObject()).addConstraint((Constraint)pk);
                temp = true;
            }
            try {
                if (fac.canEditDBObject((DBObject)pk, this.getProvider())) {
                    layout.nextRow();
                    AbstractAction createPKAction = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ConstraintEditorPanel.this.createPK();
                        }
                    };
                    this.m_newPKButton = new JButton(createPKAction);
                    reshelp.resButton(this.m_newPKButton, UIBundle.get("FK_BUTTON_ADD_PK"), "AddPK");
                    layout.add(this.m_newPKButton, 2, 1, false, false);
                    layout.getConstraints((Component)this.m_newPKButton).anchor = 13;
                }
            }
            finally {
                if (temp) {
                    ((Relation)this.getUpdatedObject()).removeConstraint((Constraint)pk);
                }
            }
            layout.nextRow();
            layout.add(colsComp, 2, 1, true, true);
            layout.nextRow();
            layout.add(delWrapper);
            this.m_identifyingBox = new JCheckBox();
            reshelp.resButton(this.m_identifyingBox, UIBundle.get("FK_LABEL_PUT_FK_COLS_IN_PK"), "Identifying");
            layout.nextRow();
            layout.add(this.m_identifyingBox, 2, 1);
        } else {
            JPanel subPanel = new JPanel();
            DBUILayoutHelper subLayout = new DBUILayoutHelper(subPanel, this.isInFlatEditor());
            subLayout.setMarginTop(0);
            subLayout.addChildren(refComp, new Integer[0]);
            subLayout.nextRowWithGap();
            subLayout.add(delWrapper);
            subLayout.pushUp();
            subLayout.add(colsComp, 1, 10, true, true);
            GridBagConstraints colsGBC = subLayout.getConstraints(colsComp);
            colsGBC.gridx = 10;
            colsGBC.gridy = 0;
            colsGBC.insets.left = 0;
            this.m_horizGap = Box.createHorizontalStrut(24);
            subLayout.add(this.m_horizGap, 1, 1, false, false);
            GridBagConstraints gapGBC = subLayout.getConstraints(this.m_horizGap);
            gapGBC.gridx = 9;
            subLayout.getConstraints((Component)this.m_horizGap).gridy = 0;
            subLayout.getConstraints((Component)this.m_horizGap).insets.left = 0;
            subLayout.layout();
            layout.nextRow();
            layout.add(subPanel, 2, 1, true, true);
        }
        Collection<PropertyInfo> extras = DatabaseExtensionHook.getHook().getAutoIncludedProperties(this.getProvider(), Constraint.class);
        for (PropertyInfo info : extras) {
            String extraProp = info.getPropertyName();
            try {
                ComponentWrapper wrapper = this.getOrCreateWrapper(extraProp);
                layout.nextRow();
                layout.add(wrapper);
            }
            catch (Exception e) {
                DBLog.getLogger((Object)((Object)this)).log(Level.WARNING, "Could not add extra property " + extraProp, e);
            }
        }
        layout.layout();
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.setLastRef();
        Constraint con = (Constraint)this.getChildObject();
        boolean isFK = con instanceof FKConstraint;
        this.setVisible(this.m_horizGap, isFK);
        this.setVisible(this.m_newPKButton, isFK);
        this.setVisible(this.m_identifyingBox, isFK);
        if (isFK && this.m_identifyingBox != null) {
            this.m_identifyingBox.setSelected(this.isIdentifying((FKConstraint)con));
        }
    }

    private boolean isIdentifying(FKConstraint fk) {
        boolean retval = false;
        DBObjectID[] fkIDs = fk.getColumnIDs();
        PKConstraint pk = PKConstraint.getPrimaryKey((Relation)fk.getRelation());
        if (fkIDs.length > 0 && pk != null) {
            DBObjectID[] pkIDs = pk.getColumnIDs();
            retval = Arrays.asList(pkIDs).containsAll(Arrays.asList(fkIDs));
        }
        return retval;
    }

    private void setVisible(Component c, boolean visible) {
        if (c != null) {
            c.setVisible(visible);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        Constraint con = (Constraint)this.getChildObject();
        Relation rel = con.getRelation();
        if (con instanceof FKConstraint && this.m_identifyingBox != null && this.m_identifyingBox.isSelected()) {
            boolean isNewPK = false;
            PKConstraint pk = PKConstraint.getPrimaryKey((Relation)rel);
            if (pk == null) {
                isNewPK = true;
                pk = (PKConstraint)ConstraintsPanel.newConstraint(rel, "PKConstraint", this.getProvider());
            }
            ArrayList<DBObjectID> pkIDs = new ArrayList<DBObjectID>();
            for (DBObjectID id : pk.getColumnIDs()) {
                pkIDs.add(id);
            }
            for (DBObjectID id : ((FKConstraint)con).getColumnIDs()) {
                if (pkIDs.contains(id)) continue;
                pkIDs.add(id);
            }
            pk.setColumnIDs(pkIDs.toArray(new DBObjectID[pkIDs.size()]));
            if (isNewPK) {
                rel.addConstraint((Constraint)pk);
            }
            this.ensureColumnsNotNull((ColumnConstraint)pk);
        }
        if (!this.isInFlatEditor() && con instanceof UniqueConstraint) {
            ConstraintIndexHelper helper = ConstraintEditorPanel.getIndexHelper(this.getDataContext());
            try {
                helper.ensureAndValidateIndexes((UniqueConstraint)con, this.getValidationLevel());
            }
            catch (ValidationException ve) {
                throw new TraversalException(ve.getMessage());
            }
        }
        super.commitPanel();
    }

    private void setLastRef() {
        DBObjectID ref;
        Constraint con = (Constraint)this.getChildObject();
        if (con instanceof FKConstraint && (ref = ((FKConstraint)con).getReferenceID()) instanceof BaseObjectID) {
            this.m_lastGoodRef = (BaseObjectID)ref;
        }
    }

    private void fkRefChanged() {
        this.setLastRef();
        ConstraintColumnIDsComponentWrapper wrapper = (ConstraintColumnIDsComponentWrapper)this.getOrCreateWrapper("columnIDs");
        if (!wrapper.getFKWrapper().isCommiting()) {
            wrapper.refreshObject((DBObject)this.getChildObject());
        }
        if (this.m_newPKButton != null) {
            Relation rel = this.getReferencedRelation();
            boolean enabled = rel != null && PKConstraint.getPrimaryKey((Relation)rel) == null;
            this.m_newPKButton.setEnabled(enabled);
        }
    }

    private Relation getReferencedRelation() {
        Relation retval = null;
        Constraint con = (Constraint)this.getChildObject();
        if (con instanceof FKConstraint) {
            DBObjectID id = ((FKConstraint)con).getReferenceID();
            if (id == null) {
                id = this.m_lastGoodRef;
            }
            if (id instanceof BaseObjectID) {
                DBObjectID relID = id.getParent();
                try {
                    DBObject rel = relID.resolveID();
                    if (rel instanceof Relation) {
                        retval = (Relation)rel;
                    }
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
                }
            } else if (id != null) {
                DBObject par;
                DBObject refCon = null;
                try {
                    refCon = id.resolveID();
                }
                catch (DBException dbe) {
                    DBLog.getLogger((Object)((Object)this)).warning(dbe.getMessage());
                }
                if (refCon != null && (par = refCon.getParent()) instanceof Relation) {
                    retval = (Relation)par;
                }
            }
        }
        return retval;
    }

    private void ensureColumnsNotNull(ColumnConstraint con) {
        if (!this.getProvider().getDescriptor().isNullConstraintColumnAllowed(con)) {
            Relation rel = con.getRelation();
            for (DBObjectID colID : con.getColumnIDs()) {
                Column col = (Column)rel.findOwnedObject(colID);
                if (col == null || col.isNotNull()) continue;
                col.setNotNull(true);
            }
        }
    }

    private void createPK() {
        DBEditorFactory fac;
        Relation rel = this.getReferencedRelation();
        if (rel != null && (fac = DBEditorFactoryRegistry.getEditFactory((SchemaObject)rel, this.getProvider())) != null) {
            PKConstraint pk;
            boolean isThis = rel == this.getUpdatedObject();
            DBEditorConfig config = DBEditorConfig.newEditConfig(this.getProvider(), (DBObject)rel);
            Relation copyRel = (Relation)config.getUpdatedObject();
            PKConstraint newPK = (PKConstraint)ConstraintsPanel.newConstraint(copyRel, "PKConstraint", this.getProvider());
            copyRel.addConstraint((Constraint)newPK);
            config.setObjectType(newPK.getType());
            config.setChildObject((DBObject)newPK);
            config.setChildEditOnly(true);
            config.setCommitToProvider(!isThis);
            fac.launchDialog(config);
            if (config.getResult() == DBEditorConfig.Result.SUCCESS && (pk = PKConstraint.getPrimaryKey((Relation)rel)) != null) {
                FKConstraint fk = (FKConstraint)this.getChildObject();
                fk.setReferenceID(pk.getID());
                ComponentWrapper refCW = this.getComponentFactory().findComponentWrapper("referenceID");
                if (refCW != null) {
                    refCW.refreshObject((DBObject)fk);
                }
            }
        }
    }

    static ConstraintIndexHelper getIndexHelper(Namespace dataContext) {
        ConstraintIndexHelper retval = (ConstraintIndexHelper)dataContext.find(ConstraintIndexHelper.class);
        if (retval == null) {
            DBEditorConfig config = (DBEditorConfig)dataContext.find(DBEditorConfig.class);
            retval = new ConstraintIndexHelper(config.getProvider(), (Table)config.getUpdatedObject());
            dataContext.put(ConstraintIndexHelper.class.getName(), (Object)retval);
        }
        return retval;
    }
}

