/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.partition;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildSelectableComponentEditorPanel;
import oracle.ideimpl.db.panels.partition.AbstractPartitionPanel;
import oracle.ideimpl.db.panels.partition.HashPartitionPanel;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.LocalIndexPartitionHelper;
import oracle.javatools.db.ora.OracleTablePartitions;

public abstract class AbstractCascadingTablePartitionPanel
extends AbstractPartitionPanel {
    private boolean m_cascadeRequired = false;
    private OracleTablePartitions m_otp;

    public AbstractCascadingTablePartitionPanel(String panelName, ChildSelectableComponentEditorPanel childSelectableComponentEditorPanel, HashPartitionPanel hashPartitionPanel) {
        super(panelName, childSelectableComponentEditorPanel, hashPartitionPanel);
    }

    public abstract String[] getCascadeProperties();

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        if (this.getProvider() instanceof Database) {
            OracleTablePartitions otp = (OracleTablePartitions)this.getUpdatedObject().getProperty("OracleTablePartitions");
            this.m_otp = (OracleTablePartitions)DBUtil.makeTemporaryCopy((DBObject)otp);
            this.setCascadeIsRequired(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        if (this.m_cascadeRequired) {
            this.doCascade();
        }
    }

    @Override
    protected DBObjectListener createComponentFactoryObjectListener() {
        String[] cascadeProps;
        SwingDBObjectPropertyListener cascadePropsListener = null;
        if (this.getProvider() instanceof Database && (cascadeProps = this.getCascadeProperties()) != null && cascadeProps.length > 0) {
            cascadePropsListener = new SwingDBObjectPropertyListener(cascadeProps){

                @Override
                protected void updateUI(DBObject obj, String propertyName, PropertyChangeEvent pce) {
                    AbstractCascadingTablePartitionPanel.this.setCascadeIsRequired(true);
                }
            };
        }
        return cascadePropsListener;
    }

    private void setCascadeIsRequired(boolean cascade) {
        this.m_cascadeRequired = cascade;
    }

    private void doCascade() {
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof Database) {
            Table table = (Table)this.getUpdatedObject();
            OracleTablePartitions otp = (OracleTablePartitions)this.getUpdatedObject().getProperty("OracleTablePartitions");
            try {
                LocalIndexPartitionHelper.cascadeTablePartitions((SystemObject)table, (OracleTablePartitions)this.m_otp, (OracleTablePartitions)otp, (Database)((Database)pro));
            }
            catch (DBException dbe) {
                DBExceptionDialog.showErrorDialog((Component)((Object)this), ProviderOperator.getErrorTitle(this.getEditorConfig()), dbe);
            }
        }
    }
}

