/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectDefineEditorPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleInMemoryProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.Property;

public class OracleInMemoryPropertiesPanel
extends ChildObjectDefineEditorPanel<OracleInMemoryProperties, DBObject> {
    public OracleInMemoryPropertiesPanel() {
        super("OracleInMemoryPropertiesPanel", null);
        this.setHelpID("f1_odbtainmemory_html");
    }

    @Override
    protected String getPropertyPath() {
        String retval = "OracleInMemoryProperties";
        if (this.getUpdatedObject() instanceof Tablespace) {
            retval = Property.createPath((String[])new String[]{"OracleTablespaceProperties", retval});
        }
        return retval;
    }

    @Override
    protected void initialiseChildComponents(DBUILayoutHelper layout) {
        DBObject par = this.getComponentFactoryUpdatedObject();
        boolean singleCol = par instanceof TablePartition;
        ComponentWrapper imWrapper = this.getOrCreateWrapper("inMemory");
        layout.add(imWrapper);
        layout.nextRow();
        layout.add(this.getOrCreateWrapper("inMemoryCompression"));
        if (singleCol) {
            layout.nextRow();
        }
        layout.add(this.getOrCreateWrapper("inMemoryPriority"));
        layout.nextRow();
        layout.add(this.getOrCreateWrapper("inMemoryDistribute"));
        if (singleCol) {
            layout.nextRow();
        }
        layout.add(this.getOrCreateWrapper("inMemoryDuplicate"));
        if (singleCol) {
            layout.pushUp();
        }
        imWrapper.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OracleInMemoryPropertiesPanel.this.checkComponents();
            }
        });
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.checkComponents();
    }

    @Override
    protected String getDefineCheckBoxText() {
        DBObject obj = this.getComponentFactoryOriginalObject();
        String retval = this.getProvider() instanceof Database && obj instanceof Table && Boolean.TRUE.equals(obj.getProperty("PARTITIONED TABLE")) ? UIBundle.get("INMEM_EDIT_PARTITIONED_TABLE") : super.getDefineCheckBoxText();
        return retval;
    }

    @Override
    protected void enabledChildComponents(boolean enable) {
        super.enabledChildComponents(enable);
        if (enable) {
            this.checkComponents();
        }
    }

    private void checkComponents() {
        if (this.isEnabled() && this.getDefineCheckBox().isSelected()) {
            boolean enabled = ((OracleInMemoryProperties)this.getChildObject()).isInMemory();
            this.setWrapperEnabled("inMemoryCompression", enabled);
            this.setWrapperEnabled("inMemoryDuplicate", enabled);
            this.setWrapperEnabled("inMemoryPriority", enabled);
            this.setWrapperEnabled("inMemoryDistribute", enabled);
        }
    }

    private void setWrapperEnabled(String prop, boolean enabled) {
        ComponentWrapper wrap = this.getComponentFactory().findComponentWrapper(this.getComponentPath(prop));
        if (wrap != null) {
            wrap.setEnabled(enabled);
        }
    }

    @Override
    protected Class<OracleInMemoryProperties> getChildClass() {
        return OracleInMemoryProperties.class;
    }

    @Override
    protected Dimension getDialogInitialSize() {
        return new Dimension(400, 400);
    }
}

