/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.panels.DBTabbedPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.Property;

public abstract class ChildTableTabPanel<C extends ChildDBObject, P extends DBObject>
extends ChildObjectEditorPanel<C, P> {
    private TableColumnsTabbedPanel m_tabPane;
    private Map<Class, Navigable> m_tabsMap;
    private final List<TabSelectedListener> m_listeners = new ArrayList<TabSelectedListener>();
    private Integer m_defaultTabIndex;
    private TraversableContext m_tabContext;

    protected ChildTableTabPanel(String panelName, String basePath, Integer defaultTabIndex) {
        super(panelName, basePath);
        this.m_defaultTabIndex = defaultTabIndex;
    }

    protected ChildTableTabPanel(String panelName, String basePath) {
        this(panelName, basePath, -1);
    }

    @Override
    protected void initialiseChildComponents() {
        this.addTabs();
        DBUILayoutHelper layout = this.getDBUILayoutHelper();
        layout.add((Component)((Object)this.m_tabPane));
        layout.layout();
    }

    @Override
    protected void initialisePanel() {
        Object selectedChild;
        DBObject child;
        super.initialisePanel();
        if (!this.hasProcessedInitialSelection() && (child = this.getEditorConfig().getChildObject()) != null && (selectedChild = this.getChildObject()) != null && child != selectedChild && !child.getClass().equals(selectedChild.getClass())) {
            int index;
            String prop = null;
            String fullProp = null;
            DBObject par = null;
            DBObject test = child;
            while (test != null) {
                par = test.getParent();
                String parProp = DBUtil.getParentProperty((DBObject)test);
                fullProp = Property.createPath((String[])new String[]{parProp, fullProp});
                if (par == selectedChild) {
                    prop = parProp;
                    break;
                }
                test = par;
            }
            if (prop != null && (index = this.m_tabPane.findNavigableIndex(fullProp)) >= 0) {
                this.m_defaultTabIndex = index;
                this.getInitialSelection(child.getClass());
            }
        }
        this.onTabEntry();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (this.m_tabContext != null) {
            this.m_tabPane.ignoreListeners(true);
            this.m_tabPane.onExit(this.m_tabContext);
            this.m_tabPane.ignoreListeners(false);
        }
        super.commitPanel();
    }

    protected void onTabEntry() {
        if (this.m_tabPane != null) {
            boolean firstEntry;
            boolean bl = firstEntry = this.m_tabContext == null;
            if (firstEntry) {
                this.m_tabContext = new TraversableContext(this.getDataContext(), 0);
            } else {
                this.enableTabs();
            }
            if (this.m_defaultTabIndex != null) {
                this.m_tabContext.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", (Object)this.m_defaultTabIndex);
            }
            this.m_tabPane.ignoreListeners(true);
            this.m_tabPane.onEntry(this.m_tabContext);
            this.m_tabPane.ignoreListeners(false);
            if (firstEntry) {
                this.enableTabs();
            }
            this.validate();
            this.repaint();
            this.m_defaultTabIndex = null;
        }
    }

    protected abstract Collection<Navigable> getTabs();

    private void addTabs() {
        this.m_tabsMap = new HashMap<Class, Navigable>();
        this.m_tabPane = new TableColumnsTabbedPanel(this.getTabNavs());
    }

    private Navigable[] getTabNavs() {
        Collection<Navigable> tabNavs = this.getTabs();
        for (Navigable nav : tabNavs) {
            this.m_tabsMap.put(nav.getTraversableClass(), nav);
        }
        Navigable[] navs = tabNavs.toArray(new Navigable[tabNavs.size()]);
        return navs;
    }

    protected void refreshTabs() {
        if (this.m_tabPane != null) {
            this.m_tabPane.setRootNavigables(this.getTabNavs());
            this.m_tabContext = null;
        }
    }

    protected Navigable createNavigable(String tabHeader, Class tabClass, String ... properties) {
        Navigable nav = this.m_tabsMap.get(tabClass);
        if (nav == null) {
            nav = new DBNavigable(tabHeader, tabClass);
            if (properties != null) {
                ((DBNavigable)nav).setProperties(Arrays.asList(properties));
            }
        }
        return nav;
    }

    protected void setEnabledTab(Class tabClass, boolean enabled) {
        Navigable nav = this.m_tabsMap.get(tabClass);
        if (nav != null) {
            this.m_tabPane.enableTabForNavigable(nav, enabled);
        }
    }

    public final void addTabSelectedListener(TabSelectedListener l) {
        this.m_listeners.add(l);
    }

    public final void removeTabSelectedListener(TabSelectedListener l) {
        this.m_listeners.remove(l);
    }

    protected void notifyTabListeners() {
        for (TabSelectedListener cl : this.m_listeners) {
            cl.tabSelected();
        }
    }

    public void selectDefaultTab(int defaultTabIndex) {
        int currSel = this.m_tabPane.getSelectedIndex();
        this.m_defaultTabIndex = defaultTabIndex;
        if (currSel != defaultTabIndex && (defaultTabIndex == -1 || currSel == -1)) {
            this.onTabEntry();
        }
    }

    protected void enableTabs() {
    }

    public static interface TabSelectedListener {
        public void tabSelected();
    }

    private class TableColumnsTabbedPanel
    extends DBTabbedPanel {
        private boolean m_ignoreListeners;

        public TableColumnsTabbedPanel(Navigable[] rootNavigables) {
            super(rootNavigables);
            this.setBaseEditorPanel(ChildTableTabPanel.this);
        }

        @Override
        public Navigable getCurrentNavigable() {
            if (!this.m_ignoreListeners) {
                ChildTableTabPanel.this.notifyTabListeners();
            }
            return super.getCurrentNavigable();
        }

        public void ignoreListeners(boolean ignore) {
            this.m_ignoreListeners = ignore;
        }
    }
}

