/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components.table;

import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.event.TableModelEvent;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.controls.BigDataAccessParamsTable;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.ui.ResizeComponent;

public class BigDataAccessParametersComponentWrapper
extends AsynchronousComponentWrapper<JComponent> {
    private final BigDataAccessParamsTable m_table = (BigDataAccessParamsTable)KeyValueTable.getKeyValueTable((JComponent)this.getActiveComponent());

    public BigDataAccessParametersComponentWrapper() {
        super(new BigDataAccessParamsTable().getComponent().getTableContainer());
    }

    @Override
    protected void prepareForWrite() {
        this.m_table.stopCellEditing();
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getActiveComponent();
    }

    @Override
    public Component[] getFocusComponents() {
        return null;
    }

    final KeyValueTable getKeyValueTable() {
        return this.m_table;
    }

    @Override
    protected Component createComponentForLayout() {
        JComponent retval = (JComponent)this.getActiveComponent();
        if (this.getComponentContext().isInFlatEditor()) {
            retval = new ResizeComponent(retval);
        }
        return retval;
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        this.m_table.addTableModelListener(new ExtendedTable.ExtendedTableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (BigDataAccessParametersComponentWrapper.this.isAddEvent(e)) {
                    BigDataAccessParametersComponentWrapper.this.markDirty();
                } else {
                    BigDataAccessParametersComponentWrapper.this.fireChangeEvent();
                }
            }

            @Override
            public void cellValueEdited(TableModelEvent e) {
                BigDataAccessParametersComponentWrapper.this.markDirty();
            }
        });
    }

    private boolean isAddEvent(TableModelEvent e) {
        boolean retval;
        boolean bl = retval = e.getType() == 1;
        if (!retval) {
            ExtendedTable.StringTableModel model = this.getKeyValueTable().getModel();
            int row = e.getFirstRow();
            if (e.getLastRow() == row && row >= 0 && row < model.getRowCount()) {
                retval = true;
                for (int i = 0; i < model.getColumnCount(); ++i) {
                    if (model.getValueAt(row, i) == null) continue;
                    retval = false;
                    break;
                }
            }
        }
        return retval;
    }

    @Override
    public Object getPropertyValue() {
        BigDataAccessParameters params = this.m_table.getAccessParameters();
        return params == null ? null : params.getSQLText();
    }

    @Override
    public void setPropertyValue(Object val) {
        SQLFragment frag;
        OracleExternalTableProperties props;
        BigDataAccessParameters params = null;
        if (val != null && (props = (OracleExternalTableProperties)this.getUpdatedObject().getProperty("OracleExternalTableProperties")) != null && (frag = props.getAccessParametersFragment()) instanceof BigDataAccessParameters) {
            params = (BigDataAccessParameters)frag;
        }
        this.m_table.setAccessParameters(params, (Relation)DBUtil.findParentOfType((DBObject)this.getUpdatedObject(), Relation.class), this.getProvider());
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        this.checkKeys();
    }

    @Override
    public boolean refreshObject(DBObject refreshedObject) {
        this.checkKeys();
        return super.refreshObject(refreshedObject);
    }

    private void checkKeys() {
        String driver;
        Collection keys = null;
        OracleExternalTableProperties props = (OracleExternalTableProperties)this.getUpdatedObject().getProperty("OracleExternalTableProperties");
        if (props != null && BigDataAccessParameterMetadata.isBigDataAccessDriver((String)(driver = props.getAccessDriverType()))) {
            keys = BigDataAccessParameterMetadata.getAllowedParameterNames((String)driver);
        }
        this.m_table.setKeys(keys);
    }
}

