/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ideimpl.db.components.SubTypeComponentWrapper;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;

public class TableTypeComponentWrapper
extends SubTypeComponentWrapper {
    private final Map<String, String> m_typeMappings = new HashMap<String, String>();

    @Override
    protected Map<String, Object> getInvalidProperties(SystemObject obj) {
        Map<String, Object> retval = super.getInvalidProperties(obj);
        if (obj instanceof Table && !retval.containsKey("constraints")) {
            Collection<String> invalidTypes = this.getInvalidConstraintTypes((Table)obj);
            for (String cType : invalidTypes) {
                String rsKey = this.m_typeMappings.get(cType);
                if (rsKey == null) {
                    rsKey = DBTypeDisplayRegistry.getDisplayName(cType);
                    this.m_typeMappings.put(rsKey, cType);
                }
                retval.put(rsKey, cType);
            }
        }
        return retval;
    }

    @Override
    protected boolean shouldEnsurePanels() {
        return true;
    }

    private Collection<String> getInvalidConstraintTypes(Table table) {
        Collection allowedTypes = this.getProvider().getPropertyManager().getAllowedPropertyValues(null, (DBObject)table, "constraintType");
        HashSet<String> retval = new HashSet<String>();
        for (Constraint c : table.getConstraints()) {
            if (allowedTypes.contains(c.getConstraintType())) continue;
            retval.add(c.getConstraintType());
        }
        return retval;
    }

    @Override
    protected void clearInvalidProperty(SystemObject obj, String prop, Object value) {
        if (obj instanceof Table && this.m_typeMappings.containsKey(prop)) {
            if (value instanceof String) {
                for (Constraint con : Constraint.getConstraints((Relation)((Table)obj), (String[])new String[]{(String)value})) {
                    ((Table)obj).removeConstraint(con);
                }
            }
        } else {
            super.clearInvalidProperty(obj, prop, value);
        }
    }

    @Override
    protected boolean shouldCacheInvalidProperty(String prop) {
        return prop.equals("OracleExternalTableProperties") || prop.equals("OracleStorageProperties") || prop.equals("OracleIndexOrganizedTableProperties");
    }

    @Override
    protected boolean shouldRecurseToChildProperties(String prop) {
        return prop.equals("OracleStorageProperties");
    }
}

