/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

public class SchemaComponentWrapper
extends ComponentWrapper<DBObjectChooser> {
    private JPanel m_panel;
    private CardLayout m_panelLayout;
    private Component m_publicField;
    private boolean m_isPublic;

    public SchemaComponentWrapper() {
        super(new DBObjectChooser("SCHEMA"));
    }

    @Override
    public void setPropertyValue(Object value) {
        if (!this.isPublicSchema(value)) {
            this.changeLayout(false);
            ((DBObjectChooser)this.getActiveComponent()).setDBObject((DBObject)((Schema)value));
        } else {
            this.changeLayout(true);
        }
    }

    @Override
    public Object getPropertyValue() {
        return ((DBObjectChooser)this.getActiveComponent()).getOrCreateDBObject();
    }

    @Override
    protected void initialiseComponentListener() {
        ((DBObjectChooser)this.getActiveComponent()).addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                SchemaComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void initialiseComponent() {
        DBObjectChooser chooser = (DBObjectChooser)this.getActiveComponent();
        DBObjectProvider pro = this.getProvider();
        chooser.setProvider(pro);
        if (!(pro instanceof Database)) {
            chooser.setEditable(true);
            chooser.getDBObjectCriteria().setUserOnly(true);
        }
        ComponentContext context = this.getComponentContext();
        String type = context.getUpdatedObject().getType();
        String priv = context.getOriginalSystemObject() == null ? "CREATE" : "MODIFY";
        chooser.setFilter(schema -> !this.isPublicSchema(schema) && pro.hasSystemPrivilege(type, (Schema)schema, priv));
        boolean supportsPublic = pro.getPropertyManager().supportsProperty(type, "public");
        if (supportsPublic) {
            this.m_panelLayout = new CardLayout();
            this.m_panel = new JPanel(this.m_panelLayout);
            this.m_publicField = new JTextArea(pro.getDescriptor().getPublicSchemaName());
            this.m_publicField.setEnabled(false);
            this.m_panel.add((Component)this.getActiveComponent(), Boolean.FALSE.toString());
            this.m_panel.add(this.m_publicField, Boolean.TRUE.toString());
        }
    }

    private boolean isPublicSchema(Object schema) {
        return schema instanceof Schema && ModelUtil.areEqual((Object)((Schema)schema).getName(), (Object)this.getProvider().getDescriptor().getPublicSchemaName());
    }

    @Override
    protected void setActiveImpl(boolean active) {
        boolean inFlatEditor = this.getComponentContext().isInFlatEditor();
        ((DBObjectChooser)this.getActiveComponent()).setActive(active, inFlatEditor, inFlatEditor);
    }

    @Override
    protected Component createComponentForLayout() {
        return this.m_panel == null ? this.getActiveComponent() : this.m_panel;
    }

    private void changeLayout(boolean isPublic) {
        if (this.m_panelLayout != null && this.m_isPublic != isPublic) {
            this.m_isPublic = isPublic;
            this.m_panelLayout.show((Container)this.getComponent(), Boolean.toString(isPublic));
            ((DBObjectChooser)this.getActiveComponent()).setEnabled(!isPublic);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.m_publicField != null) {
            ((DBObjectChooser)this.getActiveComponent()).setVisible(false);
            this.m_publicField.setVisible(false);
            if (visible) {
                this.m_isPublic = !this.m_isPublic;
                this.changeLayout(!this.m_isPublic);
            }
        }
    }

    @Override
    public String getPropertyDisplayName() {
        return this.getProvider().getDescriptor().getSchemaDisplayName();
    }
}

