/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ideimpl.db.components.TextPropertyComponentWrapper;

public class NumberPropertyComponentWrapper
extends TextPropertyComponentWrapper<NumberTextField> {
    public NumberPropertyComponentWrapper() {
        super(new NumberTextField());
    }

    @Override
    public void setPropertyValueImpl(Object value) {
        if (value instanceof String) {
            try {
                value = ((NumberTextField)this.getActiveComponent()).getDataType().equals(Integer.class) ? Integer.valueOf(value.toString()) : BigInteger.valueOf(Long.valueOf(value.toString()));
            }
            catch (NumberFormatException nfe) {
                value = null;
            }
        }
        ((NumberTextField)this.getActiveComponent()).setNumber((Number)value);
    }

    @Override
    public Object getPropertyValue() {
        return ((NumberTextField)this.getActiveComponent()).getNumber();
    }

    public void setUseBigIntegers(boolean useBigIntegers) {
        if (useBigIntegers) {
            ((NumberTextField)this.getActiveComponent()).setDataType(BigInteger.class);
            ((NumberTextField)this.getActiveComponent()).setScientific(true);
        } else {
            ((NumberTextField)this.getActiveComponent()).setDataType(Integer.class);
            ((NumberTextField)this.getActiveComponent()).setScientific(false);
        }
    }

    @Override
    protected void initialiseComponentListener() {
        super.initialiseComponentListener();
        ((NumberTextField)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberPropertyComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        ((NumberTextField)this.getActiveComponent()).setColumns(1);
    }
}

