/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import oracle.ide.db.components.ComponentContext;
import oracle.ideimpl.db.components.EnumPropertyComponentWrapper;
import oracle.ideimpl.db.panels.partition.OraclePartitionsHandler;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;

public class IndexPartitionTypePropertyWrapper
extends EnumPropertyComponentWrapper {
    @Override
    protected ItemListener createItemListener() {
        return new TypeComboListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropertyValue(Object value) {
        JComboBox comp;
        DefaultComboBoxModel model;
        IndexPartitionTypeComboItem select = IndexPartitionTypeComboItem.NONE;
        if (value instanceof OracleIndexPartitions.PartitionType) {
            OracleIndexPartitions.PartitionType type = (OracleIndexPartitions.PartitionType)value;
            select = this.getPartitionTypeComboItem(type);
        }
        if ((model = (DefaultComboBoxModel)(comp = (JComboBox)this.getActiveComponent()).getModel()).getIndexOf((Object)select) == -1) {
            model.insertElementAt(select, 0);
        }
        boolean active = this.isActive();
        this.setActive(false);
        try {
            ((JComboBox)this.getActiveComponent()).setSelectedItem((Object)select);
        }
        finally {
            this.setActive(active);
        }
    }

    private IndexPartitionTypeComboItem getPartitionTypeComboItem(OracleIndexPartitions.PartitionType type) {
        IndexPartitionTypeComboItem select = type == OracleIndexPartitions.PartitionType.GLOBAL_RANGE ? IndexPartitionTypeComboItem.GLOBAL_RANGE : (type == OracleIndexPartitions.PartitionType.GLOBAL_HASH ? IndexPartitionTypeComboItem.GLOBAL_HASH : (type == OracleIndexPartitions.PartitionType.DOMAIN ? IndexPartitionTypeComboItem.DOMAIN : IndexPartitionTypeComboItem.LOCAL));
        return select;
    }

    @Override
    public Object getPropertyValue() {
        IndexPartitionTypeComboItem item = (IndexPartitionTypeComboItem)((Object)((JComboBox)this.getActiveComponent()).getSelectedItem());
        Object type = null;
        if (item == IndexPartitionTypeComboItem.GLOBAL_RANGE) {
            type = OracleIndexPartitions.PartitionType.GLOBAL_RANGE;
        } else if (item == IndexPartitionTypeComboItem.GLOBAL_HASH) {
            type = OracleIndexPartitions.PartitionType.GLOBAL_HASH;
        } else if (item == IndexPartitionTypeComboItem.LOCAL) {
            OracleTablePartitions.PartitionType tabPartType;
            Index index = (Index)this.getUpdatedObject();
            Table table = (Table)index.getParent();
            OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
            type = otp == null ? null : ((tabPartType = otp.getPartitionType()) == OracleTablePartitions.PartitionType.HASH ? OracleIndexPartitions.PartitionType.LOCAL_HASH : OracleIndexPartitions.PartitionType.LOCAL_OTHER);
        } else if (item == IndexPartitionTypeComboItem.DOMAIN) {
            type = OracleIndexPartitions.PartitionType.DOMAIN;
        }
        return type;
    }

    @Override
    protected Collection getAllowedValues() {
        ArrayList<IndexPartitionTypeComboItem> retval = new ArrayList<IndexPartitionTypeComboItem>();
        Index index = (Index)this.getUpdatedObject();
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (index.getIndexType() == Index.IndexType.DOMAIN) {
            retval.add(IndexPartitionTypeComboItem.NONE);
            retval.add(IndexPartitionTypeComboItem.DOMAIN);
        } else {
            Table table = OraclePartitionsHandler.getOwningTable((DBObject)index);
            if (table != null) {
                OracleTablePartitions otp = (OracleTablePartitions)table.getProperty("OracleTablePartitions");
                for (IndexPartitionTypeComboItem item : IndexPartitionTypeComboItem.values()) {
                    if (item.isDomain() || oip == null && otp == null && item.isLocal()) continue;
                    retval.add(item);
                }
            }
        }
        return retval;
    }

    @Override
    protected ListCellRenderer getRenderer() {
        return null;
    }

    private OracleIndexPartitions getPartitions() {
        Index index = (Index)this.getUpdatedObject();
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        if (oip == null) {
            oip = (OracleIndexPartitions)this.getProvider().getObjectFactory().newObject(OracleIndexPartitions.class, (DBObject)index);
        }
        return oip;
    }

    private class TypeComboListener
    implements ItemListener {
        private TypeComboListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && IndexPartitionTypePropertyWrapper.this.isActive() && IndexPartitionTypePropertyWrapper.this.getPartitions() != null) {
                OracleIndexPartitions partitions = IndexPartitionTypePropertyWrapper.this.getPartitions();
                if (partitions.getParent() == null) {
                    ComponentContext parentCC = IndexPartitionTypePropertyWrapper.this.getComponentContext().getParentComponentContext();
                    partitions.setParent(parentCC.getUpdatedObject());
                }
                DBObject parent = partitions.getParent();
                IndexPartitionTypeComboItem type = (IndexPartitionTypeComboItem)((Object)e.getItem());
                OracleIndexPartitions current = (OracleIndexPartitions)parent.getProperty("OracleIndexPartitions");
                OracleIndexPartitions toSet = partitions;
                if (current != null && type == IndexPartitionTypeComboItem.NONE) {
                    toSet = null;
                } else if (type != IndexPartitionTypeComboItem.LOCAL && type != IndexPartitionTypeComboItem.DOMAIN) {
                    partitions.setPartitions(new IndexPartition[0]);
                }
                parent.setProperty("OracleIndexPartitions", (Object)toSet);
                IndexPartitionTypePropertyWrapper.this.fireChangeEvent();
            }
        }
    }

    private static enum IndexPartitionTypeComboItem {
        NONE(UIBundle.get("INDEX_PARTITIONS_LIST_NONE"), false),
        GLOBAL_RANGE(UIBundle.get("INDEX_PARTITIONS_LIST_GLOBAL_RANGE"), false),
        GLOBAL_HASH(UIBundle.get("INDEX_PARTITIONS_LIST_GLOBAL_HASH"), false),
        LOCAL(UIBundle.get("INDEX_PARTITIONS_LIST_LOCAL"), true),
        DOMAIN(UIBundle.get("INDEX_PARTITIONS_LIST_DOMAIN"), true, true);

        private final String m_text;
        private final boolean m_local;
        private final boolean m_domain;

        private IndexPartitionTypeComboItem(String text, boolean local, boolean domain) {
            this.m_text = text;
            this.m_local = local;
            this.m_domain = domain;
        }

        private IndexPartitionTypeComboItem(String text, boolean local) {
            this(text, local, false);
        }

        public String toString() {
            return this.m_text;
        }

        public boolean isLocal() {
            return this.m_local;
        }

        public boolean isDomain() {
            return this.m_domain;
        }
    }
}

