/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.components.AsynchronousComponentWrapper;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;

public class IndexObjectComponentWrapper
extends AsynchronousComponentWrapper<CustomCombo> {
    private Document m_document;
    private DocumentListener m_docListener;

    public IndexObjectComponentWrapper() {
        super(new CustomCombo());
        CustomCombo comp = (CustomCombo)this.getActiveComponent();
        comp.setParent(this);
    }

    @Override
    protected void initialiseComponent() {
        super.initialiseComponent();
        if (DBUtil.findParentOfType((DBObject)this.getUpdatedObject(), Index.class) != null) {
            JComboBox comp = (JComboBox)this.getActiveComponent();
            comp.setEditable(true);
            Component editor = comp.getEditor().getEditorComponent();
            if (editor instanceof JTextField) {
                this.m_document = ((JTextField)editor).getDocument();
                this.m_docListener = new AsynchronousComponentWrapper.AsynchronousDocumentListener();
            } else {
                this.m_document = null;
                this.m_docListener = null;
            }
        }
    }

    @Override
    public Object getPropertyValue() {
        JComboBox combo = (JComboBox)this.getActiveComponent();
        Object retval = combo.isEditable() ? combo.getEditor().getItem() : combo.getSelectedItem();
        return retval;
    }

    @Override
    public void setPropertyValue(Object val) {
        CustomCombo comp = (CustomCombo)this.getActiveComponent();
        comp.reset();
        if (comp.isEditable()) {
            this.enableDocListener(false);
            comp.setSelectedItem((String)val);
            this.enableDocListener(true);
        } else {
            comp.setSelectedItem(val);
        }
    }

    @Override
    protected void initialiseComponentListener() {
        ((CustomCombo)this.getActiveComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexObjectComponentWrapper.this.fireChangeEvent();
            }
        });
    }

    @Override
    protected void losingFocus() {
        super.losingFocus();
        this.enableDocListener(false);
    }

    @Override
    protected void gainingFocus() {
        super.gainingFocus();
        this.enableDocListener(true);
    }

    private void enableDocListener(boolean enable) {
        if (this.m_document != null && this.m_docListener != null) {
            this.m_document.removeDocumentListener(this.m_docListener);
            if (enable) {
                this.m_document.addDocumentListener(this.m_docListener);
            }
        }
    }

    @Override
    protected void setActiveImpl(boolean active) {
        super.setActiveImpl(active);
        if (!active) {
            ((CustomCombo)this.getActiveComponent()).cancel();
        }
    }

    static class CustomCombo
    extends AbstractLazyCombo {
        private ComponentWrapper m_parent = null;

        CustomCombo() {
        }

        @Override
        public void setName(String name) {
            super.setName(name + "-combo");
            if (this.getEditor() != null) {
                this.getEditor().getEditorComponent().setName(name);
            }
        }

        private void setParent(ComponentWrapper parent) {
            this.m_parent = parent;
        }

        @Override
        protected List getModelEntries() {
            ArrayList<String> ret = new ArrayList<String>();
            if (this.m_parent != null) {
                ComponentContext ctx = this.m_parent.getComponentContext();
                DBEditorConfig indexEditorConfig = ctx.getEditorConfig();
                DBObjectProvider pro = ctx.getProvider();
                SystemObject obj = indexEditorConfig.getUpdatedObject();
                Relation table = (Relation)DBUtil.findParentOfType((DBObject)obj, Table.class);
                if (table != null) {
                    for (Column col : table.getColumns()) {
                        ret.add(pro.getExternalName(col.getName(), "COLUMN"));
                    }
                }
            }
            return ret;
        }
    }
}

