/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class DBObjectRenderer
implements TableCellRenderer,
ListCellRenderer,
TreeCellRenderer {
    private static final String EMPTY = "<" + UIBundle.get("EMPTY") + ">";
    private TableCellRenderer m_tableDelegate;
    private ListCellRenderer m_listDelegate;
    private TreeCellRenderer m_treeDelegate;
    private String m_nullLabel;
    private DBObjectProvider m_prov;
    private boolean m_iconify;
    private boolean m_showSchema;

    public DBObjectRenderer() {
    }

    public DBObjectRenderer(boolean includeIcon) {
        this.m_iconify = includeIcon;
    }

    public String getNullLabel() {
        return this.m_nullLabel;
    }

    public void setNullLabel(String lbl) {
        this.m_nullLabel = lbl;
    }

    public void setProvider(DBObjectProvider prov) {
        this.m_prov = prov;
    }

    public void setIncludeIcon(boolean boo) {
        this.m_iconify = boo;
    }

    private Object normalise(Object value) {
        Object retval = value;
        if (value instanceof TemporaryObjectID) {
            try {
                DBObject obj = ((TemporaryObjectID)value).resolveID();
                if (obj != null) {
                    retval = obj;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return retval;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if ((value = this.normalise(value)) instanceof DBObject && (value = ((DBObject)value).getName()) == null) {
            value = this.m_nullLabel;
        }
        if (this.m_tableDelegate == null) {
            this.m_tableDelegate = new DefaultTableCellRenderer();
        }
        return this.m_tableDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        value = this.normalise(value);
        if (this.m_listDelegate == null) {
            this.m_listDelegate = new DefaultListCellRenderer();
        }
        Object renderMe = value;
        String type = null;
        if (value instanceof SQLFragment) {
            if (value instanceof ColumnUsage) {
                type = "COLUMN";
                renderMe = ((ColumnUsage)value).getColumnName();
            } else {
                renderMe = ((SQLFragment)value).getSQLText();
            }
        } else if (value instanceof DBObject) {
            type = ((DBObject)value).getType();
            renderMe = ((DBObject)value).getName();
            if (null != this.m_prov) {
                Schema s;
                String quotedName = null;
                try {
                    quotedName = this.m_prov.quoteIdentifier((String)renderMe, false);
                }
                catch (DBException e) {
                    quotedName = (String)renderMe;
                }
                renderMe = quotedName;
                if (this.m_showSchema && value instanceof SchemaObject && (s = ((SchemaObject)value).getSchema()) != null) {
                    renderMe = s.getName() + "." + (String)renderMe;
                }
            }
            if (value instanceof FKConstraint && !ModelUtil.hasLength((String)((String)renderMe))) {
                renderMe = " ";
            }
            if (!ModelUtil.hasLength((String)((String)renderMe)) && value instanceof Schema && ((Schema)value).getProperty("isDefaultSchema", (Object)Boolean.FALSE).equals(Boolean.TRUE)) {
                renderMe = UIBundle.get("DEFAULT_USER");
            }
            if (renderMe == null) {
                renderMe = this.m_nullLabel;
            }
        } else if (value instanceof SchemaObjectDescriptor) {
            renderMe = ((SchemaObjectDescriptor)value).getName();
            String otherName = ((SchemaObjectDescriptor)value).getOtherName();
            if (otherName != null && !otherName.equals(renderMe)) {
                renderMe = (String)renderMe + " (" + otherName + ")";
            }
            String schema = ((SchemaObjectDescriptor)value).getSchema();
            if (this.m_showSchema && ModelUtil.hasLength((String)schema)) {
                renderMe = schema + "." + (String)renderMe;
            }
            type = ((SchemaObjectDescriptor)value).getType();
        }
        if (renderMe instanceof String && renderMe != this.m_nullLabel && ("PACKAGE BODY".equals(type) || "TYPE BODY".equals(type))) {
            renderMe = UIBundle.format("BODY_FORMAT", renderMe);
        }
        JLabel retval = (JLabel)this.m_listDelegate.getListCellRendererComponent(list, renderMe, index, isSelected, cellHasFocus);
        if (this.m_iconify && type != null) {
            retval.setIcon(DBTypeDisplayRegistry.getNodeIcon(type));
        }
        if (value instanceof AliasFragment) {
            this.setupAliasFragmentLabel(retval, (AliasFragment)value);
        } else if (value instanceof OrderByObject) {
            if (renderMe == null || ((OrderByObject)value).getExpression() == null) {
                retval.setText(EMPTY);
            }
        } else if (value instanceof SimpleSQLFragment && renderMe == null) {
            retval.setText(EMPTY);
        }
        return retval;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon;
        if (this.m_treeDelegate == null) {
            this.m_treeDelegate = new DefaultTreeCellRenderer();
        }
        JLabel retval = (JLabel)this.m_treeDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        String type = null;
        if (value instanceof DefaultMutableTreeNode) {
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if ((obj = this.normalise(obj)) instanceof SchemaObjectDescriptor) {
                String name = ((SchemaObjectDescriptor)obj).getName();
                type = ((SchemaObjectDescriptor)obj).getType();
                if ("PACKAGE BODY".equals(type) || "TYPE BODY".equals(type)) {
                    name = UIBundle.format("BODY_FORMAT", name);
                }
                retval.setText(name);
            } else if (obj instanceof AliasFragment) {
                if (obj instanceof FromObject) {
                    FromObject from = (FromObject)obj;
                    SQLFragment pivotExpr = from.getPivotExpression();
                    if (from.getExpression() instanceof JoinObject) {
                        JoinObject join = (JoinObject)from.getExpression();
                        String joinType = join.getJoinType();
                        String text = "JOIN";
                        if (joinType != null) {
                            text = joinType + " " + text;
                        }
                        retval.setText(text);
                        if (this.m_iconify) {
                            retval.setIcon(DBTypeDisplayRegistry.getNodeIcon("CONSTRAINT"));
                        }
                    } else {
                        String alias;
                        StringBuffer text = new StringBuffer(from.getExpression().getSQLText());
                        if (pivotExpr != null) {
                            text.append(" ").append(pivotExpr.getSQLText());
                        }
                        if (ModelUtil.hasLength((String)(alias = from.getAlias()))) {
                            text.insert(0, alias + " (");
                            text.append(")");
                        }
                        retval.setText(text.toString());
                        this.setupIcon(retval, from.getExpression());
                    }
                } else {
                    this.setupAliasFragmentLabel(retval, (AliasFragment)obj);
                }
            } else if (obj instanceof FKUsage) {
                FromObject right;
                String text = null;
                DBObjectID id = ((FKUsage)obj).getObjectID();
                if (id != null) {
                    try {
                        DBObject fk = id.resolveID();
                        text = fk.getName();
                    }
                    catch (DBException dbe) {
                        Assert.printStackTrace((Throwable)dbe);
                    }
                }
                if ((right = ((FKUsage)obj).resolveRightFromObject()) != null) {
                    text = text + " (" + right.getName() + ")";
                }
                retval.setText(text);
                if (this.m_iconify) {
                    retval.setIcon(DBTypeDisplayRegistry.getNodeIcon("CONSTRAINT"));
                }
            } else if (obj instanceof SQLFragment) {
                String sql = ((SQLFragment)obj).getSQLText();
                retval.setText(sql);
                DBObjectRenderer.setToolTipText(retval, sql);
                if (obj instanceof ColumnUsage) {
                    retval.setIcon(OracleIcons.getIcon((String)"column.png"));
                } else {
                    retval.setIcon(OracleIcons.getIcon((String)"plsql_function.png"));
                }
            } else if (obj instanceof DBObject) {
                Schema schema;
                String name = ((DBObject)obj).getName();
                type = ((DBObject)obj).getType();
                if ("PACKAGE BODY".equals(type) || "TYPE BODY".equals(type)) {
                    name = UIBundle.format("BODY_FORMAT", name);
                }
                if (this.m_showSchema && obj instanceof SchemaObject && (schema = ((SchemaObject)obj).getSchema()) != null) {
                    name = schema.getName() + "." + name;
                }
                retval.setText(name);
                DBObjectRenderer.setToolTipText(retval, DBUtil.getFullyQualifiedName((DBObject)((DBObject)obj)));
                if (obj instanceof FKConstraint) {
                    retval.setIcon(OracleIcons.getIcon((String)"foreignkey.png"));
                } else if (obj instanceof CheckConstraint) {
                    retval.setIcon(OracleIcons.getIcon((String)"constraint.png"));
                } else if (obj instanceof PKConstraint) {
                    retval.setIcon(OracleIcons.getIcon((String)"primarykey.png"));
                } else if (obj instanceof UniqueConstraint) {
                    retval.setIcon(OracleIcons.getIcon((String)"key.png"));
                } else {
                    type = ((DBObject)obj).getType();
                }
            } else if (obj instanceof String && this.m_iconify && !leaf) {
                Icon icon2 = DBTypeDisplayRegistry.getFolderIcon((String)obj);
                if (icon2 == null) {
                    retval.setIcon(OracleIcons.getIcon((String)"folder.png"));
                } else {
                    retval.setIcon(icon2);
                }
            }
        }
        if (this.m_iconify && type != null && (icon = DBTypeDisplayRegistry.getNodeIcon(type)) != null) {
            retval.setIcon(icon);
        }
        return retval;
    }

    public void setShowSchema(boolean showSchema) {
        this.m_showSchema = showSchema;
    }

    private void setupAliasFragmentLabel(JLabel label, AliasFragment fo) {
        String alias = fo.getAlias();
        SQLFragment exp = fo.getExpression();
        String text = null;
        if (exp != null) {
            text = exp.getSQLText();
        }
        FastStringBuffer buff = new FastStringBuffer();
        if (ModelUtil.hasLength((String)alias)) {
            buff.append(alias);
            buff.append(" (");
            buff.append(text);
            buff.append(")");
        } else if (ModelUtil.hasLength((String)text)) {
            buff.append(text);
        } else {
            buff.append(EMPTY);
        }
        label.setText(buff.toString());
        this.setupIcon(label, exp);
    }

    private void setupIcon(JLabel label, SQLFragment exp) {
        DBObjectID id;
        if (this.m_iconify && exp instanceof DBObjectUsage && (id = ((DBObjectUsage)exp).getObjectID()) != null) {
            String type = id.getType();
            label.setIcon(DBTypeDisplayRegistry.getNodeIcon(type));
        }
    }

    public static void setToolTipText(JComponent widget, String text) {
        widget.setToolTipText(text);
        AccessibleContext actx = widget.getAccessibleContext();
        if (actx != null) {
            actx.setAccessibleDescription(text);
        }
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(DBObject obj, boolean showChildren) {
        return DBObjectRenderer.createTreeNode(obj, showChildren, null);
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(DBObject obj, boolean showChildren, String[] includeChildTypes) {
        TreeNodeMaker tnm = new TreeNodeMaker(true, includeChildTypes);
        return tnm.createTreeNode(obj);
    }

    @Deprecated
    public static DefaultMutableTreeNode createTreeNode(SQLFragment obj, boolean showChildren) {
        TreeNodeMaker tnm = new TreeNodeMaker(true);
        return tnm.createTreeNode(obj);
    }
}

