/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.sql.tester.SQLQueryTester;
import oracle.ide.db.panels.sql.tester.TestSQLPanel;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.Database;

class TesterPanel
extends JPanel {
    private final DBObjectProviderPicker m_picker;
    private final DBObjectProviderPicker.PickerListener m_pickerListener = providerID -> this.pickerProviderChanged(providerID);
    private final JTextArea m_txtSQL = new JTextArea();
    private final JSplitPane m_pane;
    private final JTabbedPane m_tabPane = new JTabbedPane();
    private final ChangeListener m_changeListener = e -> this.panelChanged();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("TesterPanel");
    private final List<TesterComponent> m_queryComps = new ArrayList<TesterComponent>();
    private Database m_db;
    private boolean m_pickerShown;
    private String m_queryTxt;
    private Map<String, Object> m_bindVariables;
    private SQLQueryTester.Result m_result;
    private boolean m_listen;

    TesterPanel(SQLQueryTester tester) {
        this.setLayout(new GridBagLayout());
        HelpUtils.setHelpID((JComponent)this, (String)"f1_odbsqltester_html");
        this.m_reshelp.setName(this.m_tabPane, "TesterTabPane");
        this.addPanel(new TestSQLPanel(this.m_txtSQL, this));
        this.m_txtSQL.setFont(Font.decode("Monospaced"));
        this.m_pane = new JSplitPane(0, TesterPanel.newChildPanel(this.m_txtSQL, UIBundle.get("TESTSQL_SQL_LABEL"), "SQL", this.m_reshelp, this), this.m_tabPane);
        this.m_reshelp.setName(this.m_pane, "Split");
        this.m_pane.setResizeWeight(0.5);
        DBObjectProviderPicker.PickerConfiguration config = new DBObjectProviderPicker.PickerConfiguration();
        config.setContext(tester.getContext());
        config.setAllowNull(false);
        config.setProviderTypes("db");
        DBUILayoutHelper layout = new DBUILayoutHelper(this);
        this.m_picker = DBObjectProviderPicker.getPicker(config);
        if (this.m_picker != null) {
            this.m_pickerShown = true;
            layout.add(this.m_picker.getComponent(), 1, 1, true, false);
            layout.nextRow();
        }
        layout.add(this.m_pane);
        layout.layout();
    }

    void setShowConnectionPicker(boolean showPicker) {
        if (this.m_picker != null) {
            this.m_picker.getComponent().setVisible(showPicker);
            this.m_pickerShown = showPicker;
        }
    }

    private Database getChosenDatabase() {
        Database retval = null;
        try {
            retval = (Database)this.m_picker.getProvider();
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog(null, null, dbe);
        }
        return retval;
    }

    Component getDefaultFocusComponent() {
        return this.m_txtSQL;
    }

    void setBindVariables(Map<String, Object> bindVariables) {
        this.m_bindVariables = bindVariables;
        for (TesterComponent component : this.m_queryComps) {
            component.setBindVariables(bindVariables);
        }
    }

    SQLQueryTester.Result getResult() {
        return this.m_result;
    }

    void setResult(boolean result, String message, Integer offset) {
        this.m_result = new SQLQueryTester.Result(this.m_queryTxt, result, message, offset);
    }

    void addPanel(TesterComponent component) {
        this.m_queryComps.add(component);
        this.m_tabPane.add(component.getName(), component.getComponent());
        component.setBindVariables(this.m_bindVariables);
    }

    void testSQL(Database db, String text) {
        this.m_listen = true;
        this.m_queryTxt = text;
        if (this.m_picker != null) {
            this.m_picker.removePickerListener(this.m_pickerListener);
        }
        if (this.m_pickerShown && db != null && db.getConnectionStore() != null) {
            this.m_picker.setProvider((DBObjectProvider)db);
            this.m_db = this.getChosenDatabase();
        } else {
            this.m_db = db;
        }
        if (this.m_tabPane.getSelectedIndex() != 0) {
            this.m_tabPane.setSelectedIndex(0);
        } else {
            this.panelChanged();
        }
        this.m_tabPane.addChangeListener(this.m_changeListener);
        if (this.m_pickerShown) {
            this.m_picker.addPickerListener(this.m_pickerListener);
        }
    }

    private void pickerProviderChanged(DBObjectProviderID providerID) {
        if (this.m_pickerShown) {
            this.m_db = this.getChosenDatabase();
            if (this.m_tabPane.getSelectedIndex() > 0) {
                this.m_tabPane.setSelectedIndex(0);
            } else {
                this.panelChanged();
            }
        }
    }

    private void panelChanged() {
        if (this.m_listen) {
            int i = this.m_tabPane.getSelectedIndex();
            if (this.m_db == null) {
                this.enableTabs(false);
                if (i != 0) {
                    try {
                        this.m_listen = false;
                        this.m_tabPane.setSelectedIndex(0);
                    }
                    finally {
                        this.m_listen = true;
                    }
                }
            } else {
                this.enableTabs(true);
                this.m_queryComps.get(i).testSQL(this.m_db, this.m_queryTxt);
            }
        }
    }

    void enableTabs(boolean boo) {
        for (int i = 1; i < this.m_tabPane.getTabCount(); ++i) {
            this.m_tabPane.setEnabledAt(i, boo);
        }
    }

    void close() {
        this.m_tabPane.removeChangeListener(this.m_changeListener);
        for (TesterComponent comp : this.m_queryComps) {
            try {
                comp.close();
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, comp.getClass().getSimpleName(), e);
            }
        }
        this.m_db = null;
    }

    static JPanel newChildPanel(JTextArea txtArea, String labelTxt, String compName, DBUIResourceHelper reshelp, Component parent) {
        JLabel label = new JLabel();
        reshelp.resLabel(label, txtArea, labelTxt, compName);
        txtArea.setEditable(false);
        txtArea.setBackground(parent.getBackground());
        JScrollPane scroll = new JScrollPane(txtArea);
        reshelp.setName(scroll, compName + "Scroll");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        panel.add((Component)label, "North");
        panel.add((Component)scroll, "Center");
        return panel;
    }
}

