/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.Step;
import oracle.ideimpl.db.panels.sql.FromObjectsPanel;
import oracle.ideimpl.db.panels.sql.GroupByPanel;
import oracle.ideimpl.db.panels.sql.HavingPanel;
import oracle.ideimpl.db.panels.sql.HierarchicalQueryPanel;
import oracle.ideimpl.db.panels.sql.OrderByPanel;
import oracle.ideimpl.db.panels.sql.QueryPanel;
import oracle.ideimpl.db.panels.sql.QuickPickObjectsPanel;
import oracle.ideimpl.db.panels.sql.SelectObjectsPanel;
import oracle.ideimpl.db.panels.sql.WhereObjectPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.WhereObject;

public final class SQLQueryEditDialog
implements Comparator {
    public static final String HELP_PICKER = "f1_odbviobjpick_html";
    public static final String HELP_SELECT_INFO = "f1_odbviselect_html";
    public static final String HELP_FROM_INFO = "f1_odbvifrom_html";
    public static final String HELP_WHERE_INFO = "f1_odbviwhere_html";
    public static final String HELP_GROUPBY_INFO = "f1_odbvigroup_html";
    public static final String HELP_HAVING_INFO = "f1_odbvihaving_html";
    public static final String HELP_ORDERBY_INFO = "f1_odbviorderby_html";
    public static final String HELP_CONNECTBY_INFO = "f1_odbvconnectby_html";
    public static final String HELP_QUERY_INFO = "f1_odbvisql_html";
    private static final String[] QUERY_HELP_IDS = new String[]{"f1_odbviobjpick_html", "f1_odbvifrom_html", "f1_odbviselect_html", "f1_odbviwhere_html", "f1_odbvigroup_html", "f1_odbvihaving_html", "f1_odbvconnectby_html", "f1_odbviorderby_html", "f1_odbvisql_html"};
    private final List<Navigable> m_navs;
    private final boolean m_noOrderBy;
    private Step[] m_steps;
    private Collection<String> m_bindVars;

    public SQLQueryEditDialog() {
        this(false);
    }

    public SQLQueryEditDialog(boolean noOrderBy) {
        this.m_noOrderBy = noOrderBy;
        this.m_navs = new ArrayList<Navigable>();
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_PICKER"), QuickPickObjectsPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_FROM_INFO"), FromObjectsPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_SELECT_INFO"), SelectObjectsPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_WHERE_INFO"), WhereObjectPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_GROUPBY_INFO"), GroupByPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_HAVING_INFO"), HavingPanel.class));
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_HIER_QUERY_INFO"), HierarchicalQueryPanel.class));
        if (!this.m_noOrderBy) {
            this.m_navs.add(new Navigable(UIBundle.get("VIEW_ORDERBY_INFO"), OrderByPanel.class));
        }
        this.m_navs.add(new Navigable(UIBundle.get("VIEW_QUERY_INFO"), QueryPanel.class));
        this.setHelpIDs(this.m_navs);
    }

    public Navigable[] getNavigables() {
        return this.m_navs.toArray(new Navigable[this.m_navs.size()]);
    }

    private void setHelpIDs(List<Navigable> navs) {
        for (int i = 0; i < navs.size(); ++i) {
            navs.get(i).setHelpID(QUERY_HELP_IDS[i]);
        }
    }

    public void setBindVariables(Collection<String> bindVars) {
        this.m_bindVars = bindVars;
    }

    public Navigable getMasterNavigable() {
        Navigable master = new Navigable(UIBundle.get("QUERY_DISPLAY_INFO"), QueryPanel.class);
        master.setHelpID(HELP_QUERY_INFO);
        master.setChildComparator((Comparator)this);
        for (int i = 0; i < this.m_navs.size() - 1; ++i) {
            master.addChildNavigable(this.m_navs.get(i));
        }
        return master;
    }

    public Step[] getSteps() {
        if (this.m_steps == null) {
            this.m_steps = new Step[this.m_navs.size()];
            for (int i = 0; i < this.m_steps.length; ++i) {
                Navigable nav = this.m_navs.get(i);
                this.m_steps[i] = new Step(nav.getShortLabel(), nav.getTraversableClass(), QUERY_HELP_IDS[i++]);
            }
        }
        return this.m_steps;
    }

    public String editQuery(String sqlText, DBObjectProvider provider, Schema defaultSchema) {
        SQLQuery query = new SQLQuery(sqlText);
        this.editQueryImpl(query, null, provider, defaultSchema);
        return query.toString();
    }

    public SQLQuery editQuery(SQLQuery query, DBObjectProvider provider, Schema defaultSchema) {
        return this.editQuery(query, null, provider, defaultSchema);
    }

    public SQLQuery editQuery(SQLQuery query, SQLFragment defaultObject, DBObjectProvider provider, Schema defaultSchema) {
        return this.editQueryImpl(query, defaultObject, provider, defaultSchema);
    }

    public Namespace createNamespace(SQLQuery query, DBObjectProvider provider, Schema defaultSchema) {
        Namespace namespace = new Namespace();
        namespace.put("oracle.javatools.db.DBObjectProvider", (Object)provider);
        namespace.put("oracle.javatools.db.Schema", (Object)defaultSchema);
        namespace.put("NewObject", (Object)query);
        DBEditorConfig config = SQLQueryEditDialog.newDefaultEditorConfig(provider, query);
        config.setSchema(defaultSchema);
        namespace.put(DBEditorConfig.class.getName(), (Object)config);
        if (this.m_bindVars != null) {
            namespace.put("bindVariables", this.m_bindVars);
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLQuery editQueryImpl(SQLQuery query, SQLFragment defaultObject, DBObjectProvider provider, Schema defaultSchema) {
        String[] startPage;
        if (query == null) {
            return null;
        }
        SQLQuery copy = new SQLQuery();
        query.copyTo((Object)copy);
        Namespace namespace = this.createNamespace(copy, provider, defaultSchema);
        final MDDPanel panel = new MDDPanel(this.getMasterNavigable());
        panel.setName("SQLQueryEditDialog.MDD");
        Traversable t = new Traversable(){

            public Component getComponent() {
                return panel;
            }

            public Object getExitTransition() {
                return null;
            }

            public String getHelpID() {
                return null;
            }

            public void onExit(TraversableContext dataContext) throws TraversalException {
                panel.onExit(dataContext);
            }

            public void onEntry(TraversableContext dataContext) {
                panel.onEntry(dataContext);
                panel.expandTree1ToDepth(2);
            }
        };
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), UIBundle.get("EDIT_QUERY"), t, namespace);
        if (defaultObject != null && (startPage = SQLQueryEditDialog.getStartPage(defaultObject, false)) != null) {
            panel.setTree1SelectionPath(startPage);
        }
        launcher.initDialog().setName("SQLQueryEditDialog");
        String timestampKey = "SQLQueryEditDialog." + System.nanoTime();
        SQLQuery retval = null;
        try {
            DBUtil.suspendTimestampChecking((DBObjectProvider)provider, (String)timestampKey);
            if (launcher.showDialog()) {
                SQLQuery edited = (SQLQuery)((DBEditorConfig)namespace.get(DBEditorConfig.class)).getChildObject();
                edited.copyTo((Object)query);
                retval = query;
            }
        }
        finally {
            launcher.dispose();
            DBUtil.resumeTimestampChecking((DBObjectProvider)provider, (String)timestampKey);
        }
        return retval;
    }

    public int compare(Object o1, Object o2) {
        return 0;
    }

    public static final DBEditorConfig newDefaultEditorConfig(DBObjectProvider pro, SQLQuery query) {
        DBEditorConfig config = DBEditorConfig.newEmptyConfig(pro);
        config.setChildObject((DBObject)query);
        config.setSchema(DBUtil.getSchema((DBObject)query));
        return config;
    }

    public static final String[] getStartPage(SQLFragment child, boolean incMaster) {
        String page = null;
        if (child instanceof SelectObject) {
            page = UIBundle.get("VIEW_SELECT_INFO");
        } else if (child instanceof FromObject) {
            page = UIBundle.get("VIEW_FROM_INFO");
        } else if (child instanceof WhereObject) {
            page = UIBundle.get("VIEW_WHERE_INFO");
        } else if (child instanceof GroupByObject) {
            page = UIBundle.get("VIEW_GROUPBY_INFO");
        } else if (child instanceof OrderByObject) {
            page = UIBundle.get("VIEW_ORDERBY_INFO");
        } else if (child instanceof HierarchicalQueryObject) {
            page = UIBundle.get("VIEW_HIER_QUERY_INFO");
        }
        if (page != null) {
            if (incMaster) {
                return new String[]{UIBundle.get("QUERY_DISPLAY_INFO"), page};
            }
            return new String[]{page};
        }
        return null;
    }

    public static boolean isAvailable(DBObjectProvider pro) {
        DatabaseDescriptor dd = pro.getDescriptor();
        SQLQueryBuilderFactory f = dd.getSQLQueryBuilderFactory();
        return f != null;
    }
}

