/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.controls.NameAndSchemaEditor;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.DBTraversablePanel;
import oracle.ide.db.panels.DDLPanel;
import oracle.ide.db.panels.MDDEditorPanel;
import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.DBNavigable;
import oracle.ideimpl.db.panels.GeneralPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.db.validators.ValidationLevel;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public abstract class PanelLibrary<T extends DBObject> {
    @Deprecated
    public static final String KEY = PanelLibrary.class.getName();
    @Deprecated
    public static final String COMMIT_TO_PROVIDER_KEY = "COMMIT_TO_PROVIDER_KEY";
    private final String m_type;
    private final Map<String, String> m_helpIDs;
    private final Panels m_panels;
    private boolean m_changingPanels;

    protected PanelLibrary(String type) {
        this(type, null);
    }

    protected PanelLibrary(String type, Map<String, String> helpIDs) {
        this.m_type = type;
        this.m_helpIDs = helpIDs;
        this.m_panels = new Panels();
    }

    private PanelLibrary(PanelLibrary delegate) {
        this.m_type = delegate.m_type;
        this.m_helpIDs = delegate.m_helpIDs;
        this.m_panels = delegate.m_panels;
    }

    protected Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    public String getType() {
        return this.m_type;
    }

    public final void setDefaultPanels(Navigable[] navs) {
        this.setDefaultPanels(navs, false);
    }

    public final void setDefaultPanels(Navigable[] navs, boolean alwaysAddDefaultPanels) {
        Panels.access$102(this.m_panels, navs);
        this.m_panels.m_alwaysAddDefaultPanels = alwaysAddDefaultPanels;
    }

    public Navigable[] getDefaultPanels(boolean edit) {
        Navigable[] retval;
        Navigable[] navigableArray = retval = this.m_panels.m_defaultPanels == null ? null : new Navigable[this.m_panels.m_defaultPanels.length];
        if (retval != null) {
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = (Navigable)this.m_panels.m_defaultPanels[i].copyTo(null);
            }
        }
        return retval;
    }

    protected final void addDefaultPanels(List<Navigable> navs, boolean edit) {
        Navigable[] defPanels;
        if (navs != null && (navs.size() > 0 || this.m_panels.m_alwaysAddDefaultPanels) && (defPanels = this.getDefaultPanels(edit)) != null) {
            for (int i = 0; i < defPanels.length; ++i) {
                Navigable navCopy = (Navigable)defPanels[i].copyTo(null);
                navs.add(navCopy);
            }
        }
    }

    protected Class<? extends Traversable> getHeader() {
        if (this.getSimpleTitles() != null) {
            return NameAndSchemaAdvancedEditor.class;
        }
        return NameAndSchemaEditor.class;
    }

    protected String getHeaderHelpID() {
        return this.getGeneralHelpID();
    }

    protected String getGeneralHelpID() {
        return null;
    }

    public final Navigable getGeneralNavigable(DBEditorConfig editorConfig) {
        DBNavigable retval = null;
        Traversable header = this.createHeader();
        if (header != null) {
            Collection<String> titles = this.getGeneralTitles();
            List<Navigable> generalNavs = this.getNavigables(titles, (DBObject)editorConfig.getUpdatedObject(), editorConfig.getProvider(), true, false, true);
            retval = new DBNavigable(UIBundle.get("GENERAL"), GeneralPanel.class, new Class[]{Traversable.class, List.class}, new Object[]{header, generalNavs});
            HashSet<String> allProps = new HashSet<String>();
            for (String title : titles) {
                Collection props = (Collection)this.m_panels.m_properties.get(title);
                if (props == null) continue;
                allProps.addAll(props);
            }
            retval.setProperties(allProps);
            retval.setHelpID(this.getGeneralHelpID());
        }
        return retval;
    }

    public Collection<String> getGeneralTitles() {
        String title = null;
        Map<String, Navigable> navs = this.getNavigables();
        if (navs.size() == 1) {
            title = navs.keySet().iterator().next();
        } else {
            String[] possibles;
            for (String possible : possibles = new String[]{UIBundle.get("COMMENT"), UIBundle.get("PROPERTIES")}) {
                if (!navs.containsKey(possible)) continue;
                title = possible;
                break;
            }
        }
        return title == null ? Collections.emptyList() : Collections.singleton(title);
    }

    public boolean getSkipGeneralForNewObject() {
        Collection<String> generalTitles = this.getGeneralTitles();
        return generalTitles == null || generalTitles.size() == 1 && ModelUtil.areEqual((Object)UIBundle.get("COMMENT"), (Object)generalTitles.iterator().next());
    }

    protected Class<? extends Traversable> getDDLPanel() {
        return DDLPanel.class;
    }

    public Navigable getDDLNavigable() {
        DBNavigable retval = null;
        Class<Traversable> panelClz = this.getDDLPanel();
        if (panelClz != null) {
            retval = new DBNavigable(UIBundle.get("DDL_TITLE"), panelClz);
            retval.setHelpID("f1_odbddl_html");
        }
        return retval;
    }

    public Component getInitialFocus(Traversable mainPanel) {
        if (mainPanel instanceof DBTraversablePanel) {
            return ((DBTraversablePanel)mainPanel).getDefaultFocusComponent();
        }
        return null;
    }

    public final Traversable getMainDialogPanel(DBEditorConfig config, Navigable[] navs) {
        String startPage = this.getStartPage(config);
        Traversable header = this.createHeader();
        return this.createMainPanel(header, navs, startPage);
    }

    @Deprecated
    public final Traversable getMainDialogPanel(T obj, DBObjectProvider pro, DBObject child, Navigable[] navs) {
        String startPage = this.getStartPage(child);
        Traversable header = this.createHeader();
        return this.createMainPanel(header, navs, startPage);
    }

    private Traversable createHeader() {
        Traversable header = null;
        try {
            Class<Traversable> headerClass = this.getHeader();
            if (headerClass != null) {
                header = headerClass.newInstance();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, this.getType(), e);
        }
        return header;
    }

    public boolean prepareEditorInBackground(DBEditorConfig config) {
        return config.getProvider() instanceof Database;
    }

    public void prepareObjectForEditor(DBEditorConfig config, List<Navigable> navs) throws DBException {
        if (config.isEdit() || TemplateExpander.isPendingObject((DBObject)config.getUpdatedObject())) {
            String startPage = this.getStartPage(config);
            Navigable startNav = null;
            if (startPage != null) {
                startNav = this.getNavigables().get(startPage);
            }
            if (startNav == null && navs != null && navs.size() > 0) {
                startNav = navs.get(0);
            }
            if (startNav != null) {
                this.prepareObjectForNavigable(config, startNav);
            }
        }
    }

    protected void prepareObjectForNavigable(DBEditorConfig config, Navigable nav) throws DBException {
        Collection props = (Collection)this.m_panels.m_properties.get(nav.getShortLabel());
        if (props != null && !props.isEmpty()) {
            SystemObject obj = config.getUpdatedObject();
            this.getLogger().fine("Preparing " + obj.getName() + " building: " + props);
            DBUtil.ensureObjectBuilt((DBObject)obj, (String[])props.toArray(new String[props.size()]));
        }
    }

    protected Traversable createMainPanel(Traversable header, Navigable[] navs, String startPage) {
        List<Navigable> simples = this.getSimpleNavigables();
        int simpleSize = simples == null ? 0 : simples.size();
        TabbedEditorPanel retval = simpleSize > 0 ? new MDDEditorPanel(header, navs, startPage, simpleSize) : new TabbedEditorPanel(header, navs, startPage);
        retval.setHelpID(this.getHeaderHelpID());
        return retval;
    }

    protected boolean includePanelHeaders(DBEditorConfig editorConfig) {
        return editorConfig.getEditorType() == DBEditorFactory.EditorType.EDIT_FLAT;
    }

    public final List<Navigable> getNavigables(DBEditorConfig editorConfig) {
        DBObject obj = editorConfig.isChildEditOnly() ? editorConfig.getChildObject() : editorConfig.getUpdatedObject();
        DBObjectProvider pro = editorConfig.getProvider();
        boolean edit = editorConfig.isEdit();
        DBEditorFactory.EditorType editorType = editorConfig.getEditorType();
        boolean general = editorType == DBEditorFactory.EditorType.EDIT_FLAT;
        List<String> titles = this.getTitles(obj, pro, edit);
        if (general && titles != null) {
            titles = new ArrayList<String>(titles);
            titles.removeAll(this.getGeneralTitles());
        }
        List<Navigable> navs = this.getNavigables(titles, obj, pro, edit, this.includePanelHeaders(editorConfig), false);
        if (general) {
            if (navs == null) {
                navs = new ArrayList<Navigable>();
            }
            navs.add(0, this.getGeneralNavigable(editorConfig));
        }
        if (navs != null) {
            Navigable ddlNav;
            if (!editorConfig.isChildEditOnly()) {
                this.addDefaultPanels(navs, edit);
            }
            if ((editorType == DBEditorFactory.EditorType.CREATE_MODAL || editorType == DBEditorFactory.EditorType.EDIT_MODAL) && (ddlNav = this.getDDLNavigable()) != null) {
                navs.add(ddlNav);
            }
        }
        return navs;
    }

    @Deprecated
    public final List<Navigable> getCreateNavigables(T obj, DBObjectProvider pro) {
        List<Navigable> navs = this.getNavigables((Collection<String>)this.getTitles(obj, pro, false), (DBObject)obj, pro, false, false, false);
        if (navs != null) {
            this.addDefaultPanels(navs, false);
        }
        return navs;
    }

    @Deprecated
    public final Map<String, Class> getCreateVerifiers() {
        return this.getVerifiers(false);
    }

    public boolean canEditObject(T obj, DBObjectProvider pro) {
        String type;
        boolean retval = false;
        if (obj != null && (type = obj.getType()).equals(this.getType())) {
            retval = !(pro instanceof Database) || pro.isEditable(obj);
        }
        return retval;
    }

    @Deprecated
    public final List<Navigable> getEditNavigables(T obj, DBObjectProvider pro) {
        List<Navigable> navs = this.getNavigables((Collection<String>)this.getTitles(obj, pro, true), (DBObject)obj, pro, true, false, false);
        if (navs != null && obj instanceof SystemObject) {
            this.addDefaultPanels(navs, true);
        }
        return navs;
    }

    @Deprecated
    public final Map<String, Class> getEditVerifiers() {
        return this.getVerifiers(true);
    }

    public final List<Navigable> getSimpleNavigables() {
        List<Navigable> retval = null;
        List<String> titles = this.getSimpleTitles();
        if (titles != null) {
            retval = this.getNavigables(titles, null, null, false, false, false);
            Navigable ddlNav = this.getDDLNavigable();
            if (ddlNav != null) {
                retval.add(ddlNav);
            }
        }
        return retval;
    }

    public final T getObjectForCreate(Schema schema, DBObjectProvider pro, DBObject parent) {
        T retval = this.newDBObject(pro, schema, parent);
        this.makeNameUnique((DBObject)retval, schema, pro, parent);
        retval.setID(TemporaryObjectID.createID(retval));
        return retval;
    }

    public final void makeNameUnique(DBObject dbo, Schema schema, DBObjectProvider pro, DBObject parent) {
        Tuple baseSplit;
        Integer topFromPro;
        String name = dbo.getName();
        Object nameContext = dbo instanceof SchemaObject ? schema : parent;
        Set<String> existingNames = this.getNamesToExclude(pro, (DBObject)nameContext);
        if (existingNames != null && existingNames.contains(name) && (topFromPro = (Integer)(baseSplit = DBUtil.splitBaseName((String)name)).getSecond()) != null) {
            String base = (String)baseSplit.getFirst();
            int highest = topFromPro;
            for (String existing : existingNames) {
                Integer existingNum;
                Tuple existingBase = DBUtil.splitBaseName((String)existing);
                if (!ModelUtil.areEqual((Object)base, (Object)existingBase.getFirst()) || (existingNum = (Integer)existingBase.getSecond()) == null || existingNum <= highest) continue;
                highest = existingNum;
            }
            String newBase = base + (highest + 1);
            name = pro.getUniqueName(this.m_type, (DBObject)nameContext, newBase);
            dbo.setName(name);
        }
        if (dbo instanceof SchemaObject) {
            ((SchemaObject)dbo).setSchema(schema);
        }
    }

    protected Set<String> getNamesToExclude(DBObjectProvider pro, DBObject contextObject) {
        return null;
    }

    public void commitToProvider(DBEditorConfig config) {
        config.setException(null);
        config.setResult(DBEditorConfig.Result.IN_PROGRESS);
        ProviderOperator op = new ProviderOperator(config.getProvider());
        op.updateObjects(config);
    }

    public boolean showEditorAfterCommit() {
        return false;
    }

    @Deprecated
    protected String getUniqueName(String type) {
        String base = type;
        if (base.indexOf(" ") >= 0) {
            StringBuilder buff = new StringBuilder();
            StringTokenizer tok = new StringTokenizer(base, " ");
            while (tok.hasMoreElements()) {
                String next = tok.nextToken();
                if (tok.hasMoreElements()) {
                    buff.append(next.substring(0, 1));
                    continue;
                }
                buff.append(next);
            }
            base = buff.toString();
        }
        return base + 1;
    }

    public String getStartPage(DBEditorConfig config) {
        String retval = null;
        if (config != null && (retval = config.getStartPage()) == null) {
            String propToEdit = null;
            DBObject child = config.getChildObject();
            if (child == null) {
                propToEdit = config.getProperty();
            } else {
                propToEdit = DBUtil.getPropertyPath((DBObject)config.getUpdatedObject(), (DBObject)child);
                if (propToEdit == null) {
                    this.getLogger().warning("Given child does not exist in the object we are editing.");
                }
            }
            if (propToEdit != null) {
                block0: for (Map.Entry entry : this.m_panels.m_properties.entrySet()) {
                    for (String panelProp : (Collection)entry.getValue()) {
                        if (!propToEdit.startsWith(panelProp)) continue;
                        retval = (String)entry.getKey();
                        break block0;
                    }
                }
            }
            if (retval != null) {
                config.setStartPage(retval);
            }
        }
        return retval;
    }

    @Deprecated
    public String getStartPage(DBObject child) {
        return null;
    }

    protected T newDBObject(DBObjectProvider pro, Schema schema, DBObject parent) {
        DBObject retval;
        Class clz = Metadata.getInstance().getObjectClass(this.m_type);
        if (SchemaObject.class.isAssignableFrom(clz)) {
            retval = pro.getObjectFactory().newObject(clz, (DBObject)schema);
            if (retval instanceof SchemaObject && parent instanceof SchemaObject) {
                this.setContextObject((SchemaObject)retval, (SchemaObject)parent);
            }
        } else {
            retval = pro.getObjectFactory().newObject(clz, parent);
        }
        return (T)retval;
    }

    protected void setContextObject(SchemaObject newObject, SchemaObject contextObject) {
        if (newObject instanceof ChildDBObject) {
            ((ChildDBObject)newObject).setParent((DBObject)contextObject);
        }
    }

    protected abstract List<String> getTitles(T var1, DBObjectProvider var2, boolean var3);

    @Deprecated
    protected void addSupportedTitle(SystemObject obj, DBObjectProvider pro, String propPath, Collection<String> titles, String title) {
    }

    @Deprecated
    protected void addSupportedTitle(SystemObject obj, DBObjectProvider pro, String[] propPaths, Collection<String> titles, String title) {
    }

    @Deprecated
    protected Map<String, Class> getVerifiers(boolean editing) {
        return Collections.emptyMap();
    }

    protected List<String> getSimpleTitles() {
        return null;
    }

    private final List<Navigable> getNavigables(Collection<String> titles, DBObject obj, DBObjectProvider pro, boolean edit, boolean incHeaders, boolean general) {
        if (titles == null) {
            return null;
        }
        Navigable[] defPanels = this.getDefaultPanels(edit);
        ArrayList<Navigable> retval = new ArrayList<Navigable>();
        for (String title : titles) {
            Navigable panel = this.getNavigables().get(title);
            if (panel == null && defPanels != null) {
                for (int i = 0; i < defPanels.length; ++i) {
                    if (!title.equals(defPanels[i].getShortLabel())) continue;
                    panel = defPanels[i];
                    break;
                }
            }
            if (panel == null) {
                this.getLogger().warning("no such editor panel " + title);
                continue;
            }
            boolean add = true;
            Collection props = (Collection)this.m_panels.m_properties.get(title);
            if (pro != null && obj instanceof SystemObject && props != null && !props.isEmpty()) {
                add = general;
                if (!general) {
                    PropertyManager pm = pro.getPropertyManager();
                    for (String prop : props) {
                        if (!pm.canCreateProperty((SystemObject)obj, prop)) continue;
                        add = true;
                        break;
                    }
                }
            }
            if (!add) continue;
            DBNavigable newPanel = new DBNavigable(panel, incHeaders);
            newPanel.setProperties(props);
            if (this.m_helpIDs != null && this.m_helpIDs.containsKey(title)) {
                newPanel.setHelpID(this.m_helpIDs.get(title));
            }
            retval.add(newPanel);
        }
        return retval;
    }

    protected final Navigable addPanel(String title, Class<? extends Traversable> clz, String helpID, String ... properties) {
        return this.addPanel(title, clz, helpID, (Class[])null, (Object[])null, properties);
    }

    protected final Navigable addPanel(String title, Class<? extends Traversable> clz, String helpID, Class[] constructorSig, Object[] constructorArgs, String ... properties) {
        Navigable n = new Navigable(title, clz, constructorSig, constructorArgs, null);
        n.setHelpID(helpID);
        this.addNavigable(title, n, properties);
        return n;
    }

    protected final void addNavigable(String title, Navigable n, String ... properties) {
        this.getNavigables().put(title, n);
        if (properties != null) {
            this.m_panels.m_properties.put(title, Arrays.asList(properties));
        }
    }

    protected Map<String, Navigable> getNavigables() {
        return this.m_panels.m_panels;
    }

    public Dimension getSize(boolean edit) {
        return null;
    }

    public String getCreateText() {
        return DBTypeDisplayRegistry.getNewMenuItemText(this.getType());
    }

    public String getCreateTitle() {
        return DBTypeDisplayRegistry.getDialogTitle(this.getType(), false, false);
    }

    public String getEditTitle() {
        return DBTypeDisplayRegistry.getDialogTitle(this.getType(), true, false);
    }

    public String getErrorTitle(boolean edit) {
        return DBTypeDisplayRegistry.getDialogTitle(this.getType(), edit, true);
    }

    public boolean canReplaceByDefault() {
        return false;
    }

    public boolean shouldResetObjectBeforeEdit(DBEditorConfig config) {
        boolean retval = false;
        DBObjectProvider pro = config.getProvider();
        String type = this.getType();
        if (Metadata.getInstance().isTypeOf(SystemObject.class, type) && pro instanceof AbstractDatabase) {
            retval = !((AbstractDatabase)pro).supportsTimestamps(type);
        }
        return retval;
    }

    public boolean shouldValidateOnExit(BaseEditorPanel panel, Namespace dataContext) {
        return !this.m_changingPanels && !Boolean.getBoolean("ide.db.skipValidation");
    }

    public ValidationLevel getValidationLevel(DBEditorConfig config) {
        ValidationLevel retval = config.getProvider() instanceof Database && !Boolean.getBoolean("ide.db.forceFullValidation") ? ValidationLevel.SIMPLE : ValidationLevel.FULL;
        return retval;
    }

    public boolean checkPrivilege(T newObj, DBObjectProvider pro, boolean edit) {
        return true;
    }

    public static void ensurePanels(Namespace dataContext, PanelSetChangeValidator validator) throws TraversalException {
        PanelLibrary lib = (PanelLibrary)dataContext.find(PanelLibrary.class);
        PanelSetChanger changer = (PanelSetChanger)dataContext.find(PanelSetChanger.class);
        if (lib != null && changer != null) {
            List<Navigable> navs = lib.getNavigables((DBEditorConfig)dataContext.find(DBEditorConfig.class));
            PanelLibrary.ensurePanelsImpl(navs, lib, changer, validator);
        }
    }

    public static void ensureSimplePanels(Namespace dataContext, PanelSetChangeValidator validator) throws TraversalException {
        PanelLibrary lib = (PanelLibrary)dataContext.find(PanelLibrary.class);
        PanelSetChanger changer = (PanelSetChanger)dataContext.find(PanelSetChanger.class);
        if (lib != null && changer != null) {
            PanelLibrary.ensurePanelsImpl(lib.getSimpleNavigables(), lib, changer, validator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensurePanelsImpl(List<Navigable> navs, PanelLibrary lib, PanelSetChanger changer, PanelSetChangeValidator validator) throws TraversalException {
        lib.m_changingPanels = true;
        try {
            changer.panelSetChange(navs.toArray(new Navigable[navs.size()]), validator);
        }
        finally {
            lib.m_changingPanels = false;
        }
    }

    private static final class Panels {
        private final Map<String, Navigable> m_panels = new HashMap<String, Navigable>();
        private final Map<String, Collection<String>> m_properties = new LinkedHashMap<String, Collection<String>>();
        private Navigable[] m_defaultPanels;
        private boolean m_alwaysAddDefaultPanels;

        private Panels() {
        }

        static /* synthetic */ Navigable[] access$102(Panels x0, Navigable[] x1) {
            x0.m_defaultPanels = x1;
            return x1;
        }
    }

    public static class DelegatePanelLibrary<T extends DBObject>
    extends PanelLibrary<T> {
        private final PanelLibrary<T> m_delegate;

        public DelegatePanelLibrary(PanelLibrary<T> delegate) {
            super(delegate);
            this.m_delegate = delegate;
        }

        @Override
        protected List<String> getTitles(T obj, DBObjectProvider pro, boolean editing) {
            return this.m_delegate.getTitles(obj, pro, editing);
        }

        @Override
        protected Traversable createMainPanel(Traversable header, Navigable[] navs, String startPage) {
            return this.m_delegate.createMainPanel(header, navs, startPage);
        }

        @Override
        protected Class<? extends Traversable> getHeader() {
            return this.m_delegate.getHeader();
        }

        @Override
        protected List<String> getSimpleTitles() {
            return this.m_delegate.getSimpleTitles();
        }

        @Override
        public Dimension getSize(boolean edit) {
            return this.m_delegate.getSize(edit);
        }

        @Override
        public boolean showEditorAfterCommit() {
            return this.m_delegate.showEditorAfterCommit();
        }

        @Override
        public void commitToProvider(DBEditorConfig config) {
            this.m_delegate.commitToProvider(config);
        }

        @Override
        public String getStartPage(DBEditorConfig config) {
            return this.m_delegate.getStartPage(config);
        }

        @Override
        protected Map<String, Class> getVerifiers(boolean editing) {
            return this.m_delegate.getVerifiers(editing);
        }

        @Override
        protected T newDBObject(DBObjectProvider pro, Schema schema, DBObject parent) {
            return this.m_delegate.newDBObject(pro, schema, parent);
        }

        @Override
        protected String getGeneralHelpID() {
            return this.m_delegate.getGeneralHelpID();
        }

        @Override
        public Collection<String> getGeneralTitles() {
            return this.m_delegate.getGeneralTitles();
        }

        @Override
        protected Class<? extends Traversable> getDDLPanel() {
            return this.m_delegate.getDDLPanel();
        }

        @Override
        public boolean prepareEditorInBackground(DBEditorConfig config) {
            return this.m_delegate.prepareEditorInBackground(config);
        }

        @Override
        public void prepareObjectForEditor(DBEditorConfig config, List<Navigable> navs) throws DBException {
            this.m_delegate.prepareObjectForEditor(config, navs);
        }

        @Override
        protected void prepareObjectForNavigable(DBEditorConfig config, Navigable nav) throws DBException {
            this.m_delegate.prepareObjectForNavigable(config, nav);
        }
    }

    @Deprecated
    public static interface HeaderPanel {
        public static final String HEADER_PANEL_KEY = HeaderPanel.class.getName();
        public static final String DEFAULT_PANEL_KEY = "DEFAULT_PANEL";

        public void addHeaderPanelListener(HeaderPanelListener var1);

        public boolean removeHeaderPanelListener(HeaderPanelListener var1);

        public void validatePanelChange(TraversableContext var1) throws TraversalException;
    }

    @Deprecated
    public static interface HeaderPanelListener {
        public void panelSetChange(String var1, Navigable[] var2) throws TraversalException;
    }

    @FunctionalInterface
    public static interface PanelSetChangeValidator {
        public void validatePanelChange(TraversableContext var1) throws TraversalException;
    }

    @FunctionalInterface
    public static interface PanelSetChanger {
        public void panelSetChange(Navigable[] var1, PanelSetChangeValidator var2) throws TraversalException;
    }
}

