/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.execute;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.DBObjectNode;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.util.IdentitySet;
import oracle.javatools.util.ModelUtil;
import org.openide.util.RequestProcessor;

public final class DBRequestProcessor {
    private final Lock m_scheduleLock = new ReentrantLock();
    private final Map<String, DBTimerTask> m_schedule = new HashMap<String, DBTimerTask>();
    private final Collection<DBRunnable> m_executing = new IdentitySet();
    private final ExecutorService m_executor;
    private final boolean m_privateExecutor;
    private final DBObjectNode m_node;

    DBRequestProcessor(ExecutorService executor, DBObjectNode node) {
        this.m_node = node;
        this.m_privateExecutor = executor == null;
        this.m_executor = this.m_privateExecutor ? new RequestProcessor(this.getThreadName("_Processor"), 1, true) : executor;
    }

    private String getThreadName(String name) {
        StringBuilder retval = new StringBuilder();
        retval.append(this.getClass().getSimpleName()).append("_").append(this.m_node.getShortLabel()).append("#").append(System.identityHashCode(this)).append(name);
        return retval.toString();
    }

    private Logger getLogger() {
        return DBLog.getLogger((Object)this);
    }

    private void logRequest(String msg) {
        this.getLogger().fine(this.m_node.getShortLabel() + ": " + msg);
    }

    void shutdown() {
        this.logRequest("Shutting down processor");
        if (this.m_privateExecutor) {
            this.m_executor.shutdownNow();
        }
    }

    public Future<?> execute(DBRunnable run) {
        this.m_scheduleLock.lock();
        try {
            Future<?> future = this.executeImpl(run);
            return future;
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    private Future<?> executeImpl(DBRunnable run) {
        Future<?> retval = null;
        if (!this.m_executor.isShutdown()) {
            this.logRequest("Executing " + run.getName());
            this.m_executing.add(run);
            retval = this.m_executor.submit(run);
        }
        return retval;
    }

    private String qualifySchedulerKey(String key) {
        return key + "_" + this.m_node.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(String key, DBRunnable run, int delay) {
        this.logRequest("Scheduling " + key + " with delay " + delay);
        String qualifiedKey = this.qualifySchedulerKey(key);
        DBTimerTask task = new DBTimerTask(qualifiedKey, run);
        this.m_scheduleLock.lock();
        try {
            TimerTask existing = this.m_schedule.put(qualifiedKey, task);
            if (existing != null) {
                existing.cancel();
            }
            DBRequestProcessorFactory.getInstance().getTimer().schedule((TimerTask)task, delay);
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String key) {
        this.logRequest("Cancelling " + key);
        this.m_scheduleLock.lock();
        try {
            String qualifiedKey = this.qualifySchedulerKey(key);
            TimerTask existing = this.m_schedule.remove(qualifiedKey);
            if (existing != null) {
                existing.cancel();
            }
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(DBRunnable run) {
        this.m_scheduleLock.lock();
        try {
            DBTimerTask existing;
            this.m_executing.remove(run);
            String key = run.m_scheduleKey;
            if (key != null && (existing = this.m_schedule.get(key)).m_run == run) {
                this.m_schedule.remove(key);
            }
            if (this.m_schedule.isEmpty() && this.m_executing.isEmpty()) {
                DBRequestProcessorFactory.getInstance().notifyProcessorEmpty(this.m_node, this);
            }
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    public abstract class DBRunnable
    implements Runnable {
        private final DBObjectProvider m_pro;
        private final String m_name;
        private String m_scheduleKey;
        private Future<?> m_future;

        public DBRunnable(DBObjectProvider pro, String name) {
            if (!ModelUtil.hasLength((String)name)) {
                throw new IllegalArgumentException("must specify a translated name");
            }
            this.m_pro = pro;
            this.m_name = name;
        }

        public final DBObjectProvider getProvider() {
            return this.m_pro;
        }

        public String getName() {
            return this.m_name;
        }

        protected Logger getLogger() {
            return DBLog.getLogger((Object)this);
        }

        protected abstract void doWork() throws DBException, InterruptedException;

        protected void cancelWork() {
        }

        @Override
        public final void run() {
            if (!(this.m_pro instanceof Database) || ((Database)this.m_pro).isConnectionAlive()) {
                try {
                    this.logProgress(" started.");
                    this.doWork();
                    this.logProgress(" completed successfully.");
                }
                catch (CancelledException ce) {
                    this.logProgress(" was cancelled.");
                }
                catch (DBException dbe) {
                    this.getLogger().warning(this.getName() + " : " + dbe.getMessage());
                }
                catch (InterruptedException ie) {
                    this.logProgress(" was interrupted.");
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Unexpected error executing task.", e);
                }
                finally {
                    this.logProgress(" finished.");
                    this.m_future = null;
                    DBRequestProcessor.this.finished(this);
                }
            }
        }

        private void cancel() {
            Future<?> future = this.m_future;
            if (future != null && future.cancel(true)) {
                this.cancelWork();
            }
        }

        private void logProgress(String msg) {
            this.getLogger().finest(this.getName() + msg);
        }
    }

    private class DBTimerTask
    extends TimerTask {
        private final String m_key;
        private final DBRunnable m_run;

        DBTimerTask(String key, DBRunnable run) {
            this.m_key = key;
            this.m_run = run;
        }

        @Override
        public void run() {
            DBRequestProcessor.this.m_scheduleLock.lock();
            try {
                TimerTask scheduled = (TimerTask)DBRequestProcessor.this.m_schedule.get(this.m_key);
                if (scheduled == this) {
                    this.m_run.m_scheduleKey = this.m_key;
                    this.m_run.m_future = DBRequestProcessor.this.executeImpl(this.m_run);
                }
            }
            catch (Exception e) {
                this.m_run.getLogger().log(Level.SEVERE, "task execution failed", e);
            }
            finally {
                DBRequestProcessor.this.m_scheduleLock.unlock();
            }
        }

        @Override
        public boolean cancel() {
            boolean retval = super.cancel();
            this.m_run.cancel();
            return retval;
        }
    }
}

