/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.javatools.util.ModelUtil;

public class PropertyDisplayListCellRenderer
extends DefaultListCellRenderer {
    public static final Object NULL_ENTRY = new Object(){

        public String toString() {
            return " ";
        }
    };
    public static final String NULL_VALUE = "null";
    private String m_propName;

    public PropertyDisplayListCellRenderer(String propName) {
        this.m_propName = propName;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        value = PropertyDisplayListCellRenderer.normalizeValue(this.m_propName, value);
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    public static Object normalizeValue(String propName, Object value) {
        if (value == NULL_ENTRY) {
            value = null;
        }
        Object retval = ModelUtil.hasLength((String)propName) ? PropertyDisplayRegistry.getPropValueDisplay(propName, value) : (value == null ? PropertyDisplayRegistry.getNullPropValueDisplay() : value);
        return retval;
    }
}

