/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.controls.AbstractTreePicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.util.Assert;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SourceObject;
import oracle.javatools.util.ModelUtil;

public class DBObjectPicker
extends AbstractTreePicker {
    protected static final Transferable[] EMPTY = new DBObjectTransferable[0];
    protected DBObjectRenderer m_dbRenderer = new DBObjectRenderer();
    protected DefaultMutableTreeNode m_top = new DefaultMutableTreeNode("DB_OBJECTS");
    protected DefaultTreeModel m_treeModel = new DefaultTreeModel(this.m_top);
    protected JTree m_tree = new JTree(this.m_treeModel);
    protected TreeNodeMaker m_nodeMaker = new TreeNodeMaker(this.m_tree);
    protected boolean m_remove;

    public DBObjectPicker(boolean showChildren, boolean removeOnShuttle) {
        this.setTree(this.m_tree);
        this.m_remove = removeOnShuttle;
        this.m_nodeMaker.setShowChildren(showChildren);
        this.setupTree();
    }

    public TreeNodeMaker getNodeMaker() {
        return this.m_nodeMaker;
    }

    public void reloadTree() {
        this.m_treeModel.reload();
    }

    private void setupTree() {
        this.m_tree.setRootVisible(false);
        this.m_dbRenderer.setIncludeIcon(true);
        this.m_tree.setCellRenderer(this.m_dbRenderer);
        this.m_tree.setShowsRootHandles(this.m_nodeMaker.getShowChildren());
        this.m_tree.setScrollsOnExpand(true);
        this.m_tree.getSelectionModel().setSelectionMode(4);
    }

    public void clear() {
        this.m_tree.removeAll();
        this.m_treeModel.reload();
    }

    public void addNode(DefaultMutableTreeNode node) {
        this.m_treeModel.insertNodeInto(node, this.m_top, this.m_top.getChildCount());
    }

    public void addDBObjects(DBObject[] objs) {
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            this.findOrAddChild(this.m_top, objs[i], null);
        }
    }

    public void addDBObjectPaths(DBObject[][] paths) {
        for (int i = 0; i < paths.length; ++i) {
            DefaultMutableTreeNode parent = this.m_top;
            for (int j = 0; j < paths[i].length; ++j) {
                parent = this.findOrAddChild(parent, paths[i][j], null);
            }
        }
    }

    protected DefaultMutableTreeNode findOrAddChild(DefaultMutableTreeNode parent, DBObject userObj, List addToSelection) {
        return this.findOrAddChild(parent, userObj, addToSelection, false);
    }

    private DefaultMutableTreeNode findOrAddChild(DefaultMutableTreeNode parent, DBObject userObj, List addToSelection, boolean replaceExisting) {
        boolean insertPointChosen = false;
        int insertAt = parent.getChildCount();
        Enumeration<TreeNode> kids = parent.children();
        int j = 0;
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode next = (DefaultMutableTreeNode)kids.nextElement();
            int c = DBUtil.getNameComparator().compare(userObj, (DBObject)next.getUserObject());
            if (c == 0) {
                if (replaceExisting) {
                    insertAt = j;
                    this.m_treeModel.removeNodeFromParent(next);
                    break;
                }
                return next;
            }
            if (c < 1 && !insertPointChosen) {
                insertAt = j;
                insertPointChosen = true;
            }
            ++j;
        }
        DefaultMutableTreeNode node = this.m_nodeMaker.createTreeNode(userObj);
        this.m_treeModel.insertNodeInto(node, parent, insertAt);
        TreePath path = new TreePath(node.getPath());
        if (addToSelection != null) {
            addToSelection.add(path);
        }
        return node;
    }

    private DBObject[] trimPath(Object[] path) {
        int root = -1;
        for (int j = 0; j < path.length; ++j) {
            if (path[j] != this.m_top.getUserObject()) continue;
            root = j;
            break;
        }
        int size = path.length - (root + 1);
        DBObject[] dbPath = new DBObject[size];
        System.arraycopy(path, root + 1, dbPath, 0, size);
        return dbPath;
    }

    private void removeFromParent(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode parent;
        if (node != null && node != this.m_top && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
            parent.remove(node);
            if (parent.getChildCount() < 1 && parent != this.m_top) {
                this.removeFromParent(parent);
            } else {
                this.m_treeModel.reload(parent);
            }
        }
    }

    public void setSelectedItems(DBObject[] objs) {
        TreeSelectionModel selectionModel = this.m_tree.getSelectionModel();
        selectionModel.clearSelection();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            this.setSelected(objs[i], this.m_top, selectionModel);
        }
    }

    private void setSelected(DBObject obj, DefaultMutableTreeNode parent, TreeSelectionModel selectionModel) {
        Enumeration<TreeNode> kids = parent.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)kids.nextElement();
            if (!DBUtil.areNamesAndTypesEqual((DBObject)obj, (DBObject)((DBObject)node.getUserObject()))) continue;
            selectionModel.addSelectionPath(new TreePath(node.getPath()));
            return;
        }
    }

    @Override
    public boolean isSelectableItemPresent() {
        return this.m_top.getChildCount() > 0;
    }

    @Override
    public boolean addSelectedItems(Transferable[] addMe) {
        if (this.m_remove) {
            this.m_tree.clearSelection();
            ArrayList selection = new ArrayList();
            for (int i = 0; i < addMe.length; ++i) {
                try {
                    DBObjectTransferable t = (DBObjectTransferable)addMe[i];
                    DefaultMutableTreeNode parent = this.m_top;
                    DBObject[] path = t.getPath();
                    if (path != null && path.length > 1) {
                        for (int j = 0; j < path.length; ++j) {
                            parent = this.findOrAddChild(parent, path[j], null, j == path.length - 1);
                        }
                        continue;
                    }
                    DBObject obj = t.getDBObject();
                    this.findOrAddChild(parent, obj, selection, true);
                    continue;
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
            int size = selection.size();
            if (size > 0) {
                TreePath[] sel = selection.toArray(new TreePath[size]);
                this.m_tree.setSelectionPaths(sel);
            }
        }
        return true;
    }

    @Override
    public void removeSelectedItems() {
        if (this.m_remove) {
            TreePath selectAfter = null;
            int[] rows = this.m_tree.getSelectionRows();
            if (rows != null && rows.length > 0) {
                Arrays.sort(rows);
                int max = rows[rows.length - 1];
                if (max == this.m_tree.getRowCount() - 1) {
                    int tryMe = max;
                    while (Arrays.binarySearch(rows, --tryMe) >= 0) {
                    }
                    if (tryMe >= 0) {
                        selectAfter = this.m_tree.getPathForRow(tryMe);
                    }
                } else {
                    selectAfter = this.m_tree.getPathForRow(max + 1);
                }
            }
            TreePath[] paths = this.m_tree.getSelectionPaths();
            for (int i = 0; paths != null && i < paths.length; ++i) {
                if (paths[i] == null) continue;
                this.removeFromParent((DefaultMutableTreeNode)paths[i].getLastPathComponent());
            }
            if (this.m_tree.getRowCount() > 0) {
                if (selectAfter == null) {
                    this.m_tree.setSelectionRow(0);
                } else {
                    this.m_tree.setSelectionPath(selectAfter);
                }
            }
        }
    }

    @Override
    public void removeAllSelectableItems() {
        if (this.m_remove) {
            this.m_top.removeAllChildren();
            this.m_treeModel.reload();
        }
    }

    @Override
    public Transferable createTransferable(TreePath treePath) {
        Object parent;
        DBObjectTransferable retval = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object obj = node.getUserObject();
        if (obj instanceof ChildDBObject && !(obj instanceof SourceObject) && ((ChildDBObject)obj).getParent() == null && (parent = ((DefaultMutableTreeNode)node.getParent()).getUserObject()) instanceof DBObject) {
            ((ChildDBObject)obj).setParent((DBObject)parent);
        }
        Object[] path = node.getUserObjectPath();
        if (obj != null && obj instanceof DBObject) {
            if (path == null) {
                retval = new DBObjectTransferable((DBObject)obj);
            } else {
                DBObject[] dbPath = this.trimPath(path);
                retval = new DBObjectTransferable((DBObject)obj, dbPath);
            }
        }
        return retval;
    }

    @Override
    public Transferable[] getAllSelectableItems() {
        ArrayList<DBObjectTransferable> retval = new ArrayList<DBObjectTransferable>();
        Enumeration<TreeNode> kids = this.m_top.children();
        while (kids.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)kids.nextElement();
            DBObject obj = (DBObject)node.getUserObject();
            retval.add(new DBObjectTransferable(obj));
        }
        if (retval.size() > 0) {
            return retval.toArray(new Transferable[retval.size()]);
        }
        return EMPTY;
    }

    @Override
    public DataFlavor[] getSelectionDataFlavors() {
        Transferable[] selection = this.getSelectedItems();
        if (selection != null) {
            DataFlavor[] retval = new DataFlavor[selection.length];
            for (int i = 0; i < retval.length; ++i) {
                retval[i] = ((DBObjectTransferable)selection[i]).getPrimaryFlavor();
            }
            return retval;
        }
        return null;
    }

    @Override
    public boolean canAcceptFlavors(DataFlavor[] df) {
        for (int i = 0; i < df.length; ++i) {
            Class<?> clz;
            if (df[i] == null || !ModelUtil.areEqual(clz = df[i].getDefaultRepresentationClass(), DBObjectTransferable.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        super.valueChanged(e);
    }
}

