/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.components;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.dialogs.CascadeConfirmDialog;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Property;

public abstract class ComponentFactory {
    private final DBUIResourceHelper m_resHelp;
    private final List<ComponentFactory> m_children = new ArrayList<ComponentFactory>();
    private Namespace m_dataContext;
    private String m_basePath;
    private final List<String> m_paths = new ArrayList<String>();
    private final List<ComponentWrapper> m_wrappers = new ArrayList<ComponentWrapper>();
    private boolean m_processed;
    private boolean m_editable = true;
    private boolean m_allowRecreate = true;

    public ComponentFactory(String panelName) {
        this(panelName, null);
    }

    public ComponentFactory(String panelName, ComponentFactory parent) {
        this.m_resHelp = panelName == null && parent != null ? parent.m_resHelp : new DBUIResourceHelper(panelName);
        if (parent != null) {
            parent.m_children.add(this);
        }
    }

    public final DBUIResourceHelper getResourceHelper() {
        return this.m_resHelp;
    }

    public final Collection<String> getPaths() {
        HashSet<String> retval = new HashSet<String>();
        block0: for (String path : this.m_paths) {
            Iterator existing = retval.iterator();
            while (existing.hasNext()) {
                String alreadyGot = (String)existing.next();
                if (path.startsWith(alreadyGot)) continue block0;
                if (!alreadyGot.startsWith(path)) continue;
                existing.remove();
            }
            retval.add(path);
        }
        return retval;
    }

    public final Collection<ComponentWrapper> getComponentWrappers() {
        return this.getComponentWrappers(true);
    }

    private Collection<ComponentWrapper> getComponentWrappers(boolean incChildren) {
        Collection<ComponentWrapper> retval;
        if (!incChildren || this.m_children.isEmpty()) {
            retval = Collections.unmodifiableCollection(this.m_wrappers);
        } else {
            retval = new ArrayList<ComponentWrapper>();
            retval.addAll(this.m_wrappers);
            for (ComponentFactory child : this.m_children) {
                retval.addAll(child.getComponentWrappers(true));
            }
        }
        return retval;
    }

    public void setActive(boolean active) {
        for (ComponentWrapper wrapper : this.getComponentWrappers()) {
            wrapper.setActive(active);
        }
    }

    public void refreshComponents(DBObject refreshObject) {
        boolean changed = false;
        for (ComponentWrapper wrapper : this.getComponentWrappers(false)) {
            changed = wrapper.refreshObject(refreshObject) || changed;
        }
        if (changed) {
            this.m_processed = false;
        }
        this.processComponents();
    }

    public void setAllowRecreate(boolean allow) {
        this.m_allowRecreate = allow;
    }

    public boolean isEditable() {
        return this.m_editable;
    }

    public void setEditable(boolean edit) {
        this.m_editable = edit;
    }

    public void setEnabled(boolean enabled) {
        for (ComponentWrapper wrapper : this.getComponentWrappers()) {
            wrapper.setEnabled(enabled);
        }
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public void setBasePath(String ... basePath) {
        this.m_basePath = Property.createPath((String[])basePath);
    }

    public void setDataContext(Namespace namespace) {
        this.m_dataContext = namespace;
        for (ComponentWrapper cw : this.getComponentWrappers()) {
            cw.getComponentContext().setDataContext(namespace);
        }
    }

    protected DBEditorConfig getEditorConfig() {
        return this.m_dataContext == null ? null : (DBEditorConfig)this.m_dataContext.find(DBEditorConfig.class);
    }

    public synchronized void processComponents() {
        DBObjectProvider pro;
        DBEditorConfig config = this.getEditorConfig();
        DBObjectProvider dBObjectProvider = pro = config == null ? null : config.getProvider();
        if (pro == null) {
            DBLog.getLogger((Object)this).severe("Cannot processComponent - no DBObjectProvider is available!");
        }
        if (pro != null) {
            for (ComponentWrapper wrapper : this.getComponentWrappers()) {
                if (this.m_processed && !wrapper.isVolatile()) continue;
                wrapper.processComponent(this.m_editable, this.m_allowRecreate);
            }
            this.m_processed = true;
        }
    }

    public synchronized void forceProcessComponents() {
        this.m_processed = false;
        this.processComponents();
    }

    public void processComponent(String propPath) {
        ComponentWrapper wrapper = this.findComponentWrapper(propPath);
        if (wrapper == null) {
            throw new IllegalStateException("Cannot process Component " + propPath + ": it is not registered");
        }
        wrapper.processComponent(this.m_editable, this.m_allowRecreate);
    }

    public void canCommit(DBEditorConfig config) throws TraversalException {
        if (config.getUpdatedObject() != null && !CascadeConfirmDialog.confirmReplace(config)) {
            throw new TraversalException(null);
        }
    }

    public synchronized ComponentWrapper findComponentWrapper(String propPath) {
        ComponentWrapper retval;
        block2: {
            ComponentFactory child;
            String base;
            String childPath;
            retval = null;
            int idx = this.m_paths.indexOf(propPath = Property.stripProperties((String)propPath));
            if (idx >= 0) {
                retval = this.m_wrappers.get(idx);
            }
            if (retval != null) break block2;
            Iterator<ComponentFactory> iterator = this.m_children.iterator();
            while (iterator.hasNext() && ((childPath = (base = (child = iterator.next()).getBasePath()) == null ? propPath : Property.stripStartingPath((String)propPath, (String[])new String[]{base})) == null || (retval = child.findComponentWrapper(childPath)) == null)) {
            }
        }
        return retval;
    }

    public synchronized void removeComponentWrapper(String propPath) {
        int idx = this.m_paths.indexOf(propPath = Property.stripProperties((String)propPath));
        if (idx >= 0) {
            this.m_wrappers.remove(idx);
            this.m_paths.remove(idx);
        } else {
            for (ComponentFactory child : this.m_children) {
                String base = child.getBasePath();
                String childPath = base == null ? propPath : Property.stripStartingPath((String)propPath, (String[])new String[]{base});
                if (childPath == null) continue;
                child.removeComponentWrapper(childPath);
            }
        }
    }

    public synchronized void registerComponentWrapper(ComponentWrapper wrapper) {
        String propPath = wrapper.getPropertyName();
        this.m_processed = false;
        this.m_wrappers.add(wrapper);
        String fullPath = Property.stripProperties((String)propPath);
        this.m_paths.add(fullPath);
        wrapper.resourceComponent(this.m_resHelp);
    }

    public ComponentContext createComponentContext(String propName, DBObject originalObject, DBObject contextObject) {
        if (this.getEditorConfig() == null) {
            throw new IllegalStateException("Cannot create a ComponentContext - no DBEditorConfig has been set");
        }
        ComponentContext retval = new ComponentContext(propName, originalObject, contextObject, this.m_dataContext, this.m_resHelp.getPanelName());
        retval.setBasePath(this.getBasePath());
        return retval;
    }

    public abstract ComponentWrapper createWrapper(ComponentContext var1);

    public final void registerComponent(Component comp, String propPath) {
        this.registerComponent(comp, propPath, propPath);
    }

    public final void registerComponent(Component comp, String componentName, String propPath) {
        this.registerComponent(null, comp, null, componentName, propPath);
    }

    public final void registerComponent(AbstractButton button, String buttonText, String propPath) {
        this.registerComponent(button, buttonText, propPath, propPath);
    }

    public final void registerComponent(AbstractButton button, String buttonText, String componentName, String propPath) {
        this.registerComponent(null, button, null, componentName, propPath);
        this.getResourceHelper().resButton(button, buttonText, componentName);
    }

    public final void registerComponent(JLabel label, Component component, String labelText, String propPath) {
        this.registerComponent(label, component, labelText, propPath, propPath);
    }

    public abstract void registerComponent(JLabel var1, Component var2, String var3, String var4, String var5);
}

