/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.View;
import oracle.javatools.util.ModelUtil;

public class DBObjectTransferable
implements Transferable {
    private DBObject m_obj;
    private DBObject[] m_path;
    private boolean m_incKids;
    private DataFlavor[] m_flavors;
    private static final Map<String, DataFlavor> s_flavors = new HashMap<String, DataFlavor>();

    public DBObjectTransferable(DBObject obj) {
        this(obj, null, false);
    }

    public DBObjectTransferable(DBObject obj, boolean includeChildren) {
        this(obj, null, includeChildren);
    }

    public DBObjectTransferable(DBObject obj, DBObject[] path) {
        this(obj, path, false);
    }

    public DBObjectTransferable(DBObject obj, DBObject[] path, boolean includeChildren) {
        this.m_obj = obj;
        this.m_path = path;
        this.m_incKids = includeChildren;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    public DBObject[] getPath() {
        if (this.m_path == null) {
            this.m_path = new DBObject[]{this.m_obj};
        }
        return this.m_path;
    }

    public DataFlavor getPrimaryFlavor() {
        return DBObjectTransferable.getDataFlavor(this.m_obj.getType());
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.m_flavors == null) {
            if (this.m_incKids && this.m_obj instanceof Relation) {
                if (this.m_obj instanceof Table) {
                    this.m_flavors = new DataFlavor[]{DBObjectTransferable.getDataFlavor("TABLE"), DBObjectTransferable.getDataFlavor("COLUMN"), DBObjectTransferable.getDataFlavor("CONSTRAINT"), DBObjectTransferable.getDataFlavor("INDEX")};
                } else if (this.m_obj instanceof View) {
                    this.m_flavors = new DataFlavor[]{DBObjectTransferable.getDataFlavor("VIEW"), DBObjectTransferable.getDataFlavor("COLUMN"), DBObjectTransferable.getDataFlavor("CONSTRAINT")};
                }
            } else {
                this.m_flavors = new DataFlavor[]{DBObjectTransferable.getDataFlavor(this.m_obj.getType())};
            }
        }
        return this.m_flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.getDefaultRepresentationClass() == DBObjectTransferable.class;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        String objType;
        if (!s_flavors.containsValue(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        String type = flavor.getHumanPresentableName();
        if (ModelUtil.areEqual((Object)type, (Object)(objType = this.m_obj.getType()))) {
            return this.m_obj;
        }
        if (this.m_obj instanceof Relation && this.m_incKids) {
            if ("COLUMN".equals(type)) {
                return ((Relation)this.m_obj).getColumns();
            }
            if ("CONSTRAINT".equals(type)) {
                return ((Relation)this.m_obj).getConstraints();
            }
            if (this.m_obj instanceof Table && "INDEX".equals(type)) {
                return ((Table)this.m_obj).getIndexes();
            }
        }
        return null;
    }

    public static DataFlavor getDataFlavor(String type) {
        DataFlavor f = s_flavors.get(type);
        if (f == null) {
            f = new DataFlavor(DBObjectTransferable.class, type);
            s_flavors.put(type, f);
        }
        return f;
    }
}

