/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.sql.Connection;
import java.util.HashMap;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xqxp.datamodel.FSType;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xquery.XQException;
import oracle.xquery.exec.BindExpr;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.ConvertXML;
import oracle.xquery.exec.ConvertXMLUtils;
import oracle.xquery.exec.ExprResultIterator;
import oracle.xquery.exec.OXMLItemList;
import oracle.xquery.exec.OXQuerySequence;
import oracle.xquery.exec.OptimizeContext;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.SQLQuery;
import oracle.xquery.exec.Trace;
import oracle.xquery.exec.Variable;
import oracle.xquery.exec.Visitor;
import oracle.xquery.parser.XQXGen;

public abstract class Expr
implements ConvertXML {
    protected Expr[] kids;
    protected Expr parent;
    protected FSType staticType;
    protected int staticTypingStatus;
    protected int ebv;
    protected static final int PASS = 0;
    protected static final int UNKNOWN = 1;
    protected static final int ATOMIZATION = 2;
    protected static final int CAST = 4;
    protected static final int TYPE_PROMOTION = 8;
    protected static final int INIT_STATUS = 15;
    protected static final int EBV_TRUE = 0;
    protected static final int EBV_FALSE = 1;
    protected static final int EBV_UNKNOWN = 2;
    private static XMLDocument xmldoc = new XMLDocument();
    private static HashMap symbolTab = new HashMap();

    protected static final XMLDocument getDoc() {
        return xmldoc;
    }

    protected static final HashMap getSymbolTable() {
        return symbolTab;
    }

    public static Expr[] createArray(Expr expr) {
        Expr[] exprArray = new Expr[]{expr};
        return exprArray;
    }

    public static Expr[] createArray(Expr expr, Expr expr2) {
        Expr[] exprArray = new Expr[]{expr, expr2};
        return exprArray;
    }

    public static Expr[] createArray(Expr expr, Expr expr2, Expr expr3) {
        Expr[] exprArray = new Expr[]{expr, expr2, expr3};
        return exprArray;
    }

    public static Expr CreateFromXML(XMLElement xMLElement) {
        return (Expr)ConvertXMLUtils.createFromXML(xMLElement, false);
    }

    @Override
    public ConvertXML DefinitionFromXML(XMLElement xMLElement) {
        return this.fromXML(xMLElement);
    }

    @Override
    public ConvertXML fromXML(XMLElement xMLElement) {
        this.fromXMLKids(xMLElement);
        return this;
    }

    public void getStrRep(StringBuffer stringBuffer) {
        throw new XQException(" Class " + this.getClass().getName() + " does not implement the getStrRep method ");
    }

    protected final String getEBVString() {
        return this.ebv == 2 ? "unknown" : (this.ebv == 0 ? "true" : "false");
    }

    @Override
    public abstract XMLNode toXML();

    public final void toXMLKids(XMLNode xMLNode) {
        ConvertXMLUtils.toXMLKids(xmldoc, xMLNode, this.kids);
    }

    public final void fromXMLKids(XMLElement xMLElement) {
        ConvertXML[] convertXMLArray = ConvertXMLUtils.fromXMLKids(this, xMLElement);
        if (convertXMLArray != null && convertXMLArray.length > 0) {
            Expr[] exprArray = new Expr[convertXMLArray.length];
            for (int i = 0; i < convertXMLArray.length; ++i) {
                exprArray[i] = (Expr)convertXMLArray[i];
            }
            this.setup(exprArray);
        }
    }

    public final void toKidsStrRep(StringBuffer stringBuffer, String string) {
        int n;
        for (n = 0; n < this.kids.length - 1; ++n) {
            this.kids[n].getStrRep(stringBuffer);
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
        }
        this.kids[n].getStrRep(stringBuffer);
    }

    public Expr[] getKids() {
        return this.kids;
    }

    void setup(Expr[] exprArray) {
        this.staticTypingStatus = 15;
        this.ebv = 2;
        this.kids = exprArray;
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i].parent = this;
            }
        }
    }

    void setup(Expr expr) {
        Expr[] exprArray = Expr.createArray(expr);
        this.setup(exprArray);
    }

    Expr replaceMeWithKid(Expr expr) {
        if (this.parent == null) {
            return this;
        }
        for (int i = 0; i < this.parent.kids.length; ++i) {
            if (this.parent.kids[i] != this) continue;
            this.parent.kids[i] = expr;
            expr.parent = this.parent;
            expr.staticTypingStatus = this.staticTypingStatus;
            this.parent = null;
            return expr;
        }
        return this;
    }

    public Expr(Expr[] exprArray) {
        this.setup(exprArray);
    }

    public Expr(Expr expr) {
        Expr[] exprArray = new Expr[]{expr};
        this.setup(exprArray);
    }

    public Expr(Expr expr, Expr expr2) {
        Expr[] exprArray = new Expr[]{expr, expr2};
        this.setup(exprArray);
    }

    public Expr() {
        this.setup((Expr[])null);
    }

    public abstract OXMLSequence Evaluate(QueryState var1);

    public final OXMLSequence EvaluateUsingIterator(QueryState queryState) {
        ExprResultIterator exprResultIterator = this.getIterator(queryState);
        OXMLSequence oXMLSequence = queryState.createSequence(exprResultIterator);
        return oXMLSequence;
    }

    public void toSql(XQXGen xQXGen) {
        throw new XQException("toSql not implemented");
    }

    public void toSqlScalar(XQXGen xQXGen) {
        if (this.getDatatype() == 90) {
            xQXGen.startElement("function", XQXGen.createAttrs("name", "ExtractValue"));
            this.toSql(xQXGen);
            ConstantExpr.toSql(xQXGen, "//text()");
            xQXGen.endElement("function");
        } else {
            this.toSql(xQXGen);
        }
    }

    public void toSqlDefault(XQXGen xQXGen) {
        if (this.kids == null) {
            return;
        }
        for (int i = 0; i < this.kids.length; ++i) {
            this.kids[i].toSql(xQXGen);
        }
    }

    public void toSqlDisplay(XQXGen xQXGen) {
        boolean bl = this.getDatatype() == 90;
        xQXGen.startElement("simpleQuery");
        xQXGen.startElement("selectList");
        xQXGen.startElement("selectItem");
        if (bl) {
            xQXGen.startElement("function", XQXGen.createAttrs("name", "sys.xmltype.getclobval"));
            this.toSql(xQXGen);
            xQXGen.endElement("function");
        } else {
            this.toSql(xQXGen);
        }
        xQXGen.startElement("alias");
        xQXGen.characters("C");
        xQXGen.endElement("alias");
        xQXGen.endElement("selectItem");
        xQXGen.endElement("selectList");
        xQXGen.startElement("fromList");
        xQXGen.startElement("fromItem");
        xQXGen.startElement("tableName");
        xQXGen.startElement("simpleIdentifier");
        xQXGen.characters("DUAL");
        xQXGen.endElement("simpleIdentifier");
        xQXGen.endElement("tableName");
        xQXGen.endElement("fromItem");
        xQXGen.endElement("fromList");
        xQXGen.endElement("simpleQuery");
    }

    public void toSqlQuery(XQXGen xQXGen, String string) {
        xQXGen.startElement("simpleQuery");
        xQXGen.startElement("selectList");
        xQXGen.startElement("selectItem");
        xQXGen.startElement("variable");
        xQXGen.startElement("simpleIdentifier");
        xQXGen.characters("COLUMN_VALUE");
        xQXGen.endElement("simpleIdentifier");
        xQXGen.endElement("variable");
        if (string != null) {
            xQXGen.startElement("alias");
            xQXGen.characters(string);
            xQXGen.endElement("alias");
        }
        xQXGen.endElement("selectItem");
        xQXGen.endElement("selectList");
        xQXGen.startElement("fromList");
        xQXGen.startElement("fromItem");
        xQXGen.startElement("tableExpr");
        xQXGen.startElement("function", XQXGen.createAttrs("name", "XMLSequence"));
        this.toSql(xQXGen);
        xQXGen.endElement("function");
        xQXGen.endElement("tableExpr");
        xQXGen.endElement("fromItem");
        xQXGen.endElement("fromList");
        xQXGen.endElement("simpleQuery");
    }

    public ExprResultIterator getIterator(QueryState queryState) {
        OXMLSequence oXMLSequence = this.Evaluate(queryState);
        return new ExprIterator2(this, oXMLSequence, queryState);
    }

    public Expr optimizedrv(OptimizeContext optimizeContext) {
        boolean bl = false;
        String string = null;
        Connection connection = null;
        if (optimizeContext == null) {
            return this;
        }
        string = optimizeContext.getTopQuery();
        if (bl) {
            System.out.println("before optimization: " + string);
        }
        this.optimize(optimizeContext);
        string = optimizeContext.getTopQuery();
        connection = optimizeContext.getSQLConn();
        if (connection == null) {
            if (optimizeContext.getDefConn() == null) {
                return this;
            }
            connection = optimizeContext.getDefConn();
        }
        if (bl) {
            System.out.println("after optimization: " + string);
            System.out.println("xquery pushdown : " + optimizeContext.xqPushdown);
            if (connection != null) {
                System.out.println("sqlconn is set ");
            }
        }
        if (optimizeContext.xqPushdown && string != null && connection != null) {
            boolean bl2 = false;
            String string2 = null;
            string = string.replace('\'', '\"');
            string2 = bl2 ? "select XMLQuery('" + string + "' returning content).getclobval() from dual" : "select p.column_value.getclobval() from xmltable('" + string + "' ) p";
            if (bl) {
                System.out.println("final query: " + string2);
            }
            SQLQuery sQLQuery = new SQLQuery(connection, string2);
            sQLQuery.setNeedRowTag(false);
            sQLQuery.setNeedXMLRes(true);
            sQLQuery.setXMLType(null, null);
            return sQLQuery;
        }
        return this;
    }

    public Expr optimize(OptimizeContext optimizeContext) {
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i] = this.kids[i].optimize(optimizeContext);
                this.kids[i].parent = this;
            }
        }
        return this;
    }

    public Expr normalize() {
        if (this.kids != null) {
            for (int i = 0; i < this.kids.length; ++i) {
                this.kids[i] = this.kids[i].normalize();
                this.kids[i].parent = this;
            }
        }
        return this;
    }

    public int getDatatype() {
        return 90;
    }

    public abstract void acceptVisitor(Visitor var1);

    protected FSType getStaticType() {
        return this.staticType;
    }

    protected void setStaticType(FSType fSType) {
        this.staticType = fSType;
    }

    protected final void passStaticTyping() {
        this.staticTypingStatus = 0;
    }

    protected final void knowStaticType() {
        this.staticTypingStatus &= 0xFFFFFFFE;
    }

    protected final boolean needRuntimeTyping() {
        return this.staticTypingStatus != 0;
    }

    protected final boolean unknownStaticType() {
        return (this.staticTypingStatus & 1) == 1;
    }

    protected final void noAtomization() {
        this.staticTypingStatus &= 0xFFFFFFFD;
    }

    protected final boolean needAtomization() {
        return (this.staticTypingStatus & 2) == 2;
    }

    protected final void noCast() {
        this.staticTypingStatus &= 0xFFFFFFFB;
    }

    protected final boolean needCast() {
        return (this.staticTypingStatus & 4) == 4;
    }

    protected final void noTypePromotion() {
        this.staticTypingStatus &= 0xFFFFFFF7;
    }

    protected final boolean needTypePromotion() {
        return (this.staticTypingStatus & 8) == 8;
    }

    public void printStaticType(StringBuffer stringBuffer) {
        if (this.staticType != null) {
            this.staticType.toString(stringBuffer);
        }
    }

    protected final void setEBV(boolean bl) {
        this.ebv = bl ? 0 : 1;
    }

    protected final boolean unknownEBV() {
        return this.ebv == 2;
    }

    protected final boolean trueEBV() {
        return this.ebv == 0;
    }

    protected final boolean falseEBV() {
        return this.ebv == 1;
    }

    public int getPositionTest() {
        return 0;
    }

    int getPositionTestExact() {
        return 0;
    }

    public boolean isUpdateExpr() {
        return false;
    }

    protected void reset() {
        this.staticTypingStatus = 15;
        if (!(this instanceof Variable || this instanceof BindExpr || this instanceof ConstantExpr)) {
            this.staticType = null;
        }
    }

    static class ExprIterator2
    implements ExprResultIterator {
        Expr expr;
        OXMLSequence seq;
        QueryState qryState;

        public ExprIterator2(Expr expr, OXMLSequence oXMLSequence, QueryState queryState) {
            this.expr = expr;
            this.seq = oXMLSequence;
            this.qryState = queryState;
        }

        @Override
        public void Restart() {
            ((OXQuerySequence)this.seq).restart();
        }

        @Override
        public void Close() {
        }

        @Override
        public OXMLItem Fetch() {
            if (this.seq.next()) {
                return this.seq.getItem();
            }
            return null;
        }
    }

    static class ExprIterator
    implements ExprResultIterator {
        Expr expr;
        boolean eof;
        OXMLItemList itemList;
        int currIndex;
        QueryState qryState;

        public ExprIterator(Expr expr, OXMLItemList oXMLItemList, QueryState queryState) {
            this.expr = expr;
            this.itemList = oXMLItemList;
            this.eof = this.itemList.getLength() == 0;
            this.currIndex = 0;
            this.qryState = queryState;
        }

        @Override
        public void Restart() {
            this.eof = this.itemList.getLength() == 0;
            this.currIndex = 0;
        }

        @Override
        public void Close() {
            Trace.trace(1, this, "Entering Close");
            this.eof = true;
        }

        @Override
        public OXMLItem Fetch() {
            if (this.eof) {
                return null;
            }
            OXMLItem oXMLItem = this.itemList.getItem(this.qryState, this.currIndex);
            ++this.currIndex;
            if (this.currIndex == this.itemList.getLength()) {
                this.eof = true;
            }
            return oXMLItem;
        }
    }

    public static class ExprTypes {
        public static final int VARIABLE = 1;
        public static final int CONSTANT = 2;
        public static final int LETEXPR = 3;
        public static final int FLWR = 4;
        public static final int XPATH = 5;
        public static final int XMLCONS = 6;
        public static final int RELOP = 7;
        public static final int LOGICALOP = 8;
        public static final int ARITHOP = 9;
    }
}

