/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.model;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.model.NewWorkingSetPanel;
import oracle.jdevimpl.model.PatternFiltersPanel;
import oracle.jdevimpl.model.PatternFiltersTreePanel;
import oracle.jdevimpl.model.WorkingSetsEditor;

public class WorkingSetsPanel
extends DefaultTraversablePanel
implements ActionListener,
ItemListener {
    private static final String HELP_TOPIC_ID = "f1_idedworkingsets_html";
    private final TabbedPanel tabbedPanel;
    private final JComboBox cbWorkingSet = new JComboBox();
    private final JButton btnSaveAs = new JButton();
    private final JButton btnDelete = new JButton();
    private final DTCache dtCache = Ide.isRunning() ? Ide.getDTCache() : new DTCache();
    private transient int defaultTab = this.dtCache.getInteger("WorkingSetsPanel.defaultTab", -1);
    private transient Project _project;
    private transient Workspace _workspace;
    private transient WorkingSets _workingSets;
    private WorkingSetChangedListener _workingSetListener;
    private String[] _initialSelection;
    private final HashMap _state = new HashMap();

    public WorkingSetsPanel() {
        this.tabbedPanel = new TabbedPanel(new Navigable[]{new Navigable(ModelArb.getString((int)57), PatternFiltersTreePanel.class), new Navigable(ModelArb.getString((int)58), PatternFiltersPanel.class)});
        JWrappedLabel promptText = new JWrappedLabel(ModelArb.getString((int)59));
        JLabel lblWorkingSet = new JLabel();
        ResourceUtils.resLabel((JLabel)lblWorkingSet, (Component)this.cbWorkingSet, (String)ModelArb.getString((int)60));
        this.btnSaveAs.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnSaveAs, (String)ModelArb.getString((int)61));
        this.btnDelete.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnDelete, (String)ModelArb.getString((int)62));
        this.setLayout(new GridBagLayout());
        Insets introInsets = new Insets(0, 0, 10, 0);
        Insets labelInsets = new Insets(0, 0, 0, 0);
        Insets buttonInsets = new Insets(0, 8, 0, 0);
        Insets tabPanelInsets = new Insets(10, 0, 0, 0);
        this.add((Component)promptText, this.gbc(0, 0, 4, 1, 1.0, 0.0, 18, 2, introInsets));
        this.add(lblWorkingSet, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, labelInsets));
        this.add(this.cbWorkingSet, this.gbc(1, 1, 1, 1, 1.0, 0.0, 17, 2, buttonInsets));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 8, 0));
        buttonPanel.add(this.btnSaveAs);
        buttonPanel.add(this.btnDelete);
        this.add(buttonPanel, this.gbc(2, 1, 1, 1, 0.0, 0.0, 17, 0, buttonInsets));
        this.add((Component)this.tabbedPanel, this.gbc(0, 2, 4, 1, 1.0, 1.0, 18, 1, tabPanelInsets));
    }

    public void onEntry(TraversableContext tc) {
        WorkingSet cur;
        this._initialSelection = (String[])tc.find("initial-selection");
        this._project = (Project)tc.find("Project");
        this._workspace = (Workspace)tc.find("Application");
        this._workingSets = WorkingSets.getInstance((Workspace)this._workspace);
        List workingSetNames = this._workingSets.getWorkingSetNames();
        workingSetNames.remove(WorkingSets.ALL_FILES_WORKING_SET_LABEL);
        int currentIndex = 0;
        String currentName = this._workingSets.getCurrentWorkingSetName();
        Object[] names = new WS[workingSetNames.size()];
        for (int i = 0; i < workingSetNames.size(); ++i) {
            String workingSetName = (String)workingSetNames.get(i);
            names[i] = new WS(workingSetName);
            if (!workingSetName.equals(currentName)) continue;
            currentIndex = i;
        }
        NonNullableComboBoxModel cbModel = new NonNullableComboBoxModel(names);
        this.cbWorkingSet.setModel(cbModel);
        this.cbWorkingSet.setSelectedIndex(currentIndex);
        this.storeState(this.curWorkingSetName());
        this.cbWorkingSet.addItemListener(this);
        this.addWorkingSetListener();
        if (this.cbWorkingSet.getSelectedItem() == null) {
            this.tabbedPanel.setEnabled(false);
        }
        WorkingSetsEditor.setPatternFilters((Namespace)tc, (cur = this._workingSets.getCurrentWorkingSet()) != null ? cur.getPatternFilters() : null);
        this.enterTabbedPanel(this.curWorkingSetName());
        this.updateEnabledStates();
    }

    private void enterTabbedPanel(String wsName) {
        this.tabbedPanel.onEntry(this.getTabbedTC(wsName));
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this._state.clear();
        this.removeWorkingSetListener();
        this.cbWorkingSet.removeItemListener(this);
        TraversableContext exitTC = this.exitTabbedPanel(this.curWorkingSetName());
        Integer index = (Integer)exitTC.getDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX");
        if (index != null) {
            this.dtCache.putInteger("WorkingSetsPanel.defaultTab", index.intValue());
        }
    }

    private TraversableContext exitTabbedPanel(String wsName) throws TraversalException {
        TraversableContext tc = this.getTabbedTC(wsName);
        this.tabbedPanel.onExit(tc);
        return tc;
    }

    private String curWorkingSetName() {
        return ((WS)this.cbWorkingSet.getSelectedItem()).getName();
    }

    private TraversableContext getTabbedTC(String wsName) {
        WorkingSet ws;
        Namespace data = new Namespace();
        if (wsName != null && (ws = this._workingSets.getWorkingSet(wsName)) != null) {
            PatternFilters patternFilters = ws.getPatternFilters();
            WorkingSetsEditor.setPatternFilters(data, patternFilters);
        }
        data.put("Project", (Object)this._project);
        data.put("Application", (Object)this._workspace);
        data.put("initial-selection", (Object)this._initialSelection);
        TraversableContext tc = new TraversableContext(data, 0);
        if (this.defaultTab != -1) {
            tc.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", (Object)new Integer(this.defaultTab));
        }
        return tc;
    }

    private void workingSetModified() {
        WS item = (WS)this.cbWorkingSet.getSelectedItem();
        item.setModified(true);
        this.cbWorkingSet.repaint();
    }

    private WorkingSetChangedListener getWorkingSetListener() {
        if (this._workingSetListener == null) {
            this._workingSetListener = new WorkingSetChangedListener();
        }
        return this._workingSetListener;
    }

    private void addWorkingSetListener() {
        HashStructure userProps = this._workspace.getUserPropertiesOnly();
        userProps.addStructureChangeListener((StructureChangeListener)this.getWorkingSetListener());
    }

    private void removeWorkingSetListener() {
        HashStructure userProps = this._workspace.getUserPropertiesOnly();
        userProps.removeStructureChangeListener((StructureChangeListener)this.getWorkingSetListener());
    }

    private void storeState(String name) {
        if (!this._state.containsKey(name)) {
            PatternFilter[] filters = this._workingSets.getWorkingSet(name).getPatternFilters().getFilters();
            String[] patterns = new String[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                patterns[i] = filters[i].toStr();
            }
            this._state.put(name, patterns);
        }
    }

    private void refreshFromState(WorkingSet workingSet) {
        String name = workingSet.getName();
        if (this._state.containsKey(name)) {
            PatternFilters pfs = workingSet.getPatternFilters();
            pfs.setFilters(new PatternFilter[0]);
            String[] patterns = (String[])this._state.get(name);
            for (int i = patterns.length - 1; i >= 0; --i) {
                if (patterns[i].startsWith("+")) {
                    pfs.addInclude(patterns[i].substring(1));
                    continue;
                }
                pfs.addExclude(patterns[i].substring(1));
            }
        }
        this._state.remove(name);
    }

    public String getHelpID() {
        return HELP_TOPIC_ID;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int type = e.getStateChange();
        WS ws = (WS)e.getItem();
        String wsName = ws.getName();
        if (type == 1) {
            this._workingSets.setCurrentWorkingSetName(wsName);
            this.enterTabbedPanel(wsName);
            this.updateEnabledStates();
            if (!ws._modified) {
                this.storeState(wsName);
                this.addWorkingSetListener();
            }
        } else if (type == 2) {
            try {
                this.exitTabbedPanel(wsName);
            }
            catch (TraversalException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void updateEnabledStates() {
        Object item = this.cbWorkingSet.getSelectedItem();
        boolean enable = item != null;
        this.btnDelete.setEnabled(enable && this.cbWorkingSet.getItemCount() > 1);
        if (item == null) {
            this.enterTabbedPanel(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnSaveAs) {
            NewWorkingSetPanel details = new NewWorkingSetPanel();
            details.setHelpID("f1_idedsaveas_html");
            final Namespace data = new Namespace();
            TDialogLauncher launcher = details.getTDialogLauncher((Component)((Object)this), data);
            final JEWTDialog dlg = launcher.initDialog();
            dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    String name;
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && ((name = data.find("name").toString()).indexOf(File.separatorChar) != -1 || name.indexOf(47) != -1)) {
                        String title = ModelArb.getString((int)66);
                        String message = ModelArb.getString((int)67);
                        MessageDialog.error((Component)dlg, (Object)message, (String)title, null);
                        throw new PropertyVetoException("no", evt);
                    }
                }
            });
            boolean response = dlg.runDialog();
            if (response) {
                String name = data.find("name").toString();
                WS activeWS = (WS)this.cbWorkingSet.getSelectedItem();
                WorkingSet activeWorkingSet = this._workingSets.getWorkingSet(activeWS.getName());
                if (this._workingSets.getWorkingSetNames().contains(name)) {
                    if (!name.equals(activeWorkingSet.getName())) {
                        activeWorkingSet.copyTo((Object)this._workingSets.getWorkingSet(name));
                        this.refreshFromState(activeWorkingSet);
                    }
                    for (int i = 0; i < this.cbWorkingSet.getItemCount(); ++i) {
                        WS wsItem = (WS)this.cbWorkingSet.getItemAt(i);
                        if (!name.equals(wsItem.getName())) continue;
                        this.cbWorkingSet.setSelectedIndex(i);
                        break;
                    }
                } else {
                    WorkingSet newWorkingSet = this._workingSets.getWorkingSet(name);
                    activeWorkingSet.copyTo((Object)newWorkingSet);
                    this.refreshFromState(activeWorkingSet);
                    WS newItem = new WS(name);
                    this.cbWorkingSet.addItem(newItem);
                    this.cbWorkingSet.setSelectedItem(newItem);
                }
                activeWS.setModified(false);
                this.cbWorkingSet.repaint();
            }
        } else if (source == this.btnDelete) {
            String name = this.curWorkingSetName();
            int i = this.cbWorkingSet.getSelectedIndex();
            this.cbWorkingSet.removeItemAt(i);
            int n = this.cbWorkingSet.getItemCount() - 1;
            if (n < 0) {
                this.cbWorkingSet.setSelectedItem(null);
            } else {
                this.cbWorkingSet.setSelectedIndex(i <= n ? i : n);
            }
            this.updateEnabledStates();
            this._workingSets.deleteWorkingSet(name);
        }
    }

    private static class WS {
        String _name;
        boolean _modified;
        final String MODIFIED = " " + ModelArb.getString((int)63);

        WS(String name) {
            this._name = name;
        }

        void setModified(boolean modified) {
            this._modified = modified;
        }

        String getName() {
            return this._name;
        }

        public String toString() {
            if (this._modified) {
                return this._name + this.MODIFIED;
            }
            return this._name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WS)) {
                return false;
            }
            WS other = (WS)obj;
            return this._name.equals(other._name) && this._modified == other._modified;
        }
    }

    private class WorkingSetChangedListener
    extends StructureChangeListener {
        private WorkingSetChangedListener() {
        }

        public void structureValuesChanged(StructureChangeEvent event) {
            ChangeInfo[] details = event.getChangeDetails();
            for (int i = 0; i < details.length; ++i) {
                String propertyName = details[i].getPropertyName();
                if (!propertyName.startsWith("working-sets") || propertyName.indexOf(WorkingSetsPanel.this.curWorkingSetName()) == -1) continue;
                WorkingSetsPanel.this.removeWorkingSetListener();
                WorkingSetsPanel.this.workingSetModified();
                return;
            }
        }
    }
}

