/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.builders.BuiltList;
import oracle.javatools.ui.builders.ListBuilder;
import oracle.jdeveloper.model.SelectDependenciesPanel;
import oracle.jdeveloper.resource.JProjectArb;

public class DependencyPanel
extends DefaultTraversablePanel {
    public static final String PROPERTY_STORAGE_KEY = DependencyPanel.class.getName() + ".property.storage";
    public static final String PROJECT_URL_KEY = DependencyPanel.class.getName() + ".project.url";
    public static final String DEPENDABLE_UNDER_EDIT_KEY = DependencyPanel.class.getName() + ".dependable.under.edit";
    public static final String WORKSPACE_KEY = "Application";
    private BuiltList<DepItem> _listComponent;
    private final SelectDependenciesPanel _selectDependenciesPanel = new SelectDependenciesPanel();
    private List<DepItem> _selectedDepItems;
    private Dependable _activeDependable;
    private Set<URL> _children;
    private URL _curProjectURL;
    private Workspace _curWorkspace;
    private static final String PANEL_VISITED_KEY = DependencyPanel.class.getName() + ".panel.visited";

    public DependencyPanel() {
        this.setHelpID("f1_idedprojsetdependencies_html");
        this.setLayout(new BorderLayout());
        this.initializeComponent();
    }

    public void setSelectionDialogHelpId(String helpTopicId) {
        this._selectDependenciesPanel.setHelpID(helpTopicId);
    }

    public void setSelectionDialogInstruction(String text) {
        this._selectDependenciesPanel.setInstructionText(text);
    }

    public void onEntry(TraversableContext dataContext) {
        if (!dataContext.contains(PANEL_VISITED_KEY)) {
            DependencyConfiguration depConfig;
            List<DepItem> dependencies;
            dataContext.put(PANEL_VISITED_KEY, (Object)Boolean.TRUE);
            this._curProjectURL = (URL)dataContext.get(PROJECT_URL_KEY);
            Assert.check((this._curProjectURL != null ? 1 : 0) != 0, (String)"The URL of the active project must be stored in the namespace");
            this._curWorkspace = (Workspace)dataContext.get(WORKSPACE_KEY);
            Assert.check((this._curWorkspace != null ? 1 : 0) != 0, (String)"The active workspace must be stored in the namespace");
            PropertyStorage propertyStorage = (PropertyStorage)dataContext.get(PROPERTY_STORAGE_KEY);
            Assert.check((propertyStorage != null ? 1 : 0) != 0, (String)"The PropertyStorage must be stored in the namespace");
            if (dataContext.contains(DEPENDABLE_UNDER_EDIT_KEY)) {
                this._activeDependable = (Dependable)dataContext.get(DEPENDABLE_UNDER_EDIT_KEY);
            }
            if (!(dependencies = this.wrapDependables((depConfig = DependencyConfiguration.getInstance((PropertyStorage)propertyStorage)).getDependencyList())).isEmpty()) {
                this._selectedDepItems.addAll(dependencies);
                final JList list = this._listComponent.getJList();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        list.clearSelection();
                        list.setSelectedIndex(0);
                    }
                });
            }
            this._listComponent.setEnabled(this.getChildren().size() > 1);
        }
    }

    private Set getChildren() {
        if (this._children == null) {
            this._children = new HashSet<URL>();
            Iterator children = this._curWorkspace.getChildren();
            while (children.hasNext()) {
                Object next = children.next();
                if (!(next instanceof Project)) continue;
                this._children.add(((Project)next).getURL());
            }
        }
        return this._children;
    }

    public void onExit(TraversableContext dataContext) {
        PropertyStorage propertyStorage = (PropertyStorage)dataContext.get(PROPERTY_STORAGE_KEY);
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((PropertyStorage)propertyStorage);
        dependencyConfiguration.setDependencyList(this.getDependables());
    }

    private void selectDependencies() {
        Namespace data = new Namespace();
        data.put(WORKSPACE_KEY, (Object)this._curWorkspace);
        data.put(SelectDependenciesPanel.PROJECT_URL_KEY, (Object)this._curProjectURL);
        data.put(SelectDependenciesPanel.DEPENDENCIES_KEY, this.getDependables());
        data.put(SelectDependenciesPanel.DEPENDENCIES_INSERTION_POINT, (Object)this._listComponent.getJList().getMaxSelectionIndex());
        data.put(SelectDependenciesPanel.DEPENDABLE_UNDER_EDIT_KEY, (Object)this._activeDependable);
        TDialogLauncher launcher = new TDialogLauncher((Component)((Object)this), JProjectArb.getString((int)187), (Traversable)this._selectDependenciesPanel, data);
        launcher.setInitialSize(new Dimension(475, 400));
        JEWTDialog dialog = launcher.initDialog();
        dialog.setOKButtonEnabled(false);
        this._selectDependenciesPanel.setDialog(dialog);
        boolean okResponse = dialog.runDialog();
        dialog.dispose();
        if (okResponse) {
            List newDeps = (List)data.find(SelectDependenciesPanel.DEPENDENCIES_KEY);
            List<DepItem> dependencies = this.wrapDependables(newDeps);
            final int newDepsIndex = (Integer)data.find(SelectDependenciesPanel.DEPENDENCIES_INSERTION_POINT);
            this._selectedDepItems.clear();
            this._selectedDepItems.addAll(dependencies);
            final JList list = this._listComponent.getJList();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    list.clearSelection();
                    list.setSelectedIndex(newDepsIndex);
                }
            });
        }
    }

    private List<DepItem> wrapDependables(List dependables) {
        if (dependables == null || dependables.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DepItem> depItems = new ArrayList<DepItem>(dependables.size());
        Iterator deps = dependables.iterator();
        while (deps.hasNext()) {
            depItems.add(new DepItem((Dependable)deps.next()));
        }
        return depItems;
    }

    private List<Dependable> getDependables() {
        ArrayList<Dependable> deps = new ArrayList<Dependable>();
        for (DepItem depItem : this._selectedDepItems) {
            deps.add(depItem._dep);
        }
        return deps;
    }

    private void initializeComponent() {
        ActionListener addListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DependencyPanel.this.selectDependencies();
            }
        };
        ActionListener removeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DependencyPanel.this._selectedDepItems.removeAll(DependencyPanel.this._listComponent.getSelectedValues());
            }
        };
        ListBuilder builder = new ListBuilder();
        builder.setLabel(JProjectArb.getString((int)179));
        builder.setEmptyTextLarge(JProjectArb.getString((int)180));
        builder.setRenderer((ListCellRenderer)new DependableRenderer());
        builder.setReorderable(true);
        builder.setRollover(true);
        builder.setSelectionMode(2);
        builder.setActionsDefault(ListBuilder.DefaultAction.ADD, addListener);
        builder.setActionsDefault(ListBuilder.DefaultAction.REMOVE, removeListener);
        this._listComponent = builder.build();
        this._selectedDepItems = this._listComponent.getListModel();
        this.add(this._listComponent.getGUI(), "Center");
    }

    private class DependableRenderer
    extends DefaultListCellRenderer {
        private DependableRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DepItem) {
                DepItem d = (DepItem)value;
                label.setIcon(d.getIcon());
                label.setText(d.toString());
            }
            return label;
        }
    }

    private class DepItem {
        Icon _icon;
        String _label;
        final Dependable _dep;

        DepItem(Dependable dependable) {
            this._dep = dependable;
        }

        private Icon getIcon() {
            if (this._icon == null) {
                this.getLabelAndIcon();
            }
            return this._icon;
        }

        private void getErrorOrWarningLabelAndIcon(Locatable locatable) {
            URL nextURL;
            Set children = DependencyPanel.this.getChildren();
            if (!children.contains(nextURL = locatable.getURL())) {
                if (URLFileSystem.exists((URL)nextURL)) {
                    this._icon = OracleIcons.getIcon((String)"warning.png");
                    this._label = String.format("%s - %s", this._dep.toString(), JProjectArb.getString((int)177));
                } else {
                    this._icon = OracleIcons.getIcon((String)"error.png");
                    this._label = String.format("%s - %s", this._dep.toString(), JProjectArb.getString((int)176));
                }
            }
        }

        private void getLabelAndIcon() {
            if (this._label != null || this._icon != null) {
                return;
            }
            if (this._dep.getSource() instanceof Locatable) {
                this.getErrorOrWarningLabelAndIcon((Locatable)this._dep.getSource());
            } else if (this._dep.getSourceOwner() instanceof Locatable) {
                this.getErrorOrWarningLabelAndIcon((Locatable)this._dep.getSourceOwner());
            }
            if (this._label == null) {
                this._label = this._dep.toString();
            }
            if (this._icon == null) {
                this._icon = this._dep.getSource() != null ? this._dep.getSource().getIcon() : OracleIcons.getIcon((String)"error.png");
            }
        }

        public String toString() {
            this.getLabelAndIcon();
            return this._label;
        }
    }
}

