/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.javafx.scene;

import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;

public class SceneFactory {
    private static final Logger LOGGER = Logger.getLogger(SceneFactory.class.getName());

    public static Scene createScene(Parent parent) {
        Platform.setImplicitExit((boolean)false);
        Scene scene = new Scene(parent);
        SceneFactory.addProductCss(scene);
        return scene;
    }

    private static void addProductCss(Scene scene) {
        String string = System.getProperty("ide.conf");
        String string2 = string.replace(".conf", ".css");
        File file = new File(string2);
        if (file.canRead()) {
            try {
                scene.getStylesheets().add((Object)file.toURI().toURL().toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.WARNING, file.toString(), malformedURLException);
            }
        }
    }
}

