/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.HeaderData;
import oracle.dss.util.EdgeOutOfRangeException;

public class ColHeaderData
extends HeaderData {
    protected int m_colCount = 0;

    ColHeaderData(Crosstab _crosstab) {
        super(_crosstab);
        try {
            this.m_colCount = this.dataAccess.getEdgeExtent(0);
        }
        catch (EdgeOutOfRangeException e) {
            _crosstab.getErrorHandler().error((Throwable)e, this.getClass().getName(), "ColHeaderData");
        }
        this.addColumns(0, this.getColumnCount());
        try {
            int maxDepth = this.dataAccess.getLayerCount(0);
            this.addRows(0, maxDepth == 0 ? 1 : maxDepth);
        }
        catch (EdgeOutOfRangeException e) {
            _crosstab.getErrorHandler().error((Throwable)e, this.getClass().getName(), "ColHeaderData");
        }
    }

    public int getColumnCount() {
        return this.m_colCount;
    }

    public int getRowCount() {
        return super.getRowCount();
    }

    @Override
    protected boolean isRowHeader() {
        return false;
    }
}

