/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.teardown;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.codehook.PLSQLCodeEditor;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.Teardown;
import oracle.dbtools.unit_test.teardown.TeardownArb;
import oracle.dbtools.unit_test.utils.UtUtils;

public class PlSqlTeardown
extends Teardown
implements ITeardown {
    String _name = TeardownArb.getString("CODE_TEARDOWN_NAME");
    private PLSQLCodeEditor _codeEditor = new PLSQLCodeEditor();

    public PlSqlTeardown() {
        this.onChangeEditability();
        this.setDefaultCode();
    }

    private void setDefaultCode() {
        String string = TeardownArb.getString("PLSQL_TEARDOWN_TEMPLATE");
        this._codeEditor.setCode(string);
    }

    @Override
    public String getHookName() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._codeEditor.getCode();
    }

    @Override
    protected Component createComponent() {
        return this._codeEditor.createEditorPanel(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PlSqlTeardown.this.fireChangeListeners();
            }
        });
    }

    @Override
    public String getXml() {
        String string = this._codeEditor.getCode();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        stringBuilder.append("<teardown>");
        stringBuilder.append("<class><![CDATA[" + this.getClass().getCanonicalName() + "]]></class>");
        stringBuilder.append("<name><![CDATA[" + this._name + "]]></name>");
        stringBuilder.append("<description><![CDATA[" + string + "]]></description>");
        stringBuilder.append("<code><![CDATA[" + string + "]]></code>");
        stringBuilder.append("</teardown>");
        return stringBuilder.toString();
    }

    @Override
    public void loadFromXml(String string) {
        String string2 = string != null ? UtUtils.getXmlValue(string, "teardown", "code") : "";
        this._codeEditor.setCode(string2);
        this._codeEditor.setReadOnly(!this.isEditable());
    }

    @Override
    protected void onChangeEditability() {
        this._codeEditor.setReadOnly(!this.isEditable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performWork(Connection connection, IStartup iStartup) throws Exception {
        if (Connections.getInstance().lock(connection)) {
            try (PreparedStatement preparedStatement = connection.prepareStatement(this._codeEditor.getCode());){
                preparedStatement.execute();
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

