/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.impexp;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ExportListener;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Node;

public class ExportManager {
    private Writer _writer;
    private HashSet<String> _ids = new HashSet();
    private XMLDocument _doc;
    private XMLElement _rootElem;

    public ExportManager(Writer writer, String string) {
        this._writer = writer;
        this._doc = new XMLDocument();
        this._doc.setEncoding(string);
        this._rootElem = (XMLElement)this._doc.createElement("UT");
        this._doc.appendChild((Node)this._rootElem);
    }

    public void exportTest(UtTest utTest) {
        this.exportTest(utTest, null);
    }

    public void exportSuite(UtSuite utSuite) {
        this.exportSuite(utSuite, null);
    }

    public void exportLibItem(UtLibraryItem utLibraryItem) {
        this.exportLibItem(utLibraryItem, null);
    }

    public void exportTest(String string) {
        this.exportTestById(UtUtils.getTestId(string));
    }

    public void exportSuite(String string) {
        this.exportSuiteById(UtUtils.getSuiteId(string));
    }

    public void exportLibValidation(String string) {
        this.exportLibValidationById(UtUtils.getLibValidationId(string));
    }

    public void exportLibStartup(String string) {
        this.exportLibStartupById(UtUtils.getLibStartupId(string));
    }

    public void exportLibTeardown(String string) {
        this.exportLibTeardownById(UtUtils.getLibTeardownId(string));
    }

    public void exportLibDynamicValueQuery(String string) {
        this.exportLibDynamicValueQueryById(UtUtils.getLibDynamicValueQueryId(string));
    }

    public void exportTestById(String string) {
        this.exportTest(new UtTest(string));
    }

    public void exportSuiteById(String string) {
        this.exportSuite(new UtSuite(string));
    }

    public void exportLibValidationById(String string) {
        this.exportLibItem(new UtLibraryItem(UtLibraryItem.Kind.VALIDATION, string));
    }

    public void exportLibStartupById(String string) {
        this.exportLibItem(new UtLibraryItem(UtLibraryItem.Kind.STARTUP, string));
    }

    public void exportLibTeardownById(String string) {
        this.exportLibItem(new UtLibraryItem(UtLibraryItem.Kind.TEARDOWN, string));
    }

    public void exportLibDynamicValueQueryById(String string) {
        this.exportLibItem(new UtLibraryItem(UtLibraryItem.Kind.DYNAMIC_VALUE_QUERY, string));
    }

    public void exportTest(UtTest utTest, ExportListener exportListener) {
        utTest.export(new ExportContextImpl(utTest.getClass(), exportListener));
        if (exportListener != null) {
            exportListener.onExportTest(utTest);
        }
    }

    public void exportSuite(UtSuite utSuite, ExportListener exportListener) {
        utSuite.export(new ExportContextImpl(utSuite.getClass(), exportListener));
        if (exportListener != null) {
            exportListener.onExportSuite(utSuite);
        }
    }

    public void exportLibItem(UtLibraryItem utLibraryItem, ExportListener exportListener) {
        utLibraryItem.export(new ExportContextImpl(utLibraryItem.getClass(), exportListener));
        if (exportListener != null) {
            exportListener.onExportLibraryItem(utLibraryItem);
        }
    }

    public void exportTest(String string, ExportListener exportListener) {
        this.exportTestById(UtUtils.getTestId(string), exportListener);
    }

    public void exportSuite(String string, ExportListener exportListener) {
        this.exportSuiteById(UtUtils.getSuiteId(string), exportListener);
    }

    public void exportLibValidation(String string, ExportListener exportListener) {
        this.exportLibValidationById(UtUtils.getLibValidationId(string), exportListener);
    }

    public void exportLibStartup(String string, ExportListener exportListener) {
        this.exportLibStartupById(UtUtils.getLibStartupId(string), exportListener);
    }

    public void exportLibTeardown(String string, ExportListener exportListener) {
        this.exportLibTeardownById(UtUtils.getLibTeardownId(string), exportListener);
    }

    public void exportLibDynamicValueQuery(String string, ExportListener exportListener) {
        this.exportLibDynamicValueQueryById(UtUtils.getLibDynamicValueQueryId(string), exportListener);
    }

    public void exportTestById(String string, ExportListener exportListener) {
        this.exportTest(new UtTest(string), exportListener);
    }

    public void exportSuiteById(String string, ExportListener exportListener) {
        this.exportSuite(new UtSuite(string), exportListener);
    }

    public void exportLibValidationById(String string, ExportListener exportListener) {
        this.exportLibItem(new UtLibraryItem(UtLibraryItem.Kind.VALIDATION, string), exportListener);
    }

    public void exportLibStartupById(String string, ExportListener exportListener) {
        this.exportLibItem(new UtLibraryItem(UtLibraryItem.Kind.STARTUP, string), exportListener);
    }

    public void exportLibTeardownById(String string, ExportListener exportListener) {
        this.exportLibItem(new UtLibraryItem(UtLibraryItem.Kind.TEARDOWN, string), exportListener);
    }

    public void exportLibDynamicValueQueryById(String string, ExportListener exportListener) {
        this.exportLibItem(new UtLibraryItem(UtLibraryItem.Kind.DYNAMIC_VALUE_QUERY, string), exportListener);
    }

    public void close() {
        try {
            PrintWriter printWriter = new PrintWriter(this._writer);
            try {
                this._doc.print(printWriter);
            }
            finally {
                this._writer.close();
            }
        }
        catch (IOException iOException) {
            this.logMessage(LoggerLevel.SEVERE, iOException.getMessage());
        }
    }

    private void logMessage(LoggerLevel loggerLevel, String string) {
        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string);
    }

    class ExportContextImpl
    implements ExportContext {
        private String _className;
        private XMLElement _containerElem;
        private ExportListener _listener;

        public ExportContextImpl(Class<?> clazz, ExportListener exportListener) {
            this._className = clazz.getName();
            this._listener = exportListener;
        }

        @Override
        public XMLElement createExportedElement(String string) {
            if (this._containerElem == null) {
                this._containerElem = this.createExportedElement(ExportManager.this._rootElem, "object");
                this._containerElem.setAttribute("class", this._className);
            }
            return this.createExportedElement(this._containerElem, string);
        }

        @Override
        public XMLElement createExportedElement(XMLElement xMLElement, String string) {
            XMLElement xMLElement2 = (XMLElement)ExportManager.this._doc.createElement(string);
            xMLElement.appendChild((Node)xMLElement2);
            return xMLElement2;
        }

        @Override
        public void reparentExportedElement(XMLElement xMLElement, XMLElement xMLElement2) {
            XMLElement xMLElement3 = (XMLElement)ExportManager.this._doc.adoptNode((Node)xMLElement2);
            xMLElement.appendChild((Node)xMLElement3);
        }

        @Override
        public void addCDATASection(XMLElement xMLElement, String string) {
            CDATASection cDATASection = ExportManager.this._doc.createCDATASection(string);
            xMLElement.appendChild((Node)cDATASection);
        }

        @Override
        public void exportRelatedSuite(String string) {
            if (ExportManager.this._ids.add(string)) {
                ExportManager.this.exportSuiteById(string, this._listener);
            }
        }

        @Override
        public void exportRelatedTest(String string) {
            if (ExportManager.this._ids.add(string)) {
                ExportManager.this.exportTestById(string, this._listener);
            }
        }

        @Override
        public void exportRelatedLibValidation(String string) {
            if (ExportManager.this._ids.add(string)) {
                ExportManager.this.exportLibValidationById(string, this._listener);
            }
        }

        @Override
        public void exportRelatedLibStartup(String string) {
            if (ExportManager.this._ids.add(string)) {
                ExportManager.this.exportLibStartupById(string, this._listener);
            }
        }

        @Override
        public void exportRelatedLibTeardown(String string) {
            if (ExportManager.this._ids.add(string)) {
                ExportManager.this.exportLibTeardownById(string, this._listener);
            }
        }

        @Override
        public void exportRelatedLibDynamicValueQuery(String string) {
            if (ExportManager.this._ids.add(string)) {
                ExportManager.this.exportLibDynamicValueQueryById(string, this._listener);
            }
        }

        @Override
        public void log(LoggerLevel loggerLevel, String string) {
            ExportManager.this.logMessage(loggerLevel, string);
        }
    }
}

